/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.Auth.LDAPHelper;

import LinkFuture.Core.Auth.LDAPHelper.LDAPUser;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPHelper {
    static final Logger logger = LoggerFactory.getLogger(LDAPHelper.class);
    static String ldapPrincipal;
    static String ldapPassword;
    static String ldapUrl;
    static String ldapCertificatePath;
    static boolean ldapIsSSL;
    static String ldapFactory;
    static String ldapAuthenticationMethod;
    static String ldapSearchBase;

    public static String getLdapPrincipal() {
        return ldapPrincipal;
    }

    public void setLdapPrincipal(String ldapPrincipal) {
        LDAPHelper.ldapPrincipal = ldapPrincipal;
    }

    public static String getLdapPassword() {
        return ldapPassword;
    }

    public void setLdapPassword(String ldapPassword) {
        LDAPHelper.ldapPassword = ldapPassword;
    }

    public static String getLdapUrl() {
        return ldapUrl;
    }

    public void setLdapUrl(String ldapUrl) {
        LDAPHelper.ldapUrl = ldapUrl;
    }

    public static String getLdapCertificatePath() {
        return ldapCertificatePath;
    }

    public void setLdapCertificatePath(String ldapCertificatePath) {
        LDAPHelper.ldapCertificatePath = ldapCertificatePath;
        if (ldapCertificatePath != null && ldapCertificatePath.length() > 0) {
            System.setProperty("javax.net.ssl.trustStore", ldapCertificatePath);
        }
    }

    public static boolean getLdapIsSSL() {
        return ldapIsSSL;
    }

    public void setLdapIsSSL(boolean ldapIsSSL) {
        LDAPHelper.ldapIsSSL = ldapIsSSL;
    }

    public static String getLdapFactory() {
        return ldapFactory;
    }

    public void setLdapFactory(String ldapFactory) {
        LDAPHelper.ldapFactory = ldapFactory;
    }

    public static String getLdapAuthenticationMethod() {
        return ldapAuthenticationMethod;
    }

    public void setLdapAuthenticationMethod(String ldapAuthenticationMethod) {
        LDAPHelper.ldapAuthenticationMethod = ldapAuthenticationMethod;
    }

    public static String getLdapSearchBase() {
        return ldapSearchBase;
    }

    public void setLdapSearchBase(String ldapSearchBase) {
        LDAPHelper.ldapSearchBase = ldapSearchBase;
    }

    public static List<String> findWindowsDomainController(String ldapDomain) throws NamingException {
        ArrayList<String> servers = new ArrayList<String>();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("java.naming.provider.url", "dns:");
        InitialDirContext ctx = new InitialDirContext(env);
        Attributes attributes = ctx.getAttributes("_ldap._tcp." + ldapDomain, new String[]{"SRV"});
        Attribute a = attributes.get("SRV");
        for (int i = 0; i < a.size(); ++i) {
            String srvRecord = a.get(i).toString();
            String wrksrv = srvRecord.split(" ")[3];
            servers.add(wrksrv.substring(0, wrksrv.length() - 1));
        }
        ctx.close();
        return servers;
    }

    private static String findLdapAuthServer(String ldapDomain) throws NamingException {
        List<String> ldapAuthServers = LDAPHelper.findWindowsDomainController(ldapDomain);
        if (ldapAuthServers == null || ldapAuthServers.size() == 0) {
            throw new NamingException("No domain controllers found");
        }
        return "ldap://" + ldapAuthServers.get(0);
    }

    private static String domainParse(String dcName) {
        StringBuffer sb = new StringBuffer(20);
        StringTokenizer st = new StringTokenizer(dcName, "DC=");
        while (st.hasMoreElements()) {
            String element = st.nextToken();
            if (element.endsWith(",")) {
                sb.append(element.substring(0, element.length() - 1) + ".");
                continue;
            }
            sb.append(element);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LDAPUser auth(String name, String password) throws NamingException {
        try (Context context = null;){
            LDAPUser user = LDAPHelper.getUserInfo(name);
            String ldapDomain = LDAPHelper.domainParse(user.getDCName());
            if (user != null) {
                Properties props = new Properties();
                props.put("java.naming.factory.initial", ldapFactory);
                props.put("java.naming.provider.url", LDAPHelper.findLdapAuthServer(ldapDomain));
                props.put("java.naming.security.principal", user.getUserDN());
                props.put("java.naming.security.credentials", password);
                if (ldapIsSSL) {
                    props.put("java.naming.security.protocol", "ssl");
                }
                context = new InitialDirContext(props);
                LDAPUser lDAPUser = user;
                return lDAPUser;
            }
        }
        return null;
    }

    public static LDAPUser getUserInfo(String alias) throws NamingException {
        LDAPUser user = null;
        String domain = null;
        String[] userAccount = alias.split("\\\\");
        if (userAccount.length == 2) {
            domain = userAccount[0];
            alias = userAccount[1];
        }
        Properties props = new Properties();
        props.put("java.naming.factory.initial", ldapFactory);
        props.put("java.naming.provider.url", ldapUrl);
        props.put("java.naming.security.authentication", ldapAuthenticationMethod);
        props.put("java.naming.security.principal", ldapPrincipal);
        props.put("java.naming.security.credentials", ldapPassword);
        props.put("com.sun.jndi.ldap.connect.timeout", "2000");
        if (ldapIsSSL) {
            props.put("java.naming.security.protocol", "ssl");
            props.put("java.naming.ldap.factory.socket", "com.hibu.smml.security.factory.CustomSocketFactory");
        }
        InitialLdapContext context = new InitialLdapContext(props, null);
        SearchControls ctrls = new SearchControls();
        ctrls.setReturningAttributes(new String[]{"distinguishedName", "displayName", "mail", "memberof", "msDS-SourceObjectDN"});
        ctrls.setSearchScope(2);
        ctrls.setTimeLimit(3000);
        String filter = "(&(objectClass=user)(sAMAccountName=" + alias + "))";
        NamingEnumeration<SearchResult> answers = context.search(ldapSearchBase, filter, ctrls);
        if (answers != null && answers.hasMoreElements()) {
            SearchResult result = (SearchResult)answers.nextElement();
            Attributes attrs = result.getAttributes();
            user = new LDAPUser();
            user.setAlias(alias);
            user.setEmail(LDAPHelper.readLDAPAttr(attrs, "mail"));
            user.setNameInNameSpace(LDAPHelper.readLDAPAttr(attrs, "distinguishedName"));
            user.setUserDN(LDAPHelper.readLDAPAttr(attrs, "msDS-SourceObjectDN"));
            user.setDisplayName(LDAPHelper.readLDAPAttr(attrs, "displayName"));
            user.setDomain(domain);
            user.setGroups(LDAPHelper.readLDAPAttrList(attrs, "memberof"));
        }
        if (answers != null) {
            answers.close();
        }
        context.close();
        return user;
    }

    private static String readLDAPAttr(Attributes attrs, String attrName) throws NamingException {
        Attribute attribute = attrs.get(attrName);
        if (attribute != null) {
            return attribute.get().toString();
        }
        return null;
    }

    private static List<String> readLDAPAttrList(Attributes attrs, String attrName) throws NamingException {
        Attribute attribute = attrs.get(attrName);
        if (attribute != null) {
            ArrayList<String> output = new ArrayList<String>();
            NamingEnumeration<?> e = attribute.getAll();
            while (e.hasMore()) {
                String mname = (String)e.next();
                output.add(LDAPHelper.getCN(mname));
            }
            return output;
        }
        return null;
    }

    private static String getCN(String cnName) {
        int position;
        if (cnName != null && cnName.toUpperCase().startsWith("CN=")) {
            cnName = cnName.substring(3);
        }
        if ((position = cnName.indexOf(44)) == -1) {
            return cnName;
        }
        return cnName.substring(0, position);
    }

    static {
        ldapFactory = "com.sun.jndi.ldap.LdapCtxFactory";
        ldapAuthenticationMethod = "Simple";
        ldapSearchBase = "ldap.search.base";
    }
}

