package LinkFuture.Init.ConfigurationManager;

import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.StringExtension;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.net.PasswordAuthentication;

/**
 * Created by Cyokin on 3/1/14.
 * ProxySettingsInfo
 */
@XmlRootElement(name="ProxySettings")
public class ProxySettingsInfo {
    @XmlElement(name="HttpProxy")
    public ProxyInfo HttpProxy;
    @XmlElement(name="HttpsProxy")
    public ProxyInfo HttpsProxy;

    void SetupProxy(){
        if(this.HttpProxy!=null)
        {
            Debugger.LogFactory.info("Enable http proxy,{}:{}", this.HttpProxy.Host,this.HttpProxy.Port);
            System.setProperty("http.proxyHost", this.HttpProxy.Host);
            System.setProperty("http.proxyPort", this.HttpProxy.Port);
            if(!StringExtension.IsNullOrEmpty(this.HttpProxy.UserName) && !StringExtension.IsNullOrEmpty(this.HttpProxy.Password))
            {
                this.HttpProxy.Ticket = new PasswordAuthentication(this.HttpProxy.UserName,this.HttpProxy.Password.toCharArray());
            }
        }
        if(this.HttpsProxy!=null)
        {
            Debugger.LogFactory.info("Enable https proxy,{}:{}", this.HttpsProxy.Host,this.HttpsProxy.Port);
            System.setProperty("https.proxyHost", this.HttpsProxy.Host);
            System.setProperty("https.proxyPort", this.HttpsProxy.Port);
            if(!StringExtension.IsNullOrEmpty(this.HttpsProxy.UserName) && !StringExtension.IsNullOrEmpty(this.HttpsProxy.Password))
            {
                this.HttpsProxy.Ticket = new PasswordAuthentication(this.HttpsProxy.UserName,this.HttpsProxy.Password.toCharArray());
            }
        }
    }
}
