package LinkFuture.Core.MemoryManager.StaticMemoryCache;

import LinkFuture.Core.MemoryManager.IMemoryController;
import LinkFuture.Core.MemoryManager.Meta.MemoryCacheMetaInfo;
import LinkFuture.Core.MemoryManager.Meta.MemoryCacheType;
import LinkFuture.Core.OperationManager.Operation;

/**
 * Created by Cyokin on 12/16/2014.
 */
public class StaticMemoryCacheController implements IMemoryController {
    @Override
    public void AddNeverExpiredMemoryCache(String key, Operation operation) throws Exception {
        StaticMemoryCacheHelper.AddNeverExpiredMemoryCache(key,operation);
    }

    @Override
    public void AddMemoryCache(MemoryCacheMetaInfo meta) throws Exception {
        StaticMemoryCacheHelper.AddMemoryCache(meta);
    }

    @Override
    public String GetMemory(String key) {
        MemoryCacheMetaInfo meta = new MemoryCacheMetaInfo();
        meta.CacheType = MemoryCacheType.Absolute;
        meta.Key = key;
        meta.Enable = true;
        String result =  StaticMemoryCacheHelper.GetMemory(meta);
        if(result==null)
        {
            meta.CacheType = MemoryCacheType.Never;
            return StaticMemoryCacheHelper.GetMemory(meta);
        }
        return null;
    }

    @Override
    public void ClearCache(String key) {
        MemoryCacheMetaInfo meta = new MemoryCacheMetaInfo();
        meta.CacheType = MemoryCacheType.Absolute;
        meta.Key = key;
        meta.Enable = true;
        boolean isSuccess = StaticMemoryCacheHelper.Del(meta);
        if(!isSuccess)
        {
            //Delete from never
            meta.CacheType = MemoryCacheType.Never;
            StaticMemoryCacheHelper.Del(meta);
        }
    }
}
