package LinkFuture.Core.DBHelper.Model;

import LinkFuture.Core.DBHelper.DBHelper;
import LinkFuture.Init.Extensions.StringExtension;

import java.sql.Types;
import java.util.ArrayList;

/**
 * User: Cyokin Zhang
 * Date: 9/25/13
 * Time: 1:49 PM
 */
public class ColumnInfo {
    @DBColumnAttribute(columnName = "COLUMN_NAME")
    public String columnName;
    @DBColumnAttribute(columnName = "COLUMN_SIZE")
    public int columnSize;
    @DBColumnAttribute(columnName = "DATA_TYPE")
    public int sqlType;
    @DBColumnAttribute(columnName = "TYPE_NAME")
    public String sqlTypeName;
    public String javaClassName;
    @DBColumnAttribute(columnName = "IS_NULLABLE")
    public boolean nullable;
    @DBColumnAttribute(columnName = "IS_AUTOINCREMENT")
    public boolean autoIncrement;
    @DBColumnAttribute(columnName = "ORDINAL_POSITION")
    public int position;
    @DBColumnAttribute(columnName = "COLUMN_DEF")
    public String defaultValue;

    public boolean isKey;

    //sub column if it is composite type or array with composite type
    public ArrayList<ColumnInfo> columnList = new ArrayList<>();

    public String toString(){
        return String.format("%s(%s - %s) :%s",this.columnName,this.sqlTypeName,this.javaClassName, this.isKey);
    }

    private String arrayElementTypeName;
    public String getArrayElementTypeName(){
        if(StringExtension.IsNullOrEmpty(arrayElementTypeName))
        {
             if(sqlType== Types.ARRAY)
             {
                 arrayElementTypeName = sqlTypeName.substring(1);
             }
        }
        return arrayElementTypeName;
    }

    private Integer arrayElementType = null;
    public Integer getArrayElementType() throws IllegalAccessException {
        if(arrayElementType==null)
        {
            if(sqlType== Types.ARRAY)
            {
                return DBHelper.sqlTypeNameToType(getArrayElementTypeName());
            }
        }
        return arrayElementType;
    }

    public ColumnInfo getStructElementColumn(String elementName)
    {
        if(this.sqlType == Types.STRUCT)
        {
            for (ColumnInfo column:this.columnList)
            {
                if(column.columnName.equalsIgnoreCase(elementName))
                {
                   return column;
                }
            }
            throw new IllegalArgumentException(String.format("We can't find element %s in this struct",elementName));
        }
        throw new IllegalArgumentException("This is not struct type");
    }

    public boolean sameColumnName(String columnName){
        if(sqlType==Types.STRUCT)
        {
            int subQueryIndex = columnName.indexOf(".");
            if(subQueryIndex >0)
            {
                columnName = columnName.substring(0,subQueryIndex);
            }
        }
        return this.columnName.equalsIgnoreCase(columnName);
    }
    public boolean isSqlJsonType(){
        //noinspection SpellCheckingInspection
        return (sqlTypeName.equalsIgnoreCase("json") ||  sqlTypeName.equalsIgnoreCase("jsonb") && this.sqlType ==Types.OTHER);
    }
    @SuppressWarnings("unused")
    public boolean isSqlBoolType(){
        return (this.sqlType ==Types.BOOLEAN ||  (sqlTypeName.equalsIgnoreCase("bool") && this.sqlType ==Types.BIT));
    }
    public boolean isSqlTimeStampType(){
        return (this.sqlType ==Types.TIMESTAMP &&  javaClassName.equalsIgnoreCase("java.sql.Timestamp"));
    }
    @SuppressWarnings("unused")
    public boolean isUUIDType(){
        return (this.sqlType ==Types.OTHER &&  sqlTypeName.equalsIgnoreCase("uuid"));
    }
    @SuppressWarnings("unused")
    public boolean isSerialType(){
        return sqlTypeName.equalsIgnoreCase("serial");
    }
    @SuppressWarnings("unused")
    public boolean isPasswordType(){
        return (this.sqlType ==Types.OTHER &&  sqlTypeName.equalsIgnoreCase("chkpass"));
    }
    @SuppressWarnings("unused")
    public boolean hasDefaultValue(){
        return !StringExtension.IsNullOrEmpty(this.defaultValue);
    }
    public String getJavaClassNameBySqlType(){
        if(isUUIDType())
        {
            return "java.util.UUID";
        }
        if(isSerialType())
        {
            return "Long";
        }
        if(isUnknownJavaType())
        {
            return "[mapping java object here]";
        }
        if(isPasswordType()){
            return "String";
        }
        if(this.sqlType == Types.ARRAY)
        {
            return DBHelper.postgreSQLTypeNameToJava.get(this.getArrayElementTypeName()) + "[]";
        }
        return  DBHelper.sqlTypeToJava.get(this.sqlType);
    }
    public boolean isUnknownJavaType(){
        return isSqlJsonType() || this.sqlType ==Types.STRUCT;
    }

    public boolean isNumberType(){
        return DBHelper.numberTypes.contains(this.sqlType);
    }
    public boolean isDateType(){
        return this.sqlType == Types.TIMESTAMP || this.sqlType == Types.DATE;
    }
}