package LinkFuture.Core.ContentManager.ContentSecurity;

import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.SecurityInfo;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.SecurityExtension;

/**
 * Created by Cyokin
 * on 3/23/2016.
 */
public class ContentRSASecurity extends ContentBeanBaseSecurity<ContentRSAMetaInfo> {
    public ContentRSASecurity(SecurityInfo currentSecurity) throws Exception {
        super(currentSecurity, ContentRSAMetaInfo.class);
    }

    @Override
    public void Verify(ContentItemInfo content, ContentParameterCollectionInfo parameters) throws Exception {
        Debugger.LogFactory.trace("RSA Authorization");
        if(parameters.containsKey("LF_Authorization"))
        {
            try
            {
                String auth = (String)parameters.get("LF_Authorization");
                String decrypt= SecurityExtension.RSADecryptFromBase64(auth, SecurityExtension.RSAGetPrivateKeyFromBase64(this.Meta.Base64PrivateKey.trim()));
                Debugger.LogFactory.trace("RSA decrypt value is {}",decrypt);
                if(Math.abs(System.currentTimeMillis() - Long.parseLong(decrypt)) > this.Meta.TimeGapInSecond * 1000)
                {
                    Debugger.LogFactory.trace("Authorization token has been expired");
                    throw new SecurityException("Authorization token has been expired");
                }
            }
            catch (Exception e)
            {
                Debugger.fatal("Authorization failed",e);
                throw new SecurityException("Authorization failed");
            }
        }
        else
        {
            Debugger.LogFactory.trace("Authorization failed");
            throw new SecurityException("Authorization failed");
        }
    }
}
