package LinkFuture.Core.ContentManager.ContentResource;

import LinkFuture.Core.ContentManager.Model.ResourceRunningInfo;
import LinkFuture.Init.Extensions.StringExtension;

/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 10:48 AM
 */
public abstract class ContentBeanBaseResource<T> extends ContentBaseResource {
    public ContentBeanBaseResource(ResourceRunningInfo runningInfo,Class<T> type) throws Exception {
        super(runningInfo);
        if (this.CurrentResource != null && !StringExtension.IsNullOrEmpty(this.CurrentResource.Meta))
        {
            runningInfo.resource.setMetaObj(type);
            this.Meta = runningInfo.resource.getMetaObj();
            this.Verify(runningInfo.resource);
        }
    }
    public T Meta;
}
