package LinkFuture.Core.ContentManager.ContentAction;

import LinkFuture.Core.ContentManager.ContentProcessor.IContentProcessor;
import LinkFuture.Core.ContentManager.ContentResource.ContentBaseResource;
import LinkFuture.Core.ContentManager.ContentResource.IContentResource;
import LinkFuture.Core.ContentManager.ContentSecurity.IContentSecurity;
import LinkFuture.Core.ContentManager.ContentSelector.ContentSelectorController;
import LinkFuture.Core.ContentManager.ContentValidator.IContentValidator;
import LinkFuture.Core.ContentManager.Model.*;
import LinkFuture.Core.MemoryManager.MemoryFactory;
import LinkFuture.Init.Debugger;
import LinkFuture.Core.MemoryManager.Meta.MemoryCacheMetaInfo;
import LinkFuture.Core.MemoryManager.StaticMemoryCache.StaticMemoryCacheHelper;
import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Core.OperationManager.OperationController;

import java.util.ArrayList;
import java.util.List;

/**
 * User: Cyokin Zhang
 * Date: 11/20/13
 * Time: 3:28 PM
 */
public class ContentBaseAction implements IContentAction {
    ContentActionInfo actionMeta;
    public ContentBaseAction(ContentActionInfo actionMeta){
        this.actionMeta = actionMeta;
        this.Init();
    }
    @Override
    public void Init() {

    }
    @Override
    public ContentResultCollectionInfo Action() throws Exception {
        ContentParameterCollectionInfo parameters =  this.actionMeta.BuildContentParameter();
        MemoryCacheMetaInfo meta = MemoryFactory.FindMemoryCache(this.actionMeta.ContentItem.CacheSettingKey);
        Object[] passArgs= new Object[] {
                parameters
                ,this.actionMeta
        };
        if(meta==null || !meta.Enable)
        {
            return LoadContentCallback(passArgs);
        }
        else
        {
            meta.Key  = this.actionMeta.IdentityKey(parameters);
            Debugger.LogFactory.trace("Content item: {} =>{}", actionMeta.ContentItem.Name, meta.Key);
            meta.Action = new Operation<Object>(passArgs) {
                @Override
                public Object call() throws Exception {
                    return LoadContentCallback(this.params);
                }
            };
            return StaticMemoryCacheHelper.AddMemoryCache(meta);
        }
    }

    private static ContentResultCollectionInfo LoadContentCallback(Object... args) throws Exception {
        ContentParameterCollectionInfo parameters = (ContentParameterCollectionInfo)args[0];
        ContentActionInfo action = (ContentActionInfo)args[1];
        ContentItemInfo contentItem = action.ContentItem;
        Debugger.LogFactory.trace("Retrieve Content:{}-{}", contentItem.Name,contentItem.Version);

        //Only apply security when with http request
        if(!action.IgnoreSecurity)
        {
            for(IContentSecurity item:action.SecurityList)
            {
                item.Verify(contentItem,parameters);
            }
        }
        //validation
        for(IContentValidator item:action.ValidatorList)
        {
            item.Valid(parameters);
        }
        ContentResultCollectionInfo resultList = new ContentResultCollectionInfo();

        for(ArrayList<IContentResource> resourcesList:action.ResourceList)
        {
             if(resourcesList.size()==1)
             {
                 ContentBaseResource currentResource= (ContentBaseResource)resourcesList.get(0);
                 if(currentResource.MatchCondition(contentItem,parameters))
                 {
                     ContentResultInfo result = currentResource.GerResource(contentItem, parameters);
                     resultList.add(result);
                     parameters.put("$"+result.Name,result);
                     ContentSelectorController.BuilderSelector(currentResource.CurrentAdd, parameters, AddCycleType.After);
                 }
             }
             else
             {
                 List<Operation<ContentResultInfo>> tasks = new ArrayList<>();
                 for(IContentResource resource:resourcesList)
                 {
                     if(resource.MatchCondition(contentItem,parameters))
                     {
                         tasks.add(new Operation<ContentResultInfo>(resource,contentItem, parameters) {
                             @Override
                             public ContentResultInfo call() throws Exception {
                                 ContentBaseResource subResource = (ContentBaseResource)this.params[0];
                                 ContentItemInfo contentItem = (ContentItemInfo)this.params[1];
                                 ContentParameterCollectionInfo parameters = (ContentParameterCollectionInfo)this.params[2];
                                 return subResource.GerResource(contentItem, parameters);
                             }
                         });
                     }
                 }
                 List<ContentResultInfo> parallelResult = OperationController.runInParallel(tasks);
                 for (ContentResultInfo item:parallelResult)
                 {
                     resultList.add(item);
                     parameters.put("$"+item.Name,item);
                     ContentSelectorController.BuilderSelector(item.Add, parameters, AddCycleType.After);
                 }
             }
        }
        if(!action.ResourceOnly && resultList.size()>0)
        {
            for(IContentProcessor processor:action.ProcessorList)
            {
                if(processor.MatchCondition(contentItem,parameters)) {
                    processor.Transformer(resultList, parameters);
                }
            }
        }
        resultList.Params = parameters;
        //parameters.clear();
        return resultList;
    }

    @Override
    public void Destroy() {
        //To change body of implemented methods use File | Settings | File Templates.
    }
}
