/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Init;

import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.StringExtension;
import java.util.TimeZone;
import javax.naming.InitialContext;

public class Config {
    public static final String DefaultTimeFormat = "yyyy-MM-dd HH:mm:ss.SSSZZZ";
    public static final String ISO8601TimeFormat = "yyyy/MM/dd'T'HH:mm:ss.SSS'Z'";
    public static final TimeZone UTCTimeZone = TimeZone.getTimeZone("UTC");
    public static final String NewLine = System.getProperty("line.separator");
    public static final String DefaultEncoding = "UTF-8";
    public static final String Empty = "";
    public static final String Version = "2.0.7";
    public static final String ClassPath = "classpath:";
    public static final String keyTotalCount = "__pg_total_count";
    public static final String keyPageLimit = "__pg_limit";
    public static final String keyPageOffset = "__pg_offset";
    public static final String FileSeparator = System.getProperty("file.separator");
    public static final int MaxParallelThread = 10;
    private static String applicationConfigurationFilePath;

    private static String readConfigFilePath() {
        try {
            InitialContext cxt = new InitialContext();
            return cxt.lookup("java:/comp/env/LinkFuture/config_filePath").toString();
        }
        catch (Exception e) {
            Debugger.LogFactory.warn("No InitialContext(java:/comp/env/LinkFuture/config_filePath) , using default file name lf.xml.");
            return "classpath:lf.xml";
        }
    }

    public void setConfigFilePath(String configPath) {
        applicationConfigurationFilePath = configPath;
    }

    public static String getConfigFilePath() {
        if (StringExtension.IsNullOrEmpty(applicationConfigurationFilePath)) {
            applicationConfigurationFilePath = Config.readConfigFilePath();
        }
        return applicationConfigurationFilePath;
    }
}

