/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.MemoryManager.StaticMemoryCache;

import LinkFuture.Core.MemoryManager.MemoryFactory;
import LinkFuture.Core.MemoryManager.Meta.MemoryCacheMetaInfo;
import LinkFuture.Core.MemoryManager.Meta.MemoryCacheType;
import LinkFuture.Core.MemoryManager.StaticMemoryCache.StaticMemoryCacheInfo;
import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Init.Debugger;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class StaticMemoryCacheHelper {
    private static final Map<String, StaticMemoryCacheInfo> refreshedCachedObject = new ConcurrentHashMap<String, StaticMemoryCacheInfo>();
    private static final Map<String, StaticMemoryCacheInfo> neverExpiredCachedObject = new ConcurrentHashMap<String, StaticMemoryCacheInfo>();
    private static final int MemoryCacheInterval = MemoryFactory.ConfigurationMeta == null ? 1000 : MemoryFactory.ConfigurationMeta.getMemoryCacheInterval();
    private static Timer timer = new Timer();
    private static TimerTask timeTask = new TimerTask(){

        @Override
        public void run() {
            StaticMemoryCacheHelper.refreshMemory();
        }
    };

    public static Map<String, StaticMemoryCacheInfo> MemoryObjectFactory(MemoryCacheType type) {
        switch (type) {
            case Absolute: {
                return refreshedCachedObject;
            }
        }
        return neverExpiredCachedObject;
    }

    public static <T> T AddNeverExpiredMemoryCache(String key, Operation operation) throws Exception {
        MemoryCacheMetaInfo meta = new MemoryCacheMetaInfo();
        meta.CacheType = MemoryCacheType.Never;
        meta.Key = key;
        meta.Enable = true;
        meta.Action = operation;
        return StaticMemoryCacheHelper.AddMemoryCache(meta);
    }

    public static <T> T AddMemoryCache(MemoryCacheMetaInfo meta) throws Exception {
        if (!meta.Enable) {
            return (T)meta.Action.call();
        }
        Map<String, StaticMemoryCacheInfo> cachedObject = StaticMemoryCacheHelper.MemoryObjectFactory(meta.CacheType);
        if (!cachedObject.containsKey(meta.getUniqueKey())) {
            StaticMemoryCacheHelper.RunAction(meta, System.currentTimeMillis());
        }
        return (T)cachedObject.get((Object)meta.getUniqueKey()).CachedObject;
    }

    public static void ClearCache(MemoryCacheMetaInfo meta) {
        Debugger.LogFactory.trace("removing {}", (Object)meta.getUniqueKey());
        Map<String, StaticMemoryCacheInfo> cachedObject = StaticMemoryCacheHelper.MemoryObjectFactory(meta.CacheType);
        if (cachedObject.containsKey(meta.getUniqueKey())) {
            cachedObject.remove(meta.getUniqueKey());
        }
    }

    public static <T> T GetMemory(MemoryCacheMetaInfo meta) {
        Map<String, StaticMemoryCacheInfo> cachedObject = StaticMemoryCacheHelper.MemoryObjectFactory(meta.CacheType);
        if (cachedObject.containsKey(meta.getUniqueKey())) {
            return (T)cachedObject.get((Object)meta.getUniqueKey()).CachedObject;
        }
        return null;
    }

    public static <T> T GetNeverExpiredMemoryCache(String key) {
        MemoryCacheMetaInfo meta = new MemoryCacheMetaInfo();
        meta.CacheType = MemoryCacheType.Never;
        meta.Key = key;
        meta.Enable = true;
        return StaticMemoryCacheHelper.GetMemory(meta);
    }

    private static void RunAction(MemoryCacheMetaInfo meta, long currentTime) throws Exception {
        StaticMemoryCacheInfo memory = new StaticMemoryCacheInfo();
        memory.CachedObject = meta.Action.call();
        memory.CachedTime = currentTime;
        memory.Meta = meta;
        if (meta.CacheType == MemoryCacheType.Absolute) {
            memory.NextExpiredTime = currentTime + meta.getTimeSpan().getTimeStamp();
        }
        Map<String, StaticMemoryCacheInfo> cachedObject = StaticMemoryCacheHelper.MemoryObjectFactory(meta.CacheType);
        cachedObject.put(meta.getUniqueKey(), memory);
    }

    private static void refreshMemory() {
        long currentTime = System.currentTimeMillis();
        for (StaticMemoryCacheInfo memory : refreshedCachedObject.values()) {
            if (Math.abs(memory.NextExpiredTime - currentTime) >= (long)(MemoryCacheInterval / 2) && currentTime <= memory.NextExpiredTime) continue;
            if (memory.Meta.AutoRefresh) {
                try {
                    StaticMemoryCacheHelper.RunAction(memory.Meta, currentTime);
                }
                catch (Exception e) {
                    Debugger.LogFactory.error("Refresh memory exception", (Throwable)e);
                }
                continue;
            }
            StaticMemoryCacheHelper.ClearCache(memory.Meta);
        }
    }

    public static String GetMemoryStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("<MemoryController>");
        for (StaticMemoryCacheInfo memory : refreshedCachedObject.values()) {
            sb.append(memory.toString());
        }
        for (StaticMemoryCacheInfo memory : neverExpiredCachedObject.values()) {
            sb.append(memory.toString());
        }
        sb.append("</MemoryController>");
        return sb.toString();
    }

    public static void Destroy() {
        refreshedCachedObject.clear();
        neverExpiredCachedObject.clear();
        if (timeTask != null) {
            timeTask.cancel();
            timeTask = null;
        }
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
    }

    public static boolean Del(MemoryCacheMetaInfo meta) {
        Map<String, StaticMemoryCacheInfo> myMemory = StaticMemoryCacheHelper.MemoryObjectFactory(meta.CacheType);
        return myMemory.remove(meta.getUniqueKey()) != null;
    }

    static {
        timer.scheduleAtFixedRate(timeTask, new Date(), (long)MemoryCacheInterval);
    }
}

