/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.MemoryManager.Redis;

import LinkFuture.Core.MemoryManager.IMemoryController;
import LinkFuture.Core.MemoryManager.Meta.MemoryCacheMetaInfo;
import LinkFuture.Core.MemoryManager.Redis.RedisHelper;
import LinkFuture.Core.OperationManager.Operation;
import java.net.URI;

public class RedisMemoryController
implements IMemoryController {
    private RedisHelper redis;

    public RedisMemoryController(String redisServers) {
        try {
            this.redis = new RedisHelper(new URI(redisServers), 60000);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void AddNeverExpiredMemoryCache(String key, Operation operation) throws Exception {
        Object result = operation.call();
        if (result instanceof String) {
            this.redis.set(key, (String)result);
            return;
        }
        if (result instanceof Throwable) {
            this.redis.setObject(key, (Throwable)result);
            return;
        }
        if (result instanceof byte[]) {
            this.redis.setByte(key, (byte[])result);
            return;
        }
    }

    @Override
    public void AddMemoryCache(MemoryCacheMetaInfo meta) throws Exception {
        if (meta.Enable) {
            String key = meta.getUniqueKey();
            Object result = meta.Action.call();
            if (result instanceof String) {
                this.redis.set(key, (String)result, (int)meta.Duration);
                return;
            }
            throw new IllegalArgumentException("Redis cache value can only be String type");
        }
    }

    @Override
    public String GetMemory(String key) {
        return this.redis.get(key);
    }

    @Override
    public void ClearCache(String key) {
        this.redis.del(key);
    }
}

