/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.MemoryManager;

import LinkFuture.Core.MemoryManager.IMemoryController;
import LinkFuture.Core.MemoryManager.Meta.MemoryCacheMetaInfo;
import LinkFuture.Core.MemoryManager.Meta.MemoryCacheSettingInfo;
import LinkFuture.Core.MemoryManager.Meta.MemoryCacheSettingListInfo;
import LinkFuture.Core.MemoryManager.Meta.MemoryCacheSolution;
import LinkFuture.Core.MemoryManager.Redis.RedisMemoryController;
import LinkFuture.Core.MemoryManager.StaticMemoryCache.StaticMemoryCacheController;
import LinkFuture.Core.Utility;
import LinkFuture.Init.ConfigurationManager.ConfigurationController;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.StringExtension;

public class MemoryFactory {
    public static final MemoryCacheSettingListInfo ConfigurationMeta = MemoryFactory.Read();

    private static MemoryCacheSettingListInfo Read() {
        try {
            return Utility.fromXml(LinkFuture.Init.Utility.getStringFromFile(ConfigurationController.AppSettings("MemoryCatchFilePath")), MemoryCacheSettingListInfo.class);
        }
        catch (Exception ex) {
            Debugger.LogFactory.error("Init memory setting failed", (Throwable)ex);
            throw new RuntimeException("Init memory setting failed, due to", ex);
        }
    }

    public static MemoryCacheMetaInfo FindMemoryCache(String cacheSettingName) {
        if (ConfigurationMeta == null || !MemoryFactory.ConfigurationMeta.SettingList.containsKey(cacheSettingName)) {
            return null;
        }
        MemoryCacheSettingInfo setting = MemoryFactory.ConfigurationMeta.SettingList.get(cacheSettingName);
        MemoryCacheMetaInfo meta = new MemoryCacheMetaInfo();
        meta.Duration = setting.Duration;
        meta.CacheSettingName = setting.CacheSettingName;
        meta.AutoRefresh = setting.AutoRefresh;
        meta.Enable = setting.Enable;
        meta.CacheType = setting.CacheType;
        return meta;
    }

    public static IMemoryController FindMemoryCacheAdapter(MemoryCacheSettingInfo setting) {
        if (setting.Solution == MemoryCacheSolution.Redis && !StringExtension.IsNullOrEmpty(setting.RedisUrl)) {
            return new RedisMemoryController(setting.RedisUrl);
        }
        return new StaticMemoryCacheController();
    }
}

