/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.JsonManager;

import LinkFuture.Core.DBHelper.Model.ColumnInfo;
import LinkFuture.Core.DBHelper.Model.TableInfo;
import LinkFuture.Core.JsonManager.JsonObjectInfo;
import LinkFuture.Core.JsonManager.JsonObjectReader;
import LinkFuture.Core.JsonManager.JsonOptionInfo;
import LinkFuture.Core.JsonManager.JsonValueOption;
import LinkFuture.Init.Extensions.StringExtension;
import java.util.ArrayList;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;

public class JsonController {
    public static boolean isJsonObject(String jsonString) {
        return (jsonString = jsonString.trim()).startsWith("{") && jsonString.endsWith("}");
    }

    public static String convertJsonToXml(String jsonString) {
        if (jsonString.startsWith("{")) {
            JSONObject jsonObject = new JSONObject(jsonString);
            return XML.toString((Object)jsonObject);
        }
        JSONArray jsonObject = new JSONArray(jsonString);
        return XML.toString((Object)jsonObject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String convertXmlToJson(String xmlString, JsonOptionInfo option) {
        try (JsonObjectReader reader = new JsonObjectReader(xmlString);){
            JsonObjectInfo root = reader.toJsonObj();
            if (option.IgnoreRoot) {
                String string = root.toChildJson(option);
                return string;
            }
            String string = root.toJson(option);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String convertXmlToJson(String xmlString) {
        JsonOptionInfo option = new JsonOptionInfo();
        option.AttributePrefix = "";
        option.NamespacePrefix = "";
        option.IgnoreNamespace = true;
        option.IgnoreRoot = false;
        option.CDataNodeName = "Content";
        option.ValueOption = JsonValueOption.AllString;
        return JsonController.convertXmlToJson(xmlString, option);
    }

    public static JSONObject sqlStructToJSON(String value, TableInfo structInfo) {
        if (value.startsWith("(")) {
            value = value.substring(1, value.length() - 1);
        }
        JSONObject output = new JSONObject();
        String[] valueList = value.split(",");
        for (int i = 0; i < valueList.length; ++i) {
            String key = StringExtension.JsonDeQuote(structInfo.columnList.get((int)i).columnName);
            String itemValue = StringExtension.JsonDeQuote(valueList[i]);
            output.put(key, (Object)itemValue);
        }
        return output;
    }

    public static Object JSONtoSQLStruct(Object value, TableInfo structInfo) throws Exception {
        String item = value.toString();
        if (item.startsWith("{")) {
            ArrayList<String> valueList = new ArrayList<String>();
            JSONObject json = new JSONObject(item);
            Set keyList = json.keySet();
            for (ColumnInfo column : structInfo.columnList) {
                if (keyList.contains(column.columnName)) {
                    valueList.add(json.get(column.columnName).toString());
                    continue;
                }
                valueList.add("");
            }
            return "(" + StringExtension.Join(valueList, ",") + ")";
        }
        return value;
    }
}

