/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.GenericRepository.Repository;

import LinkFuture.Core.ContentManager.ContentController;
import LinkFuture.Core.ContentManager.Model.ContentResultCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultInfo;
import LinkFuture.Core.ContentManager.Model.ContentType;
import LinkFuture.Core.ContentManager.Model.ResponseType;
import LinkFuture.Core.GenericRepository.Repository.BaseRepository;
import LinkFuture.Core.GenericRepository.Repository.IGenericRepository;
import LinkFuture.Core.Utility;
import LinkFuture.Core.WebClient.HttpMethod;
import LinkFuture.Init.ObjectExtend.NameValuePair;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class GenericRepository<T, ID extends Serializable>
extends BaseRepository<T, ID>
implements IGenericRepository<T, ID> {
    public GenericRepository(String requestPath) {
        super(requestPath);
    }

    @Override
    protected <R> Object genericDBResourceLoad(String contentName, HttpMethod method, R requestObject) throws Exception {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add(new NameValuePair("LF_HttpMethod", (Object)method));
        list.add(new NameValuePair("LF_ResponseType", (Object)ResponseType.Json));
        if (method == HttpMethod.Get || method == HttpMethod.Delete) {
            list.add(new NameValuePair("$JsonQuery", Utility.jacksonToJson(requestObject)));
        } else {
            list.add(new NameValuePair("LF_ContentType", (Object)ContentType.Json));
            list.add(new NameValuePair("LF_PlayLoad", Utility.jacksonToJson(requestObject)));
        }
        ContentResultCollectionInfo result = ContentController.LoadContent(contentName, null, list, false, true);
        if (result.size() > 0) {
            ContentResultInfo myResult = (ContentResultInfo)result.get(0);
            if (myResult.Success) {
                logger.trace(myResult.Result == null ? "No result found" : myResult.Result.toString());
                return myResult.Result;
            }
        }
        throw new IllegalArgumentException("No result found");
    }

    @Override
    protected <R> Object genericDBResourceLoad(HttpMethod method, R requestObject) throws Exception {
        return this.genericDBResourceLoad(this.requestPath, method, requestObject);
    }
}

