/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.GenericRepository.Repository;

import LinkFuture.Core.GenericRepository.Entity.FieldAttribute;
import LinkFuture.Core.GenericRepository.Entity.FieldInfo;
import LinkFuture.Core.GenericRepository.Entity.GenericQuery;
import LinkFuture.Core.GenericRepository.Entity.GenericSet;
import LinkFuture.Core.GenericRepository.Entity.GenericWhere;
import LinkFuture.Core.GenericRepository.Entity.Pageable;
import LinkFuture.Core.GenericRepository.Entity.PageableList;
import LinkFuture.Core.GenericRepository.Entity.ResponseData;
import LinkFuture.Core.GenericRepository.Entity.ResponseIdentity;
import LinkFuture.Core.GenericRepository.Entity.ResponseIdentityList;
import LinkFuture.Core.GenericRepository.Repository.GenericRepository;
import LinkFuture.Core.GenericRepository.Repository.IGenericRepository;
import LinkFuture.Core.MemoryManager.StaticMemoryCache.StaticMemoryCacheHelper;
import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Core.Utility;
import LinkFuture.Core.WebClient.HttpMethod;
import LinkFuture.Init.Extensions.DateExtension;
import LinkFuture.Init.Extensions.StringExtension;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRepository<T, ID extends Serializable>
implements IGenericRepository<T, ID> {
    protected static final Logger logger = LoggerFactory.getLogger(GenericRepository.class);
    public static final String JSON_QUERY = "$JsonQuery";
    protected Class<? extends T> entityType;
    protected Class<? extends ID> keyType;
    protected String requestPath;

    public BaseRepository(String requestPath) {
        this.requestPath = requestPath;
        Type t = this.getClass().getGenericSuperclass();
        ParameterizedType pt = (ParameterizedType)t;
        this.entityType = (Class)pt.getActualTypeArguments()[0];
        this.keyType = (Class)pt.getActualTypeArguments()[1];
    }

    protected abstract <R> Object genericDBResourceLoad(String var1, HttpMethod var2, R var3) throws Exception;

    protected abstract <R> Object genericDBResourceLoad(HttpMethod var1, R var2) throws Exception;

    protected <R> PageableList<R> toList(Object genericDBResult, Class<R> entityType) throws IOException {
        if (genericDBResult == null) {
            return null;
        }
        ResponseData response = Utility.jacksonFromJson(genericDBResult.toString(), ResponseData.class, entityType);
        return response == null || response.data == null || response.data.length == 0 ? null : new PageableList(response.data[0], response.page == null || response.page.length == 0 ? null : response.page[0]);
    }

    public static synchronized HashMap<String, FieldInfo> findEntityFieldInfo(final Class<?> type) throws Exception {
        String classKey = "$BaseRepository$findEntityFieldInfo".concat(type.getName());
        return (HashMap)StaticMemoryCacheHelper.AddNeverExpiredMemoryCache(classKey, new Operation<HashMap<String, FieldInfo>>(new Object[]{type}){

            @Override
            public HashMap<String, FieldInfo> call() throws Exception {
                HashMap<String, FieldInfo> fieldList = new HashMap<String, FieldInfo>();
                for (Field field : type.getFields()) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    FieldAttribute fieldAttribute = field.getAnnotation(FieldAttribute.class);
                    FieldInfo fieldMeta = new FieldInfo();
                    fieldMeta.field = field;
                    fieldMeta.jsonFormatAttribute = field.getAnnotation(JsonFormat.class);
                    if (fieldAttribute != null) {
                        String fieldName = fieldAttribute.name().length() == 0 ? field.getName() : fieldAttribute.name();
                        fieldMeta.fieldAttribute = fieldAttribute;
                        fieldList.put(fieldName, fieldMeta);
                        continue;
                    }
                    fieldList.put(field.getName().toLowerCase(), fieldMeta);
                }
                return fieldList;
            }
        });
    }

    public static synchronized HashMap<String, FieldInfo> findEntityKeyFieldInfo(final Class<?> type) throws Exception {
        String classKey = "$BaseRepository$findEntityKeyFieldInfo".concat(type.getName());
        return (HashMap)StaticMemoryCacheHelper.AddNeverExpiredMemoryCache(classKey, new Operation<HashMap<String, FieldInfo>>(new Object[]{type}){

            @Override
            public HashMap<String, FieldInfo> call() throws Exception {
                HashMap<String, FieldInfo> fieldList = new HashMap<String, FieldInfo>();
                HashMap<String, FieldInfo> fields = BaseRepository.findEntityFieldInfo(type);
                for (String fieldName : fields.keySet()) {
                    FieldInfo field = fields.get(fieldName);
                    if (field.fieldAttribute == null || !field.fieldAttribute.isKey()) continue;
                    fieldList.put(fieldName, field);
                }
                return fieldList;
            }
        });
    }

    @Override
    public <S extends T> ID insert(S obj) throws Exception {
        logger.trace("Insert {}", (Object)this.requestPath);
        Object output = this.genericDBResourceLoad(HttpMethod.Put, obj);
        if (output == null) {
            throw new RuntimeException("Insert failed");
        }
        Object identity = Utility.jacksonFromJson((String)output.toString(), ResponseIdentity.class, new Class[0]).identity;
        return (ID)((Serializable)LinkFuture.Init.Utility.cast(identity, this.keyType));
    }

    @Override
    public <S extends T> List<ID> insert(List<S> obj) throws Exception {
        logger.trace("Insert {}", (Object)this.requestPath);
        Object output = this.genericDBResourceLoad(HttpMethod.Put, obj);
        if (output == null) {
            throw new RuntimeException("Insert failed");
        }
        ResponseIdentityList identityList = Utility.jacksonFromJson(output.toString(), ResponseIdentityList.class, new Class[0]);
        ArrayList<ID> response = new ArrayList<ID>();
        for (Object ob : identityList.identity) {
            response.add(LinkFuture.Init.Utility.cast(ob, this.keyType));
        }
        return response;
    }

    @Override
    public <S extends T> Integer save(S obj) throws Exception {
        GenericSet.Builder<?> builder = GenericSet.builder();
        GenericWhere.Builder<?> where = GenericWhere.builder();
        HashMap<String, FieldInfo> fields = BaseRepository.findEntityFieldInfo(this.entityType);
        for (String name : fields.keySet()) {
            FieldInfo field = fields.get(name);
            Object myValue = field.field.get(obj);
            if (myValue == null) continue;
            if (field.fieldAttribute.isKey()) {
                where.and(name, myValue);
                continue;
            }
            builder.set(name, myValue);
        }
        builder.where(where.build());
        return this.save(builder.build());
    }

    @Override
    public Integer save(GenericSet q) throws IOException, URISyntaxException {
        logger.trace("Save {}", (Object)this.requestPath);
        try {
            return (int)((Integer)this.genericDBResourceLoad(HttpMethod.Post, q));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Integer delete(ID id) throws Exception {
        GenericWhere.Builder<?> builder = GenericWhere.builder();
        HashMap<String, FieldInfo> fields = BaseRepository.findEntityKeyFieldInfo(this.entityType);
        if (fields.size() != 1) {
            throw new NoSuchMethodError("this api " + this.requestPath + " have multiple key, please try delete(S obj) instead.");
        }
        builder.and(fields.keySet().iterator().next(), id);
        try {
            return this.delete(builder.build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <S extends T> Integer delete(S obj) throws Exception {
        HashMap<String, FieldInfo> fields = BaseRepository.findEntityKeyFieldInfo(this.entityType);
        GenericWhere.Builder<?> builder = GenericWhere.builder();
        for (String name : fields.keySet()) {
            FieldInfo field = fields.get(name);
            field.field.setAccessible(true);
            builder.and(name, field.field.get(obj));
        }
        try {
            return this.delete(builder.build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Integer delete(GenericWhere q) throws Exception {
        logger.trace("Delete {}", (Object)this.requestPath);
        return (int)((Integer)this.genericDBResourceLoad(HttpMethod.Delete, q));
    }

    @Override
    public PageableList<T> findAll(Pageable pager) throws Exception {
        return this.find(null, pager);
    }

    @Override
    public <S extends T> PageableList<T> find(S obj) throws Exception {
        return this.find(obj, null);
    }

    @Override
    public T find(ID id) throws Exception {
        HashMap<String, FieldInfo> fields = BaseRepository.findEntityKeyFieldInfo(this.entityType);
        if (fields.size() == 1) {
            PageableList<T> results = this.find(((GenericQuery.Builder)GenericQuery.builder().where(((GenericWhere.Builder)GenericWhere.builder().and(fields.keySet().iterator().next(), id)).build())).build());
            return results != null ? (T)results.getFirst() : null;
        }
        throw new IllegalArgumentException("We can't find unique primary key from this entity type, please use PageableList<T> find(GenericQuery q) instead.");
    }

    @Override
    public <S extends T> PageableList<T> find(S obj, Pageable pager) throws Exception {
        GenericQuery.Builder<?> query = GenericQuery.builder();
        if (obj != null) {
            GenericWhere whereBuilder = BaseRepository.buildGenericWhere(obj);
            if (whereBuilder.size() == 0) {
                throw new IllegalArgumentException("Missing where condition.");
            }
            query.where(whereBuilder);
        }
        if (pager != null) {
            query.limit(pager.getPageSize());
            query.offset(pager.getOffset());
        }
        return this.find(query.build());
    }

    public static <R> GenericWhere buildGenericWhere(R obj) throws Exception {
        GenericWhere.Builder<?> where = GenericWhere.builder();
        HashMap<String, FieldInfo> fields = BaseRepository.findEntityFieldInfo(obj.getClass());
        for (String name : fields.keySet()) {
            FieldInfo field = fields.get(name);
            Object myValue = field.field.get(obj);
            if (myValue == null) continue;
            if (field.jsonFormatAttribute != null && !StringExtension.IsNullOrEmpty(field.jsonFormatAttribute.pattern()) && myValue instanceof Date) {
                where.and(name, DateExtension.Format((Date)myValue, field.jsonFormatAttribute.pattern()));
                continue;
            }
            if (Utility.isCustomClass(myValue)) {
                where.and(name, Utility.jacksonToJson(myValue));
                continue;
            }
            where.and(name, myValue);
        }
        return where.build();
    }

    @Override
    public PageableList<T> find(GenericQuery q) throws Exception {
        logger.trace("Find {}", (Object)this.requestPath);
        Object output = this.genericDBResourceLoad(HttpMethod.Get, q);
        return this.toList(output, this.entityType);
    }

    @Override
    public T findOne(GenericQuery q) throws Exception {
        GenericQuery newQuery = ((GenericQuery.Builder)((GenericQuery.Builder)q.getBuilder().offset(0)).limit(1)).build();
        PageableList<T> results = this.find(newQuery);
        return results != null ? (T)results.getFirst() : null;
    }

    @Override
    public T findOne(T q) throws Exception {
        PageableList<T> results = this.find(q, new Pageable(0, 1));
        return results != null ? (T)results.getFirst() : null;
    }
}

