/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.DBHelper.Model;

import LinkFuture.Core.DBHelper.DBHelper;
import LinkFuture.Core.DBHelper.Model.DBColumnAttribute;
import LinkFuture.Init.Extensions.StringExtension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ColumnInfo {
    @DBColumnAttribute(columnName="COLUMN_NAME")
    public String columnName;
    @DBColumnAttribute(columnName="COLUMN_SIZE")
    public int columnSize;
    @DBColumnAttribute(columnName="DATA_TYPE")
    public int sqlType;
    @DBColumnAttribute(columnName="TYPE_NAME")
    public String sqlTypeName;
    public String javaClassName;
    @DBColumnAttribute(columnName="IS_NULLABLE")
    public boolean nullable;
    @DBColumnAttribute(columnName="IS_AUTOINCREMENT")
    public boolean autoIncrement;
    @DBColumnAttribute(columnName="ORDINAL_POSITION")
    public int position;
    @DBColumnAttribute(columnName="COLUMN_DEF")
    public String defaultValue;
    public boolean isKey;
    public ArrayList<ColumnInfo> columnList = new ArrayList();
    private String arrayElementTypeName;
    private Integer arrayElementType = null;
    private static final Map<Integer, String> sqlTypeToJava = new HashMap<Integer, String>(){
        {
            this.put(1, "String");
            this.put(12, "String");
            this.put(-1, "String");
            this.put(2, "java.math.BigDecimal");
            this.put(3, "java.math.BigDecimal");
            this.put(-7, "Boolean");
            this.put(-6, "Byte");
            this.put(5, "Short");
            this.put(4, "Integer");
            this.put(-5, "Long");
            this.put(7, "Float");
            this.put(6, "Double");
            this.put(8, "Double");
            this.put(-2, "Byte[]");
            this.put(-3, "Byte[]");
            this.put(-4, "Byte[]");
            this.put(91, "java.util.Date");
            this.put(92, "java.util.Date");
            this.put(93, "java.util.Date");
            this.put(2005, "Clob");
            this.put(2004, "Blob");
            this.put(2003, "Array");
            this.put(2002, "Struct");
        }
    };

    public String toString() {
        return String.format("%s(%s - %s) :%s", this.columnName, this.sqlTypeName, this.javaClassName, this.isKey);
    }

    public String getArrayElementTypeName() {
        if (StringExtension.IsNullOrEmpty(this.arrayElementTypeName) && this.sqlType == 2003) {
            this.arrayElementTypeName = this.sqlTypeName.substring(1);
        }
        return this.arrayElementTypeName;
    }

    public Integer getArrayElementType() throws IllegalAccessException {
        if (this.arrayElementType == null && this.sqlType == 2003) {
            return DBHelper.sqlTypeNameToType(this.getArrayElementTypeName());
        }
        return this.arrayElementType;
    }

    public boolean sameColumnName(String columnName) {
        int subQueryIndex;
        if (this.sqlType == 2002 && (subQueryIndex = columnName.indexOf(".")) > 0) {
            columnName = columnName.substring(0, subQueryIndex);
        }
        return this.columnName.equalsIgnoreCase(columnName);
    }

    public boolean isSqlJsonType() {
        return this.sqlTypeName.equalsIgnoreCase("json") || this.sqlTypeName.equalsIgnoreCase("jsonb") && this.sqlType == 1111;
    }

    public boolean isSqlBoolType() {
        return this.sqlType == 16 || this.sqlTypeName.equalsIgnoreCase("bool") && this.sqlType == -7;
    }

    public boolean isSqlTimeStampType() {
        return this.sqlType == 93 && this.javaClassName.equalsIgnoreCase("java.sql.Timestamp");
    }

    public boolean isUUIDType() {
        return this.sqlType == 1111 && this.sqlTypeName.equalsIgnoreCase("uuid");
    }

    public boolean isSerialType() {
        return this.sqlTypeName.equalsIgnoreCase("serial");
    }

    public boolean isPasswordType() {
        return this.sqlType == 1111 && this.sqlTypeName.equalsIgnoreCase("chkpass");
    }

    public boolean hasDefaultValue() {
        return !StringExtension.IsNullOrEmpty(this.defaultValue);
    }

    public String getJavaClassNameBySqlType() {
        if (this.isUUIDType()) {
            return "java.util.UUID";
        }
        if (this.isSerialType()) {
            return "Long";
        }
        if (this.isUnknownJavaType()) {
            return "[mapping java object here]";
        }
        if (this.isPasswordType()) {
            return "String";
        }
        return sqlTypeToJava.get(this.sqlType);
    }

    public boolean isUnknownJavaType() {
        return this.isSqlJsonType() || this.sqlType == 2002;
    }
}

