/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.ContentSecurity;

import LinkFuture.Core.ContentManager.ContentSecurity.ContentBeanBaseSecurity;
import LinkFuture.Core.ContentManager.ContentSecurity.ContentRSAMetaInfo;
import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.SecurityInfo;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.SecurityExtension;

public class ContentRSASecurity
extends ContentBeanBaseSecurity<ContentRSAMetaInfo> {
    public ContentRSASecurity(SecurityInfo currentSecurity) throws Exception {
        super(currentSecurity, ContentRSAMetaInfo.class);
    }

    @Override
    public void Verify(ContentItemInfo content, ContentParameterCollectionInfo parameters) throws Exception {
        block4: {
            Debugger.LogFactory.trace("RSA Authorization");
            if (parameters.containsKey("LF_Authorization")) {
                try {
                    String auth = (String)parameters.get("LF_Authorization");
                    String decrypt = SecurityExtension.RSADecryptFromBase64(auth, SecurityExtension.RSAGetPrivateKeyFromBase64(((ContentRSAMetaInfo)this.Meta).Base64PrivateKey.trim()));
                    Debugger.LogFactory.trace("RSA decrypt value is {}", (Object)decrypt);
                    if (Math.abs(System.currentTimeMillis() - Long.parseLong(decrypt)) > ((ContentRSAMetaInfo)this.Meta).TimeGapInSecond * 1000L) {
                        Debugger.LogFactory.trace("Authorization token has been expired");
                        throw new SecurityException("Authorization token has been expired");
                    }
                    break block4;
                }
                catch (Exception e) {
                    Debugger.fatal("Authorization failed", e);
                    throw new SecurityException("Authorization failed");
                }
            }
            Debugger.LogFactory.trace("Authorization failed");
            throw new SecurityException("Authorization failed");
        }
    }
}

