/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager;

import LinkFuture.Core.ActivatorsStorage;
import LinkFuture.Core.ContentManager.ContentAction.ContentActionInfo;
import LinkFuture.Core.ContentManager.ContentAction.ContentBaseAction;
import LinkFuture.Core.ContentManager.ContentParameter.IContentParameter;
import LinkFuture.Core.ContentManager.ContentResource.IContentResource;
import LinkFuture.Core.ContentManager.Model.AddCycleType;
import LinkFuture.Core.ContentManager.Model.AddInfo;
import LinkFuture.Core.ContentManager.Model.AddParameterInfo;
import LinkFuture.Core.ContentManager.Model.ContentConfigurationInfo;
import LinkFuture.Core.ContentManager.Model.ContentImportFileInfo;
import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultCollectionInfo;
import LinkFuture.Core.ContentManager.Model.MetaBaseInfo;
import LinkFuture.Core.ContentManager.Model.ParameterInfo;
import LinkFuture.Core.ContentManager.Model.ProcessorInfo;
import LinkFuture.Core.ContentManager.Model.ProcessorRunningInfo;
import LinkFuture.Core.ContentManager.Model.ResourceInfo;
import LinkFuture.Core.ContentManager.Model.ResourceRunningInfo;
import LinkFuture.Core.ContentManager.Model.SecurityInfo;
import LinkFuture.Core.ContentManager.Model.ValidatorInfo;
import LinkFuture.Core.JsonManager.JsonOptionInfo;
import LinkFuture.Core.Utility;
import LinkFuture.Init.ConfigurationManager.ConfigurationController;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.PathExtension;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;
import LinkFuture.Init.ObjectExtend.NameValuePair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;

public class ContentController {
    public static final ContentConfigurationInfo ContentConfigurationMeta = ContentController.Read();
    public static final String LF_RESPONSE_TYPE = "LF_ResponseType";
    public static final String LF_HTTP_METHOD = "LF_HttpMethod";
    public static final String LF_CONTENT_TYPE = "LF_ContentType";
    public static final String LF_PLAY_LOAD = "LF_PlayLoad";
    public static final String LF_APP_PATH = "LF_APPPath";

    public static Object LoadResource(String resourceName) throws Exception {
        return ContentController.LoadResource(resourceName, null);
    }

    public static Object LoadResource(String resourceName, Collection<NameValuePair> args) throws Exception {
        ArrayList<NameValuePair> inputList = ContentController.BuildParameters(args);
        ResourceInfo resource = ContentController.FindResource(resourceName);
        IContentResource realAction = (IContentResource)ActivatorsStorage.GetActivator(resource.Type, resource);
        ContentParameterCollectionInfo list = new ContentParameterCollectionInfo();
        for (NameValuePair item : inputList) {
            list.put(item.id, item.value);
        }
        return realAction.GerResource(null, list);
    }

    public static ContentResultCollectionInfo LoadContent(String resourceName) throws Exception {
        return ContentController.LoadContent(resourceName, null, new ArrayList<NameValuePair>());
    }

    public static ContentResultCollectionInfo LoadContent(String resourceName, Integer version) throws Exception {
        return ContentController.LoadContent(resourceName, version, new ArrayList<NameValuePair>());
    }

    public static ContentResultCollectionInfo LoadContent(String resourceName, Collection<NameValuePair> args) throws Exception {
        return ContentController.LoadContent(resourceName, null, args, false);
    }

    public static ContentResultCollectionInfo LoadContent(String resourceName, Integer version, Collection<NameValuePair> args) throws Exception {
        return ContentController.LoadContent(resourceName, version, args, false);
    }

    public static ContentResultCollectionInfo LoadContent(String contentName, Integer version, Collection<NameValuePair> args, boolean resourceOnly) throws Exception {
        return ContentController.LoadContent(contentName, version, args, resourceOnly, false);
    }

    public static ContentResultCollectionInfo LoadContent(String contentName, Integer version, Collection<NameValuePair> args, boolean resourceOnly, boolean ignoreSecurity) throws Exception {
        ArrayList<NameValuePair> inputList = ContentController.BuildParameters(args);
        ContentActionInfo meta = new ContentActionInfo(ContentConfigurationMeta.FindContentItem(contentName, version), inputList);
        meta.ResourceOnly = resourceOnly;
        meta.IgnoreSecurity = ignoreSecurity;
        ContentBaseAction action = new ContentBaseAction(meta);
        return action.Action();
    }

    public static String LoadContent(String resourceName, String ... args) throws Exception {
        return ContentController.LoadContent(resourceName, null, args);
    }

    public static String LoadContent(String resourceName, Integer version, String ... args) throws Exception {
        if (args == null || args.length == 0) {
            ContentResultCollectionInfo result = ContentController.LoadContent(resourceName, version);
            result.Params.clear();
            return result.ToContentXml();
        }
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        for (int i = 0; i < args.length; i += 2) {
            list.add(new NameValuePair(args[i], args[i + 1]));
        }
        ContentResultCollectionInfo result = ContentController.LoadContent(resourceName, version, list);
        result.Params.clear();
        return result.ToContentXml();
    }

    public static CaseInsensitiveMap<Object> LoadParameters(String paramName) throws Exception {
        return ContentController.LoadParameters(paramName, null);
    }

    public static CaseInsensitiveMap<Object> LoadParameters(String paramName, Collection<NameValuePair> args) throws Exception {
        if (args == null) {
            args = new ArrayList<NameValuePair>();
        }
        ParameterInfo parameter = ContentController.FindParameter(paramName);
        ContentParameterCollectionInfo list = new ContentParameterCollectionInfo();
        for (NameValuePair item : args) {
            list.put(item.id, item.value);
        }
        IContentParameter realAction = (IContentParameter)ActivatorsStorage.GetActivator(parameter.Type, parameter);
        return realAction.GerParameter(list);
    }

    private static ArrayList<NameValuePair> BuildParameters(Collection<NameValuePair> args) {
        ArrayList<NameValuePair> output = new ArrayList<NameValuePair>();
        if (args != null) {
            for (NameValuePair item : args) {
                output.add(item);
            }
        }
        output.add(new NameValuePair(LF_APP_PATH, PathExtension.getApplicationPath()));
        return output;
    }

    public static ResourceInfo FindResource(String name) {
        if (ContentController.ContentConfigurationMeta.ResourceList != null && ContentController.ContentConfigurationMeta.ResourceList.containsKey(name)) {
            return ContentController.ContentConfigurationMeta.ResourceList.get(name);
        }
        throw new IllegalArgumentException("Specific resource not found:" + name);
    }

    public static ParameterInfo FindParameter(String name) {
        if (ContentController.ContentConfigurationMeta.ParameterList != null && ContentController.ContentConfigurationMeta.ParameterList.containsKey(name)) {
            return ContentController.ContentConfigurationMeta.ParameterList.get(name);
        }
        throw new IllegalArgumentException("Specific parameter not found:" + name);
    }

    private static synchronized void ReadImportFile(ContentConfigurationInfo config) throws IOException {
        if (config.ImportList != null) {
            for (ContentImportFileInfo file : config.ImportList) {
                if (StringExtension.IsNullOrEmpty(file.Resource)) continue;
                ContentConfigurationInfo subItem = Utility.fromXml(LinkFuture.Init.Utility.getStringFromFile(file.Resource), ContentConfigurationInfo.class);
                if (subItem != null) {
                    if (subItem.ParameterList != null) {
                        if (config.ParameterList == null) {
                            config.ParameterList = new CaseInsensitiveMap();
                        }
                        config.ParameterList.putAll(subItem.ParameterList);
                    }
                    if (subItem.ContentItemList != null) {
                        if (config.ContentItemList == null) {
                            config.ContentItemList = new ArrayList<ContentItemInfo>();
                        }
                        for (ContentItemInfo content : subItem.ContentItemList) {
                            if (content.Version != null) continue;
                            content.Version = file.Version;
                        }
                        config.ContentItemList.addAll(subItem.ContentItemList);
                    }
                    if (subItem.ResourceList != null) {
                        if (config.ResourceList == null) {
                            config.ResourceList = new CaseInsensitiveMap();
                        }
                        config.ResourceList.putAll(subItem.ResourceList);
                    }
                    if (subItem.ProcessorList != null) {
                        if (config.ProcessorList == null) {
                            config.ProcessorList = new CaseInsensitiveMap();
                        }
                        config.ProcessorList.putAll(subItem.ProcessorList);
                    }
                    if (subItem.SecurityList != null) {
                        if (config.SecurityList == null) {
                            config.SecurityList = new CaseInsensitiveMap();
                        }
                        config.SecurityList.putAll(subItem.SecurityList);
                    }
                }
                ContentController.ReadImportFile(subItem);
            }
        }
    }

    private static synchronized ContentConfigurationInfo Read() {
        try {
            ContentConfigurationInfo config = Utility.fromXml(LinkFuture.Init.Utility.getStringFromFile(ConfigurationController.AppSettings("ContentSettingPath")), ContentConfigurationInfo.class);
            ContentController.ReadImportFile(config);
            if (config.SecurityList != null) {
                for (MetaBaseInfo item : config.SecurityList.values()) {
                    if (StringExtension.IsNullOrEmpty(((SecurityInfo)item).Type)) {
                        throw new IllegalArgumentException("Please specific processor type on:" + ((SecurityInfo)item).Name);
                    }
                    ((SecurityInfo)item).getContentSecurity();
                }
            }
            if (config.ResourceList != null) {
                for (MetaBaseInfo item : config.ResourceList.values()) {
                    if (StringExtension.IsNullOrEmpty(((ResourceInfo)item).Type)) {
                        throw new IllegalArgumentException("Please specific resource type on:" + ((ResourceInfo)item).Name);
                    }
                    new ResourceRunningInfo((ResourceInfo)item, null).getContentResource();
                }
            }
            if (config.ParameterList != null) {
                for (MetaBaseInfo item : config.ParameterList.values()) {
                    if (StringExtension.IsNullOrEmpty(((ParameterInfo)item).Type)) {
                        throw new IllegalArgumentException("Please specific parameter type on:" + ((ParameterInfo)item).Name);
                    }
                    ((ParameterInfo)item).getContentParameter();
                }
            }
            if (config.ProcessorList != null) {
                for (MetaBaseInfo item : config.ProcessorList.values()) {
                    if (StringExtension.IsNullOrEmpty(((ProcessorInfo)item).Type)) {
                        throw new IllegalArgumentException("Please specific processor type on:" + ((ProcessorInfo)item).Name);
                    }
                    new ProcessorRunningInfo(null, (ProcessorInfo)item, null).getContentProcessor();
                }
            }
            if (config.ContentItemList != null) {
                TreeMap hashMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                for (ContentItemInfo content : config.ContentItemList) {
                    if (content.Version == null) {
                        content.Version = Integer.MIN_VALUE;
                    }
                    if (content.Version > config.LatestVersion) {
                        config.LatestVersion = content.Version;
                    }
                    if (hashMap.containsKey(content.Name)) {
                        if (((List)hashMap.get(content.Name)).contains(content.Version)) {
                            throw new IllegalArgumentException("Specific content has duplicate version");
                        }
                        ((List)hashMap.get(content.Name)).add(content.Version);
                        continue;
                    }
                    ArrayList<Integer> versionList = new ArrayList<Integer>();
                    versionList.add(content.Version);
                    hashMap.put(content.Name, versionList);
                }
                Debugger.LogFactory.trace("Find latest version is {}", (Object)config.LatestVersion);
                for (ContentItemInfo content : config.ContentItemList) {
                    if (content.JsonOption == null) {
                        content.JsonOption = new JsonOptionInfo();
                        content.JsonOption.AttributePrefix = "";
                        content.JsonOption.CDataNodeName = "Content";
                        content.JsonOption.IgnoreNamespace = true;
                    }
                    if (content.ValidatorList != null) {
                        for (ValidatorInfo validatorInfo : content.ValidatorList) {
                            if (StringExtension.IsNullOrEmpty(validatorInfo.Type)) {
                                throw new IllegalArgumentException("Please specific validator type on:" + content.Name);
                            }
                            validatorInfo.getContentValidator(content);
                        }
                    }
                    if (config.ResourceList != null && content.ResourceList != null) {
                        int max = 0;
                        for (ArrayList[] add : content.ResourceList) {
                            if (max < add.Sequence) {
                                max = add.Sequence;
                            }
                            if (add.SelectorList == null) continue;
                            for (AddParameterInfo selector : add.SelectorList.values()) {
                                if (selector.Cycle != null) continue;
                                selector.Cycle = AddCycleType.Before;
                            }
                        }
                        ArrayList[] arrayListArray = new ArrayList[max + 1];
                        for (AddInfo add : content.ResourceList) {
                            if (!config.ResourceList.containsKey(add.Name)) {
                                throw new IllegalArgumentException("Specific resource type not exist:" + add.Name);
                            }
                            if (arrayListArray[add.Sequence] == null) {
                                arrayListArray[add.Sequence] = new ArrayList();
                            }
                            arrayListArray[add.Sequence].add(new ResourceRunningInfo(config.ResourceList.get(add.Name), add));
                        }
                        content.CachedResourceList = new ArrayList();
                        for (ArrayList itemList : arrayListArray) {
                            if (itemList == null) continue;
                            content.CachedResourceList.add(itemList);
                        }
                    }
                    if (config.ParameterList != null) {
                        content.CachedParameterList = new ArrayList();
                        if (content.ParameterList != null) {
                            for (AddInfo addInfo : content.ParameterList) {
                                if (!config.ParameterList.containsKey(addInfo.Name)) {
                                    throw new IllegalArgumentException("Specific parameter type not exist:" + addInfo.Name);
                                }
                                ParameterInfo myParameter = config.ParameterList.get(addInfo.Name);
                                if (myParameter.Global) continue;
                                content.CachedParameterList.add(myParameter);
                            }
                        }
                        for (ParameterInfo parameterInfo : config.ParameterList.values()) {
                            if (!parameterInfo.Global) continue;
                            content.CachedParameterList.add(parameterInfo);
                        }
                    }
                    if (config.SecurityList != null) {
                        content.CachedSecurityList = new ArrayList();
                        if (content.SecurityList != null) {
                            for (AddInfo addInfo : content.SecurityList) {
                                if (!config.SecurityList.containsKey(addInfo.Name)) {
                                    throw new IllegalArgumentException("Specific security type not exist:" + addInfo.Name);
                                }
                                SecurityInfo mySecurity = config.SecurityList.get(addInfo.Name);
                                if (mySecurity.Global) continue;
                                content.CachedSecurityList.add(mySecurity);
                            }
                        }
                        for (SecurityInfo securityInfo : config.SecurityList.values()) {
                            if (!securityInfo.Global) continue;
                            content.CachedSecurityList.add(securityInfo);
                        }
                    }
                    if (config.ProcessorList == null || content.ProcessorList == null) continue;
                    content.CachedProcessorList = new ArrayList();
                    for (AddInfo addInfo : content.ProcessorList) {
                        if (!config.ProcessorList.containsKey(addInfo.Name)) {
                            throw new IllegalArgumentException("Specific processor type not exist:" + addInfo.Name);
                        }
                        content.CachedProcessorList.add(new ProcessorRunningInfo(content, config.ProcessorList.get(addInfo.Name), addInfo));
                    }
                }
            }
            return config;
        }
        catch (Exception ex) {
            Debugger.LogFactory.error("Init content manager failed", (Throwable)ex);
            throw new RuntimeException("Init content manager failed, due to ", ex);
        }
    }
}

