/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core;

import LinkFuture.Core.MemoryManager.StaticMemoryCache.StaticMemoryCacheHelper;
import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.StringExtension;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class ActivatorsStorage {
    private static final HashMap<String, Class<?>> primitiveMap = new HashMap(){
        {
            this.put("java.lang.Integer", Integer.TYPE);
            this.put("java.lang.Long", Long.TYPE);
            this.put("java.lang.Double", Double.TYPE);
            this.put("java.lang.Float", Float.TYPE);
            this.put("java.lang.Boolean", Boolean.TYPE);
            this.put("java.lang.Character", Character.TYPE);
            this.put("java.lang.Byte", Byte.TYPE);
            this.put("java.lang.Void", Void.TYPE);
            this.put("java.lang.Short", Short.TYPE);
        }
    };

    public static <T> T GetActivator(String typeString, Object ... args) throws Exception {
        ActivatorsStorage.VerifyClass(typeString, args);
        return ((Constructor)StaticMemoryCacheHelper.GetNeverExpiredMemoryCache(ActivatorsStorage.getUniqueKey(typeString, args))).newInstance(args);
    }

    public static void VerifyClass(String typeString, Object ... args) throws Exception {
        if (StringExtension.IsNullOrEmpty(typeString)) {
            throw new IllegalArgumentException("type name can't not be null.");
        }
        String key = ActivatorsStorage.getUniqueKey(typeString, args);
        StaticMemoryCacheHelper.AddNeverExpiredMemoryCache(key, new Operation<Object>(new Object[]{typeString, args}){

            @Override
            public Object call() throws Exception {
                String className = (String)this.params[0];
                Debugger.LogFactory.trace("Activating class {}", (Object)className);
                Object[] passedArgs = (Object[])this.params[1];
                Class<?> myClass = Class.forName(className);
                Constructor<?>[] cst = myClass.getConstructors();
                if (cst.length > 0) {
                    for (Constructor<?> cs : cst) {
                        Class<?>[] parameterTypes = cs.getParameterTypes();
                        if (parameterTypes.length != passedArgs.length) continue;
                        boolean foundStructure = true;
                        for (int i = 0; i < parameterTypes.length; ++i) {
                            if (ActivatorsStorage.isAssignableFrom(parameterTypes[i], passedArgs[i].getClass(), true)) continue;
                            foundStructure = false;
                            break;
                        }
                        if (!foundStructure) continue;
                        return cs;
                    }
                }
                throw new IllegalArgumentException(String.format("Can't init %s type, as it don't have default constructor.", className));
            }
        });
    }

    private static String getUniqueKey(String typeString, Object ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append("$ActivatorsStorage$_");
        sb.append(typeString);
        sb.append("_");
        for (Object ob : args) {
            sb.append(ob.getClass());
        }
        return sb.toString();
    }

    public static boolean isAssignableFrom(Class<?> a, Class<?> b, boolean convertPrimitiveType) {
        if (convertPrimitiveType) {
            if (a.isPrimitive() && primitiveMap.containsKey(b.getName())) {
                b = primitiveMap.get(b.getName());
                return a.isAssignableFrom(b);
            }
            if (b.isPrimitive() && primitiveMap.containsKey(a.getName())) {
                a = primitiveMap.get(a.getName());
                return a.isAssignableFrom(b);
            }
        }
        return a.isAssignableFrom(b);
    }
}

