package LinkFuture.Init.ObjectExtend;
import LinkFuture.Init.Utility;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;


/**
 * User: Cyokin Zhang
 * Date: 10/4/13
 * Time: 11:23 PM
 * How to use
 *     1. add XmlJavaTypeAdapter on your hashmap property, key must string type
 *        add @XmlSeeAlso(AppSettingInfo.class) on your class, otherwise it will throw exception that JAXB can;t find your context
 *         [@]XmlRootElement(name="Application")
 *         [@]XmlSeeAlso(AppSettingInfo.class)
 *         public class ConfigurationInfo {
 *
 *          [@]XmlJavaTypeAdapter(value=JAXBMapAdaptor.class)
 *          [@]XmlElement(name="AppSettings")
 *            public HashMap<String,AppSettingInfo> AppSettings;
 *     }
 *
 *     2. Specific which one is hash key in your object
 *     [@]XmlRootElement(name="Add")
 *     public class AppSettingInfo {
 *         [@]XmlAttribute(name="key")
 *         [@]JAXBMapKeyAttribute
 *         public String Key;
 *         [@]XmlAttribute(name="value")
 *         public String Value;
 *     }
 *
 */
public class JAXBMapAdaptor<T> extends XmlAdapter<JAXBMapElements<T>,Map<String,T>> {
    @SuppressWarnings("unchecked")
    @Override
    public JAXBMapElements marshal(Map<String, T> map) {
        if(map==null)
        {
            return null;
        }
        JAXBMapElements elements = new JAXBMapElements();
        elements.value= map.values().toArray();
        return elements;
    }

    @Override
    public Map<String, T> unmarshal(JAXBMapElements<T> input) throws Exception {
        if(input.value.length>0)
        {
            Map<String, T> map = new HashMap<>();
            Field keyField = Utility.findField(input.value[0].getClass(),JAXBMapKeyAttribute.class);
            for(T item:input.value)
            {
                map.put(keyField.get(item).toString(),item);
            }
            return map;
        }
        return null;
    }
}
