package LinkFuture.Core.WebClient;

import LinkFuture.Init.Debugger;
import LinkFuture.Init.ConfigurationManager.ConfigurationController;

import javax.xml.bind.DatatypeConverter;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.concurrent.ConcurrentHashMap;

/**
 * LinkFuture.
 * User: Cyokin Zhang
 * Date: 11/29/13
 * Time: 4:04 PM
 */
public class GroupAuthenticator extends Authenticator {
    private static final ConcurrentHashMap<String,String> TicketMemory = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String,PasswordAuthentication> DigestMemory = new ConcurrentHashMap();
    //http://pag-www.gtisc.gatech.edu/chord/examples/jdk/sun/net/www/protocol/http/HttpURLConnection.java.html
    //http://www.docjar.com/html/api/sun/net/www/protocol/http/DigestAuthentication.java.html
    //https://forums.oracle.com/thread/1693367    or ThreadLocal
    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        Debugger.LogFactory.trace("getPasswordAuthentication");
        if(this.getRequestorType()==RequestorType.SERVER)
        {
            String host = this.getRequestingHost().toLowerCase();
            if(DigestMemory.containsKey(host))
            {
                Debugger.LogFactory.trace("get digest ticket for {} host", host);
                return DigestMemory.get(host);
            }
            else
            {
                Debugger.LogFactory.trace("can't find digest for {} host", host);
            }
        }
        else
        {
            if(this.getRequestingProtocol().equalsIgnoreCase("https")
                    && ConfigurationController.ConfigurationMeta.ProxySettings!=null
                    && ConfigurationController.ConfigurationMeta.ProxySettings.HttpsProxy!=null
                    && ConfigurationController.ConfigurationMeta.ProxySettings.HttpsProxy.Ticket!=null
                    )
            {
                return ConfigurationController.ConfigurationMeta.ProxySettings.HttpsProxy.Ticket;
            }
            if(this.getRequestingProtocol().equalsIgnoreCase("http")
                    && ConfigurationController.ConfigurationMeta.ProxySettings!=null
                    && ConfigurationController.ConfigurationMeta.ProxySettings.HttpProxy!=null
                    && ConfigurationController.ConfigurationMeta.ProxySettings.HttpProxy.Ticket!=null
                    )
            {
                return ConfigurationController.ConfigurationMeta.ProxySettings.HttpProxy.Ticket;
            }
        }
        return null;
    }

    public static String RegisterAuthentication(String host,CredentialInfo credential){
        host = host.toLowerCase();
        switch (credential.RequestAuthType)
        {
            case Basic:
                if(!TicketMemory.containsKey(host))
                {
                    TicketMemory.put(host,"Basic " + DatatypeConverter.printBase64Binary((credential.UserName + ":" + credential.Password).getBytes()));
                }
                break;
            case Digest:
                if(!DigestMemory.containsKey(host))
                {
                    DigestMemory.put(host,new PasswordAuthentication(credential.UserName,credential.Password.toCharArray()));
                }
                break;
        }
        //all auth type will have ticket
        return TicketMemory.get(host);
    }
    public static void SetAuthorizationTicket(String host,String ticket){
        host = host.toLowerCase();
        boolean hasKey = TicketMemory.containsKey(host);
        //add or update ticket;
        if(!hasKey || (hasKey && !TicketMemory.get(host).equals(ticket)))
        {
            Debugger.LogFactory.trace("Saving digest ticket for host {}", host);
            TicketMemory.put(host, ticket);
        }
    }
}
