package LinkFuture.Core.MemoryManager.StaticMemoryCache;

import LinkFuture.Core.MemoryManager.MemoryFactory;
import LinkFuture.Core.MemoryManager.Meta.MemoryCacheMetaInfo;
import LinkFuture.Core.MemoryManager.Meta.MemoryCacheType;
import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Init.Debugger;

import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

/**
 * User: Cyokin Zhang
 * Date: 10/12/13
 * Time: 2:19 PM
 */
public class StaticMemoryCacheHelper {
    private static final Map<String,StaticMemoryCacheInfo> refreshedCachedObject = new ConcurrentHashMap<>();
    private static final Map<String,StaticMemoryCacheInfo> neverExpiredCachedObject = new ConcurrentHashMap <>();

    public static Map<String,StaticMemoryCacheInfo> MemoryObjectFactory(MemoryCacheType type ){

        switch (type) {
            case Absolute:
                return refreshedCachedObject;
            case Never:
            case File:
                default:
                return neverExpiredCachedObject;
        }
    }

    private static final int MemoryCacheInterval;
    //run timer only we have set memory cache interval >0 ,
    private static Timer timer;
    private static TimerTask timeTask;
    static {
        MemoryCacheInterval = MemoryFactory.ConfigurationMeta==null?1000:MemoryFactory.ConfigurationMeta.getMemoryCacheInterval();
        timer = new Timer();
        timeTask = new TimerTask() {
            @Override
            public void run() {
                refreshMemory();
            }
        };
        timer.scheduleAtFixedRate(timeTask,new Date(),MemoryCacheInterval);
    }


    public static<T> T AddNeverExpiredMemoryCache(String key,Operation operation) throws Exception {
        MemoryCacheMetaInfo meta = new MemoryCacheMetaInfo();
        meta.CacheType = MemoryCacheType.Never;
        meta.Key = key;
        meta.Enable = true;
        meta.Action =operation;
        return AddMemoryCache(meta);
    }
    public static <T> T AddMemoryCache(MemoryCacheMetaInfo meta) throws Exception {
        //if not enabled, just return the value
        if(!meta.Enable)
        {
            //noinspection unchecked
            return (T)meta.Action.call();
        }
        Map<String,StaticMemoryCacheInfo> cachedObject = MemoryObjectFactory(meta.CacheType);
        if(!cachedObject.containsKey(meta.getUniqueKey()))
        {
            RunAction(meta,System.currentTimeMillis());
        }
        //noinspection unchecked
        return (T)cachedObject.get(meta.getUniqueKey()).CachedObject;
    }
    public static void ClearCache(MemoryCacheMetaInfo meta){
        Debugger.LogFactory.trace("removing {}", meta.getUniqueKey());
        Map<String,StaticMemoryCacheInfo> cachedObject = MemoryObjectFactory(meta.CacheType);
        if(cachedObject.containsKey(meta.getUniqueKey()))
        {
            cachedObject.remove(meta.getUniqueKey());
        }
    }
    /*
    * Get cached object from memory, it will return null if not exist.
    * */
    public static <T> T GetMemory(MemoryCacheMetaInfo meta)
    {
        Map<String,StaticMemoryCacheInfo> cachedObject = MemoryObjectFactory(meta.CacheType);
        if(cachedObject.containsKey(meta.getUniqueKey()))
        {
            //noinspection unchecked
            return (T)(cachedObject.get(meta.getUniqueKey()).CachedObject);
        }
        return null;
    }
    public static<T> T GetNeverExpiredMemoryCache(String key)
    {
        MemoryCacheMetaInfo meta = new MemoryCacheMetaInfo();
        meta.CacheType = MemoryCacheType.Never;
        meta.Key = key;
        meta.Enable = true;
        return   GetMemory(meta);
    }

    private static void RunAction(MemoryCacheMetaInfo meta,long currentTime) throws Exception {
        StaticMemoryCacheInfo memory = new StaticMemoryCacheInfo();
        memory.CachedObject = meta.Action.call();
        memory.CachedTime = currentTime;
        memory.Meta = meta;
        //Debugger.LogFactory.trace(String.format("NextExpiredTime:%s + %s = %s ",currentTime,meta.getTimeSpan().getTimeStamp(),memory.NextExpiredTime ));
        if(meta.CacheType == MemoryCacheType.Absolute)
        {
            memory.NextExpiredTime = currentTime +  meta.getTimeSpan().getTimeStamp();
        }
        Map<String,StaticMemoryCacheInfo> cachedObject = MemoryObjectFactory(meta.CacheType);
        cachedObject.put(meta.getUniqueKey(),memory);
    }
    private static void refreshMemory() {
        long currentTime = System.currentTimeMillis();

        for (StaticMemoryCacheInfo memory:refreshedCachedObject.values())
        {
            //Debugger.LogFactory.trace(memory.Meta.Key + "refreshMemory :" + (memory.NextExpiredTime - currentTime));
            if(Math.abs(memory.NextExpiredTime - currentTime) < MemoryCacheInterval/2 || currentTime > memory.NextExpiredTime)
            {
                if(memory.Meta.AutoRefresh)
                {
                    try {
                        RunAction(memory.Meta,currentTime);
                        //can't use thread, seems it will throw exception when callback with XSLT processor
                        //exception: can't access XSLT factory, access denied.
//                                new Thread(new MyRunnable(memory.Meta) {
//                                    @Override
//                                    public void run(Object[] args) {
//                                        try {
//                                            RunAction((MemoryCacheMetaInfo)args[0],currentTime);
//                                        } catch (Exception e) {
//                                            //do nothing in thread;
//                                            Debugger.traceln(e);
//                                        }
//                                    }
//                                }).start();
                    } catch (Exception e) {
                        Debugger.LogFactory.error("Refresh memory exception",e);
                    }
                }
                else {
                    ClearCache(memory.Meta);
                }
            }
        }
    }
    public static String GetMemoryStatus(){
        StringBuilder sb = new StringBuilder();
        sb.append("<MemoryController>");
        for (StaticMemoryCacheInfo memory :refreshedCachedObject.values())
        {
            sb.append(memory.toString());
        }
        for (StaticMemoryCacheInfo memory :neverExpiredCachedObject.values())
        {
            sb.append(memory.toString());
        }
        sb.append("</MemoryController>");
        return sb.toString();
    }

    public static void Destroy(){
        refreshedCachedObject.clear();
        neverExpiredCachedObject.clear();
        if(timeTask!=null){timeTask.cancel();timeTask=null;}
        if(timer!=null){timer.cancel();timer=null;}
    }
    public static boolean Del(MemoryCacheMetaInfo meta){
        Map<String,StaticMemoryCacheInfo> myMemory = MemoryObjectFactory(meta.CacheType);
        return myMemory.remove(meta.getUniqueKey())!=null;
    }

    //TODO: will add file monitor later
//    private static void AddFileMonitor(MemoryCacheMetaInfo meta) throws IOException {
//        if(meta.CacheType == MemoryCacheType.File)
//        {
//            Path myDir = Paths.get(meta.FilePath);
//            WatchService watcher = myDir.getFileSystem().newWatchService();
//            while (true)
//            {
//                try {
//                    WatchKey watchKey = myDir.register(watcher,StandardWatchEventKinds.ENTRY_MODIFY) ;
//                    for (WatchEvent<?> event : watchKey.pollEvents()) {
//                        WatchEvent<Path> watchEvent = (WatchEvent<Path>) event;
//                        WatchEvent.Kind<Path> kind = watchEvent.kind();
//
//                        Debugger.LogFactory.trace(watchEvent.context() + ", count: " +
//                                watchEvent.count() + ", event: " + watchEvent.kind());
//                        // prints (loop on the while twice)
//                        // servers.cfg, count: 1, event: ENTRY_MODIFY
//                        // servers.cfg, count: 1, event: ENTRY_MODIFY
//
//                        switch (kind.name()) {
//                            case "ENTRY_MODIFY":
//                                //handleModify(watchEvent.context()); // reload configuration class
//                                break;
//                            case "ENTRY_DELETE":
//                                //handleDelete(watchEvent.context()); // do something else
//                                break;
//                            default:
//                                Debugger.LogFactory.trace("Event not expected " + event.kind().name());
//                        }
//                    }
//                }
//                catch (IOException e) {
//                    e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
//                }
//            }
//        }
//    }
}
