package LinkFuture.Core.MemoryManager.Redis;

import LinkFuture.Core.MemoryManager.IMemoryController;
import LinkFuture.Core.MemoryManager.Meta.MemoryCacheMetaInfo;
import LinkFuture.Core.OperationManager.Operation;

import java.net.URI;

/**
 * Created by Cyokin
 * on 11/9/2014.
 */
public class RedisMemoryController implements IMemoryController {
    private RedisHelper redis;
    public RedisMemoryController(String redisServers) {
        try {
            redis = new RedisHelper(new URI(redisServers),60000);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }
    @Override
    public void AddNeverExpiredMemoryCache(String key, Operation operation) throws Exception {
        Object result = operation.call();
        if(result instanceof String)
        {
            redis.set(key,(String)result);
            return;
        }
        if(result instanceof Throwable)
        {
            redis.setObject(key, (Throwable) result);
            return;
        }
        if(result instanceof byte[])
        {
            redis.setByte(key, (byte[]) result);
            return;
        }
    }

    @Override
    public void AddMemoryCache(MemoryCacheMetaInfo meta) throws Exception {
        if(meta.Enable)
        {
            String key = meta.getUniqueKey();
            Object result = meta.Action.call();
            if(result instanceof String)
            {
                redis.set(key,(String)result,(int)meta.Duration);
                return;
            }
            throw new IllegalArgumentException("Redis cache value can only be String type");
        }
    }

    @Override
    public String GetMemory(String key) {
        return redis.get(key);
    }

    @Override
    public void ClearCache(String key) {
        redis.del(key);
    }
}
