package LinkFuture.Core.MemoryManager.Meta;

import java.util.HashMap;
import java.util.Map;

/**
 * User: Cyokin Zhang
 * Date: 10/12/13
 * Time: 2:19 PM
 */
public enum MemoryCacheType {
    Absolute(0),
    Never(1),
    File(2);

    private int value;
    private static final Map<Integer, MemoryCacheType> typesByValue = new HashMap();
    static {
        for (MemoryCacheType type : MemoryCacheType.values()) {
            typesByValue.put(type.value, type);
        }
    }

    MemoryCacheType(int value){
        this.value = value;
    }
    @SuppressWarnings("UnusedDeclaration")
    public int getTypeValue() {
        return this.value;
    }
    @SuppressWarnings("UnusedDeclaration")
    public static MemoryCacheType convert(int value) {
        return typesByValue.get(value);
    }
}
