package LinkFuture.Core.MemoryManager.Meta;

import LinkFuture.Init.ObjectExtend.JAXBMapAdaptor;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.HashMap;

/**
 * User: Cyokin Zhang
 * Date: 10/12/13
 * Time: 2:19 PM
 */
@XmlRootElement(name="MemoryCacheConfiguration")
@XmlSeeAlso(MemoryCacheSettingInfo.class)
public class MemoryCacheSettingListInfo {

    @XmlElement(name="CacheSettingList")
    @XmlJavaTypeAdapter(value=JAXBMapAdaptor.class)
    public HashMap<String,MemoryCacheSettingInfo> SettingList;

    @XmlAttribute(name = "MemoryCacheIntervalSec")
    public int MemoryCacheIntervalSec;

    static int minMemoryCacheInterval = 1000*10;
    public int getMemoryCacheInterval(){
        if(this.MemoryCacheIntervalSec>0)
        {
            int memoryCacheInterval = 1000 * this.MemoryCacheIntervalSec;
            if(memoryCacheInterval< minMemoryCacheInterval)
            {
                memoryCacheInterval = minMemoryCacheInterval;
            }
            return memoryCacheInterval;
        }
        return minMemoryCacheInterval;
    }
}
