package LinkFuture.Core.JsonManager;

import LinkFuture.Core.DBHelper.Model.ColumnInfo;
import LinkFuture.Core.DBHelper.Model.TableInfo;
import LinkFuture.Init.Config;
import LinkFuture.Init.Extensions.StringExtension;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * User: Cyokin Zhang
 * Date: 10/23/13
 * Time: 12:19 PM
 */
public class JsonController {
    public static boolean isJsonObject(String jsonString){
        jsonString = jsonString.trim();
        return jsonString.startsWith("{") && jsonString.endsWith("}");
    }
    public static String convertJsonToXml(String jsonString)
    {
        if(jsonString.startsWith("{"))
        {
            JSONObject jsonObject=  new JSONObject(jsonString);
            return XML.toString(jsonObject);
        }
        else
        {
            JSONArray jsonObject=  new JSONArray(jsonString);
            return XML.toString(jsonObject);
        }
    }
    public static String convertXmlToJson(String xmlString,JsonOptionInfo option) {
        try(JsonObjectReader reader = new JsonObjectReader(xmlString))
        {
            JsonObjectInfo root = reader.toJsonObj();
            if(option.IgnoreRoot)
            {
                return root.toChildJson(option);
            }
            return root.toJson(option);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
    public static String convertXmlToJson(String xmlString) {
        JsonOptionInfo option = new JsonOptionInfo();
        option.AttributePrefix= Config.Empty;
        option.NamespacePrefix = Config.Empty;
        option.IgnoreNamespace = true;
        option.IgnoreRoot = false;
        option.CDataNodeName = "Content";
        option.ValueOption = JsonValueOption.AllString;
        return convertXmlToJson(xmlString,option);
    }

    public static JSONObject sqlStructToJSON(String value,TableInfo structInfo){
        // remove first( and end )
        if(value.startsWith("("))
        {
            value =  value.substring(1,value.length()-1);
        }
        JSONObject output = new JSONObject();
        String[] valueList = value.split(",");
        for (int i=0;i<valueList.length;i++)
        {
            String key = StringExtension.JsonDeQuote(structInfo.columnList.get(i).columnName);
            String itemValue = StringExtension.JsonDeQuote(valueList[i]);
            output.put(key,itemValue);
        }
        return output;
    }
    public static Object JSONtoSQLStruct(Object value,TableInfo structInfo) throws Exception {
        String item = value.toString();
        //if it is json format
        if(item.startsWith("{"))
        {
            List<String> valueList = new ArrayList<>();
            JSONObject json = new JSONObject(item);
            Set keyList = json.keySet();
            for (ColumnInfo column:structInfo.columnList)
            {
                if(keyList.contains(column.columnName))
                {
                    valueList.add(json.get(column.columnName).toString());
                }
                else
                {
                    valueList.add(Config.Empty);
                }
            }
            return "(" + StringExtension.Join(valueList,",") + ")";
        }
        return value;
    }
}
