package LinkFuture.Core.GenericRepository.Repository;

import LinkFuture.Core.GenericRepository.Entity.GenericResponse;
import LinkFuture.Core.JsonManager.JsonController;
import LinkFuture.Core.Utility;
import LinkFuture.Core.WebClient.WebClient;
import LinkFuture.Core.WebClient.WebClientResultInfo;
import LinkFuture.Core.WebClient.WebRequestInfo;
import LinkFuture.Init.Debugger;

import java.io.IOException;

/**
 * Created by Cyokin
 * on 5/20/2016.
 */
@SuppressWarnings("unused")
public abstract class WebRequestRepository {

    //region retryTimes
    private int retryTimes = 3;
    public void setRetryTimes(int times){
        retryTimes = times;
    }
    @SuppressWarnings("WeakerAccess")
    public int getRetryTimes(){
        return this.retryTimes;
    }
    //endregion

    @SuppressWarnings("WeakerAccess")
    public String requestPath;

    @SuppressWarnings("unused")
    public WebRequestRepository(String requestPath)
    {
        this.requestPath = requestPath;
    }
    public <T> T request(WebRequestInfo meta,Class<T> parametrizedClass, Class<?>... parameterClass) throws IOException {
        String response = request(meta);
        return Utility.jacksonFromJson(response, parametrizedClass, parameterClass);
    }
    public String request(WebRequestInfo meta) throws IOException {
        Debugger.LogFactory.trace("Requesting {}", meta.RequestURL);
        WebClientResultInfo result = WebClient.sendRequest(meta, this.getRetryTimes());
        if(result.success)
        {
            Debugger.LogFactory.trace("Request {} success", meta.RequestURL);
            return result.response;
        }
        Debugger.LogFactory.warn("Request {} failed", meta.RequestURL);
        if(result.response!=null && JsonController.isJsonObject(result.response)){
            throw new IllegalArgumentException(Utility.jacksonFromJson(result.response, GenericResponse.class, String.class).meta.message);
        }
        throw new IllegalArgumentException(result.errorMessage);
    }
}
