package LinkFuture.Core.GenericRepository.Repository;

import LinkFuture.Core.ContentManager.Model.ContentType;
import LinkFuture.Core.ContentManager.Model.ResponseType;
import LinkFuture.Core.GenericRepository.Entity.GenericResponse;
import LinkFuture.Core.JsonManager.JsonController;
import LinkFuture.Core.UriBuilder;
import LinkFuture.Core.Utility;
import LinkFuture.Core.WebClient.WebClient;
import LinkFuture.Core.WebClient.WebClientResultInfo;
import LinkFuture.Core.WebClient.WebRequestInfo;
import org.json.JSONObject;

import java.io.Serializable;
import java.net.URL;

/*
 * Created by Cyokin
 * on 10/12/2015.
     @JsonIgnoreProperties(ignoreUnknown = true)
     @JsonInclude(JsonInclude.Include.NON_NULL)
     public class CityEntity {
         public static final String ID = "id";
         public static final String NAME = "name";
         public static final String ZONE_ID = "zone_id";
         public static final String CREATE_USER = "create_user";
         @JsonProperty(ID)
         @FieldAttribute(name = ID,isKey = true)
         public Long Id;

         @JsonProperty(NAME)
         @FieldAttribute(name = NAME)
         public String Name;

         @JsonProperty(ZONE_ID)
         @FieldAttribute(name = ZONE_ID)
         public Integer ZoneId;

         @JsonProperty(CREATE_USER)
         @FieldAttribute(name = CREATE_USER)
         public Integer CreateUser;

         @JsonFormat(shape= JsonFormat.Shape.STRING, pattern= Config.DefaultTimeFormat)
         @JsonProperty("create_time")
         @FieldAttribute(name = "create_time")
         public Date CreateTime;
     }
     Notice: make sure use Integer/Long type, instead of int/long type, as int/long is not null able type.
 */

@SuppressWarnings("WeakerAccess")
public abstract class GenericWebRepository<T,ID extends Serializable> extends BaseRepository<T,ID>  implements IGenericRepository<T,ID> {
    public GenericWebRepository(String requestPath) {
        super(requestPath);
    }

    //region retryTimes
    private int retryTimes = 3;
    @SuppressWarnings("unused")
    public void setRetryTimes(int times){
        retryTimes = times;
    }
    public int getRetryTimes(){
        return this.retryTimes;
    }
    //endregion

    @Override
    protected <R> Object genericDBResourceLoad(String requestUrl,LinkFuture.Core.WebClient.HttpMethod method,R requestObject) throws Exception{

        WebRequestInfo meta = new WebRequestInfo();
        meta.addHead("Accept",ResponseType.Json);
        meta.RequestMethod = method;
        switch (method)
        {
            case Get:
            case Delete:
                UriBuilder uriBuilder =  UriBuilder.create(requestUrl).addQuery(JSON_QUERY, Utility.jacksonToJson(requestObject));
                meta.RequestURL = uriBuilder.buildURL();
                break;
            case Post:
            case Put:
                meta.RequestURL = new URL(requestUrl);
                meta.addHead("Content-Type",ContentType.Json.getContentType());
                meta.addPayload(Utility.jacksonToJson(requestObject));
                break;
        }
        WebClientResultInfo result = WebClient.sendRequest(meta,this.getRetryTimes());
        if(result.success)
        {
            logger.trace(result.response == null ? "No result found" : result.response);
            return new JSONObject(result.response).get("response");
        }
        if(result.response!=null && JsonController.isJsonObject(result.response)){
            throw new IllegalArgumentException(Utility.jacksonFromJson(result.response,GenericResponse.class,String.class).meta.message);
        }
        throw new IllegalArgumentException(result.errorMessage);
    }
    @Override
    protected <R> Object genericDBResourceLoad(LinkFuture.Core.WebClient.HttpMethod method,R requestObject) throws Exception {
        return genericDBResourceLoad(this.requestPath,method,requestObject);
    }

}
