package LinkFuture.Core.ContentManager.Model;

import LinkFuture.Core.JsonManager.JsonOptionInfo;
import LinkFuture.Init.ObjectExtend.JAXBMapKeyAttribute;

import javax.xml.bind.annotation.*;
import java.util.ArrayList;

/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 10:48 AM
 */

@XmlRootElement(name = "ContentItem")
public class ContentItemInfo
{
    @XmlAttribute(name = "Name")
    @JAXBMapKeyAttribute
    public String Name;

    @XmlAttribute(name = "Version")
    public Integer Version;

    @XmlAttribute(name = "Disabled")
    public boolean Disabled;

    @XmlAttribute(name = "CacheSettingKey")
    public String CacheSettingKey;

    @XmlAttribute(name = "OutputCacheProfileKey")
    public String OutputCacheProfileKey;

    /**
     * design when IgnoreException = "true", but want to shorter cache time.
     */
    @XmlAttribute(name = "IgnoredExceptionOutputCacheProfileKey")
    public String IgnoredExceptionOutputCacheProfileKey;

    @XmlElement(name = "Validator")
    @XmlElementWrapper(name = "ValidatorList")
    public  ArrayList<ValidatorInfo> ValidatorList;

    @XmlElement(name = "Parameter")
    @XmlElementWrapper(name = "ParameterList")
    public ArrayList<AddInfo> ParameterList;

    //cached object after reader
    @XmlTransient
    public ArrayList<ParameterInfo> CachedParameterList;

    @XmlElement(name = "Security")
    @XmlElementWrapper(name = "SecurityList")
    public ArrayList<AddInfo> SecurityList;

    //cached object after reader
    @XmlTransient
    public ArrayList<SecurityInfo> CachedSecurityList;


    @XmlElement(name = "Resource")
    @XmlElementWrapper(name = "ResourceList")
    public ArrayList<AddInfo> ResourceList;

    //cached object after reader
    @XmlTransient
    public ArrayList<ArrayList<ResourceRunningInfo>> CachedResourceList;

    @XmlElement(name = "Processor")
    @XmlElementWrapper(name = "ProcessorList")
    public ArrayList<AddInfo> ProcessorList;

    //cached object after reader
    @XmlTransient
    public ArrayList<ProcessorRunningInfo> CachedProcessorList;

    @XmlElement(name ="JsonOption")
    public JsonOptionInfo JsonOption;
}