package LinkFuture.Core.ContentManager.ContentResource;

import LinkFuture.Core.ContentManager.ContentController;
import LinkFuture.Core.ContentManager.Model.*;
import LinkFuture.Core.DBHelper.DBHelper;
import LinkFuture.Core.DBHelper.Model.*;
import LinkFuture.Core.DBHelper.NewGenericDBHelper;
import LinkFuture.Core.WebClient.HttpMethod;
import LinkFuture.Init.ConfigurationManager.ConfigurationController;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.ObjectExtend.NameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

import javax.naming.NamingException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;

/**
 * Created by Cyokin
 * on 7/1/2015.
 */
public class GenericDBContentResource extends ContentBeanBaseResource<GenericDBContentResourceMetaInfo> {

    public static final String $JSON_QUERY = "$JsonQuery";
    String DBConnectionString;
    public GenericDBContentResource(ResourceRunningInfo runningInfo) throws Exception {
        super(runningInfo,GenericDBContentResourceMetaInfo.class);
    }
    private HttpMethod getRequestMethod(ContentParameterCollectionInfo parameters)
    {
        if(parameters.containsKey(ContentController.LF_HTTP_METHOD))
        {
            return (HttpMethod)parameters.get(ContentController.LF_HTTP_METHOD);
        }
        else
        {
            return HttpMethod.Get;
        }
    }
    private void injectDefaultParameters(JSONObject jsonQuery,DBActionInfo action){
        if(this.Meta.hasDefaultParameters(action))
        {
            JSONObject whereQuery;
            if(jsonQuery.has(NewGenericDBHelper.$WHERE))
            {
                whereQuery = jsonQuery.getJSONObject(NewGenericDBHelper.$WHERE);
            }
            else
            {
                whereQuery = new JSONObject();
                jsonQuery.put(NewGenericDBHelper.$WHERE,whereQuery);
            }
            injectWhereDefaultParameters(whereQuery,action);
        }
    }
    private void injectWhereDefaultParameters(JSONObject whereQuery,DBActionInfo action){
        if(this.Meta.hasDefaultParameters(action))
        {
            for (DBParameterInfo parameter:action.DefaultParameters)
            {
                if(!whereQuery.has(parameter.Name))
                {
                    whereQuery.put(parameter.Name,parameter.Value);
                }
            }

        }
    }
    private JSONObject buildUpdate(ContentParameterCollectionInfo parameters,Collection<NameValuePair> sqlParams){
        //TODO:why need rebuild json query, as we need inject parameters, is it really necessary?
        if(sqlParams.size()==0)
        {
            throw new IllegalArgumentException("None of parameter is valid");
        }
        JSONObject jsonQuery = new JSONObject();
        for (NameValuePair param:sqlParams)
        {
            jsonQuery.put(param.id,param.value);
        }
        if(parameters.containsKey(NewGenericDBHelper.$WHERE))
        {
            jsonQuery.put(NewGenericDBHelper.$WHERE,new JSONObject((String)parameters.get(NewGenericDBHelper.$WHERE)));
        }
        else
        {
            throw new IllegalArgumentException("Where condition required");
        }
        return jsonQuery;
    }
    private JSONObject buildDelete(ContentParameterCollectionInfo parameters,Collection<NameValuePair> sqlParams){
        if(parameters.containsKey($JSON_QUERY))
        {
            JSONObject jsonQuery = new JSONObject((String)parameters.get($JSON_QUERY));
            injectWhereDefaultParameters(jsonQuery,this.Meta.DeleteAction);
            return jsonQuery;
        }
        else
        {
            if(sqlParams.size()>0)
            {
                JSONObject jsonWhere = new JSONObject();
                for (NameValuePair param:sqlParams)
                {
                    jsonWhere.put(param.id,param.value);
                }
                return jsonWhere;
            }
            else
            {
                throw new IllegalArgumentException("Where condition required");
            }
        }
    }
    private JSONObject buildSelect(ContentParameterCollectionInfo parameters,Collection<NameValuePair> sqlParams){
        if(parameters.containsKey($JSON_QUERY))
        {
            JSONObject jsonQuery = new JSONObject((String)parameters.get($JSON_QUERY));
            injectDefaultParameters(jsonQuery,this.Meta.SelectAction);
            return jsonQuery;
        }
        else
        {
            JSONObject jsonQuery = new JSONObject();
            if(parameters.containsKey("q"))
            {
                String[] queryFields = parameters.get("q").toString().split(",");
                for (String queryField:queryFields)
                {
                    jsonQuery.put(queryField, true);
                }
            }
            if(sqlParams.size()>0)
            {
                JSONObject jsonWhere = new JSONObject();
                for (NameValuePair param:sqlParams)
                {
                    jsonWhere.put(param.id,param.value);
                }
                jsonQuery.put(NewGenericDBHelper.$WHERE,jsonWhere);
            }
            if(parameters.containsKey(NewGenericDBHelper.$SORT))
            {
                jsonQuery.put(NewGenericDBHelper.$SORT,new JSONObject((String)parameters.get(NewGenericDBHelper.$SORT)));
            }
            if(parameters.containsKey(NewGenericDBHelper.$LIMIT))
            {
                jsonQuery.put(NewGenericDBHelper.$LIMIT,parameters.get(NewGenericDBHelper.$LIMIT));
            }
            if(parameters.containsKey(NewGenericDBHelper.$OFFSET))
            {
                jsonQuery.put(NewGenericDBHelper.$OFFSET,parameters.get(NewGenericDBHelper.$OFFSET));
            }
            return jsonQuery;
        }
    }
    private JSONObject buildInsert(ContentParameterCollectionInfo parameters,Collection<NameValuePair> sqlParams){
        if(sqlParams.size()>0)
        {
            JSONObject jsonInsert = new JSONObject();
            for (NameValuePair param:sqlParams)
            {
                jsonInsert.put(param.id,param.value);
            }
            return jsonInsert;
        }
        else
        {
            throw new IllegalArgumentException("Parameter required");
        }
    }
    @Override
    public ContentResultInfo RetrieveResource(ContentItemInfo content, ContentParameterCollectionInfo parameters) throws Exception {
        try(NewGenericDBHelper helper = new NewGenericDBHelper(DBConnectionString)){
            HttpMethod requestMethod = getRequestMethod(parameters);
            ContentResultInfo result = new ContentResultInfo();
            result.Meta = this.Meta.TableName;
            result.Success = true;
            result.ErrorCode = 500;
            result.ResultType = getResponseType(parameters);
            Collection<NameValuePair> sqlParams = BuildParameters(parameters);
            Debugger.LogFactory.trace("Retrieve DB resource {} with {} mode",content.Name,requestMethod);
            switch (requestMethod)
            {
                //region Get
                case Get:
                    if(this.Meta.SelectAction!=null && this.Meta.SelectAction.Disabled)
                    {
                        throw new IllegalArgumentException("Specific request method doesn't support! " + requestMethod);
                    }
                    JSONObject selectQuery = buildSelect(parameters,sqlParams);
                    if(!this.Meta.hasAction(this.Meta.SelectAction))
                    {
                        if(result.ResultType==ContentResultType.Json)
                        {
                            result.Result = helper.selectToJson(this.Meta.TableName,selectQuery);
                        }
                        else
                        {
                            result.Result = helper.selectToXml(this.Meta.TableName,selectQuery);
                        }
                    }
                    else
                    {
                        if(parameters.containsKey($JSON_QUERY))
                        {
                            throw new IllegalArgumentException("We are not support generic json query when have customize action.");
                        }
                        for (NameValuePair params:sqlParams)
                        {
                            helper.addParameter(params.id,params.value);
                        }
                        if(result.ResultType==ContentResultType.Json)
                        {
                            result.Result = helper.executeToJson(this.Meta.SelectAction.Action,this.Meta.SelectAction.CommandType);
                        }
                        else
                        {
                            result.Result = helper.executeToXml(this.Meta.SelectAction.Action,this.Meta.SelectAction.CommandType);
                        }
                    }
                    break;
                //endregion
                //region Post
                case Post:
                    if(this.Meta.UpdateAction!=null && this.Meta.UpdateAction.Disabled)
                    {
                        throw new IllegalArgumentException("Specific request method doesn't support! " + requestMethod);
                    }
                    if(!this.Meta.hasAction(this.Meta.UpdateAction))
                    {
                        JSONObject updateQuery = buildUpdate(parameters,sqlParams);
                        result.Result = helper.update(this.Meta.TableName, updateQuery);
                    }
                    else
                    {
                        for (NameValuePair params:sqlParams)
                        {
                            helper.addParameter(params.id,params.value);
                        }
                        if(this.Meta.UpdateAction.CommandType==CommandTypeInfo.TSQL)
                        {
                            result.Result = helper.executeSQL(this.Meta.UpdateAction.Action);
                        }
                        else
                        {
                            if(result.ResultType==ContentResultType.Json)
                            {
                                result.Result = helper.executeToJson(this.Meta.UpdateAction.Action,this.Meta.UpdateAction.CommandType);
                            }
                            else
                            {
                                result.Result = helper.executeToXml(this.Meta.UpdateAction.Action,this.Meta.UpdateAction.CommandType);
                            }
                        }
                    }
                    break;
                //endregion
                //region Delete
                case Delete:
                    if(this.Meta.DeleteAction!=null && this.Meta.DeleteAction.Disabled)
                    {
                        throw new IllegalArgumentException("Specific request method doesn't support! " + requestMethod);
                    }
                    if(!this.Meta.hasAction(this.Meta.DeleteAction))
                    {
                        result.Result = helper.delete(this.Meta.TableName, buildDelete(parameters,sqlParams));
                    }
                    else
                    {
                        if(parameters.containsKey($JSON_QUERY))
                        {
                            throw new IllegalArgumentException("We are not support generic json query when have customize action.");
                        }
                        for (NameValuePair params:sqlParams)
                        {
                            helper.addParameter(params.id,params.value);
                        }
                        if(this.Meta.DeleteAction.CommandType==CommandTypeInfo.TSQL)
                        {
                            result.Result = helper.executeSQL(this.Meta.DeleteAction.Action);
                        }
                        else
                        {
                            if(result.ResultType==ContentResultType.Json)
                            {
                                result.Result = helper.executeToJson(this.Meta.DeleteAction.Action,this.Meta.DeleteAction.CommandType);
                            }
                            else
                            {
                                result.Result = helper.executeToXml(this.Meta.DeleteAction.Action,this.Meta.DeleteAction.CommandType);
                            }
                        }
                    }
                    break;
                //endregion
                //region Put
                case Put:
                    if(this.Meta.InsertAction!=null && this.Meta.InsertAction.Disabled)
                    {
                        throw new IllegalArgumentException("Specific request method doesn't support! " + requestMethod);
                    }
                    if(!this.Meta.hasAction(this.Meta.InsertAction))
                    {
                        //bulk insert
                        if(parameters.containsKey(ContentController.LF_PLAY_LOAD))
                        {
                            String playLoad = ((String)parameters.get(ContentController.LF_PLAY_LOAD)).trim();
                            if(playLoad.startsWith("[") && playLoad.endsWith("]"))
                            {
                                result.Result = new JSONObject(String.format("{\"identity\":%s}",helper.insert(this.Meta.TableName, new JSONArray(playLoad))));
                                break;
                            }
                        }
                        //insert
                        JSONObject jsonInsert = buildInsert(parameters,sqlParams);
                        result.Result = new JSONObject(String.format("{\"identity\":%s}",helper.insert(this.Meta.TableName, jsonInsert)));
                    }
                    else
                    {
                        for (NameValuePair params:sqlParams)
                        {
                            helper.addParameter(params.id,params.value);
                        }
                        if(this.Meta.InsertAction.CommandType==CommandTypeInfo.TSQL)
                        {
                            result.Result = new JSONObject(String.format("{\"identity\":%s}",helper.insert(this.Meta.InsertAction.Action)));
                        }
                        else
                        {
                            if(result.ResultType==ContentResultType.Json)
                            {
                                result.Result = helper.executeToJson(this.Meta.InsertAction.Action,this.Meta.InsertAction.CommandType);
                            }
                            else
                            {
                                result.Result = helper.executeToXml(this.Meta.InsertAction.Action,this.Meta.InsertAction.CommandType);
                            }
                        }
                    }
                    break;
                //endregion
                case Options:
                    result.Result = "Allow: GET(search),PUT(insert,bulk insert),POST(patch update),DELETE(delete),OPTIONS";
                    break;
                case Patch:
                case Head:
                    throw new IllegalArgumentException("Specific request method doesn't support! " + requestMethod);
            }
            result.ErrorCode = 200;
            return result;

        }
    }

    @Override
    public String BuildResourceIdentity(ContentItemInfo content, ContentParameterCollectionInfo parameters) throws Exception {
        StringBuilder argsSb = new StringBuilder();
        argsSb.append("$GenericDBContentResource$");
        argsSb.append(this.CurrentResource.Name);
        argsSb.append("=>");
        argsSb.append(this.CurrentResource.Meta);
        argsSb.append("$ContentResultType$");
        argsSb.append(getResponseType(parameters));
        argsSb.append("$RequestMethod$");
        argsSb.append(parameters.get(ContentController.LF_HTTP_METHOD));
        argsSb.append("$SqlParameters$");
        Collection<NameValuePair> sqlParams = BuildParameters(parameters);
        for (NameValuePair param:sqlParams)
        {
            argsSb.append(String.format("%s:%s", param.id, param.value));
        }
        if(parameters.containsKey("q"))
        {
            argsSb.append(String.format("q:%s", parameters.get("q")));
        }
        if(parameters.containsKey($JSON_QUERY))
        {
            argsSb.append(String.format("$JSON_QUERY:%s", parameters.get($JSON_QUERY)));
        }
        return argsSb.toString();
    }

    @Override
    public void Verify(ResourceInfo currentResource) throws Exception {
        DBConnectionString = ConfigurationController.AppSettings(this.Meta.ConnectionStringName);
        TableInfo table = DBHelper.findTableInfo(DBConnectionString,this.Meta.TableName);
        if(table==null || table.columnList.size()==0){
            throw new IllegalArgumentException("Specific table name doesn't exist:" + this.Meta.TableName);
        }
        if(this.Meta.hasAction(this.Meta.SelectAction) && this.Meta.SelectAction.CommandType==null)
        {
            this.Meta.SelectAction.CommandType = CommandTypeInfo.TSQL;
        }
        if(this.Meta.hasAction(this.Meta.DeleteAction) && this.Meta.DeleteAction.CommandType==null)
        {
            this.Meta.DeleteAction.CommandType = CommandTypeInfo.TSQL;
        }
        if(this.Meta.hasAction(this.Meta.UpdateAction) && this.Meta.UpdateAction.CommandType==null)
        {
            this.Meta.UpdateAction.CommandType = CommandTypeInfo.TSQL;
        }
        if(this.Meta.hasAction(this.Meta.InsertAction) && this.Meta.InsertAction.CommandType==null)
        {
            this.Meta.InsertAction.CommandType = CommandTypeInfo.TSQL;
        }
    }

    public Collection<NameValuePair> BuildParameters(ContentParameterCollectionInfo parameters) throws Exception {
        TableInfo table = DBHelper.findTableInfo(DBConnectionString,this.Meta.TableName);
        HashMap<String,NameValuePair> sqlParams = new HashMap<>();
        for (ColumnInfo column:table.columnList)
        {
            for (String key:parameters.keySet())
            {
                if(column.sameColumnName(key))
                {
                    sqlParams.put(key,new NameValuePair(key, parameters.get(key)));
                    break;
                }
            }
        }
        //append pagination parameter
        if(parameters.containsKey("$limit"))
        {
            sqlParams.put("limit",new NameValuePair("limit", parameters.get("limit")));
        }
        if(parameters.containsKey("$offset"))
        {
            sqlParams.put("offset",new NameValuePair("offset", parameters.get("offset")));
        }
        //append param if we have custom action
        HttpMethod requestMethod = getRequestMethod(parameters);
        switch (requestMethod)
        {
            case Post:
                appendParams(this.Meta.UpdateAction,parameters, sqlParams);
                break;
            case Delete:
                appendParams(this.Meta.DeleteAction,parameters, sqlParams);
                break;
            case Put:
                appendParams(this.Meta.InsertAction,parameters, sqlParams);
                break;
            default:
                appendParams(this.Meta.SelectAction,parameters, sqlParams);
        }
        return sqlParams.values();
    }

    private void appendParams(DBActionInfo action,ContentParameterCollectionInfo parameters, HashMap<String, NameValuePair> sqlParams) throws SQLException, ClassNotFoundException, IOException, NamingException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if(this.Meta.hasAction(action))
        {
            SPInfo meta = DBHelper.findSPMetaInfo(DBConnectionString, action.Action, action.CommandType);
            for (SPParameterInfo parameter:meta.parameterList)
            {
                if(parameters.containsKey(parameter.parameterName))
                {
                    sqlParams.put(parameter.parameterName.toLowerCase(),new NameValuePair(parameter.parameterName, parameters.get(parameter.parameterName)));
                }
            }
        }
        else if (this.Meta.hasDefaultParameters(action))
        {
            for (DBParameterInfo parameter:action.DefaultParameters)
            {
                sqlParams.put(parameter.Name.toLowerCase(),new NameValuePair(parameter.Name, parameters.ParamReplace(parameter.Value) ));
            }
        }
    }

}
