package LinkFuture.Core.ContentManager.ContentProcessor;

import LinkFuture.Core.ContentManager.Model.ProcessorRunningInfo;
import LinkFuture.Init.Extensions.StringExtension;

/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 10:48 AM
 */
public abstract class ContentBeanBaseProcessor<T> extends ContentBaseProcessor {
    public ContentBeanBaseProcessor(ProcessorRunningInfo runningInfo,Class<T> type) throws Exception {
        super(runningInfo);
        if (this.CurrentProcessor != null && !StringExtension.IsNullOrEmpty(this.CurrentProcessor.Meta))
        {
            runningInfo.processor.setMetaObj(type);
            this.Meta = runningInfo.processor.getMetaObj();
            this.Verify(this.CurrentProcessor);
        }
    }
    public T Meta;
}
