package LinkFuture.Core.ContentManager.ContentAction;

import LinkFuture.Core.ContentManager.ContentParameter.IContentParameter;
import LinkFuture.Core.ContentManager.ContentProcessor.IContentProcessor;
import LinkFuture.Core.ContentManager.ContentResource.IContentResource;
import LinkFuture.Core.ContentManager.ContentSecurity.IContentSecurity;
import LinkFuture.Core.ContentManager.ContentValidator.IContentValidator;
import LinkFuture.Core.ContentManager.Model.*;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;
import LinkFuture.Init.ObjectExtend.NameValuePair;

import java.util.ArrayList;
import java.util.Collection;

/**
 * User: Cyokin Zhang
 * Date: 11/20/13
 * Time: 3:28 PM
 */
public class ContentActionInfo {

    public ContentActionInfo(ContentItemInfo contentItem,Collection<NameValuePair> args)
    {
        this.ContentItem = contentItem;
        this.ParamList = args;
        this.Init();
    }
    public ContentItemInfo ContentItem;
    public Collection<NameValuePair> ParamList;
    public ArrayList<IContentSecurity> SecurityList = new ArrayList<>();
    public ArrayList<IContentValidator> ValidatorList = new ArrayList<>();
    public ArrayList<IContentParameter> ParameterList = new ArrayList<>();
    public ArrayList<IContentProcessor> ProcessorList = new ArrayList<>();
    public ArrayList<ArrayList<IContentResource>> ResourceList = new ArrayList<>();
    public boolean ResourceOnly;
    public boolean IgnoreSecurity;

    public String IdentityKey(ContentParameterCollectionInfo parameters) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("$CL_ContentItem$");
        sb.append(this.ContentItem.Name);
        sb.append("_");
        sb.append(this.ContentItem.CacheSettingKey);
        sb.append("_");
        sb.append(this.ContentItem.OutputCacheProfileKey);
        sb.append("_");
        sb.append("$ResourceIdentity$");
        //apply resource identity
        //this is design when parameters change in resource, it will cause output differently
        for(ArrayList<IContentResource> resourcesList:this.ResourceList)
        {
            for (IContentResource resource:resourcesList)
            {
                sb.append(resource.GerResourceIdentity(this.ContentItem, parameters));
                sb.append("_");
            }
        }
        if(this.ProcessorList.size()>0)
        {
            sb.append("$ProcessorIdentity$");
            for(IContentProcessor processor:this.ProcessorList)
            {
                sb.append(processor.GerProcessorIdentity(parameters));
                sb.append("_");
            }
        }
        sb.append("__END");
        return sb.toString();
    }

    public ContentParameterCollectionInfo BuildContentParameter() throws Exception {
        ContentParameterCollectionInfo list = new ContentParameterCollectionInfo();
        //user param always go first
        if(this.ParamList!=null)
        {
            for (NameValuePair item:this.ParamList)
            {
                list.put(item.id,item.value);
            }
        }
        //system parameter will always overwrite user parameters
        for (IContentParameter item :this.ParameterList)
        {
            CaseInsensitiveMap<Object> parameterList = item.GerParameter(list);
            for (String paramKey:parameterList.keySet())
            {
                list.put(paramKey,parameterList.get(paramKey));
            }
        }
        return list;
    }

    private void Init(){
        try
        {
            if (this.ContentItem.CachedSecurityList!=null)
            {
                for (SecurityInfo item:this.ContentItem.CachedSecurityList)
                {
                    this.SecurityList.add(item.getContentSecurity());
                }
            }
            if (this.ContentItem.CachedParameterList!=null)
            {
                for (ParameterInfo item:this.ContentItem.CachedParameterList)
                {
                    this.ParameterList.add(item.getContentParameter());
                }
            }
            if(this.ContentItem.ValidatorList!=null)
            {
                for(ValidatorInfo item:this.ContentItem.ValidatorList)
                {
                    this.ValidatorList.add(item.getContentValidator(this.ContentItem));
                }
            }
            if (this.ContentItem.CachedResourceList!=null)
            {
                for (ArrayList<ResourceRunningInfo> resourceList:this.ContentItem.CachedResourceList)
                {
                    ArrayList<IContentResource> contentResourcesList = new ArrayList<>();
                    for (ResourceRunningInfo item:resourceList)
                    {
                         contentResourcesList.add(item.getContentResource());
                    }
                    this.ResourceList.add(contentResourcesList);
                }
            }
            if (this.ContentItem.CachedProcessorList!=null)
            {
                for (ProcessorRunningInfo item:this.ContentItem.CachedProcessorList)
                {
                    this.ProcessorList.add(item.getContentProcessor());
                }
            }
        }
        catch (Exception ex)
        {
            throw new RuntimeException(ex);
        }
    }
}
