package LinkFuture.Core;

import LinkFuture.Core.MemoryManager.StaticMemoryCache.StaticMemoryCacheHelper;
import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.StringExtension;

import java.lang.reflect.Constructor;
import java.util.HashMap;


/**
 * LinkFuture.
 * User: Cyokin Zhang
 * Date: 10/12/13
 * Time: 9:56 PM
 */
public class ActivatorsStorage {
    private static final HashMap<String,Class<?>> primitiveMap =new HashMap(){{
        put("java.lang.Integer", Integer.TYPE);
        put("java.lang.Long", Long.TYPE);
        put("java.lang.Double", Double.TYPE);
        put("java.lang.Float", Float.TYPE);
        put("java.lang.Boolean", Boolean.TYPE);
        put("java.lang.Character", Character.TYPE);
        put("java.lang.Byte", Byte.TYPE);
        put("java.lang.Void", Void.TYPE);
        put("java.lang.Short", Short.TYPE );
    }};

    public static<T> T GetActivator(String typeString,Object...args) throws Exception {
        VerifyClass(typeString,args);
        return (T)((Constructor) StaticMemoryCacheHelper.GetNeverExpiredMemoryCache(getUniqueKey(typeString,args))).newInstance(args);
    }

    public static void VerifyClass(String typeString, final Object...args) throws Exception {
        if(StringExtension.IsNullOrEmpty(typeString))
        {
            throw new IllegalArgumentException("type name can't not be null.");
        }
        String key = getUniqueKey(typeString,args);
        StaticMemoryCacheHelper.AddNeverExpiredMemoryCache(key, new Operation<Object>(typeString,args) {
            @Override
            public Object call() throws Exception {
                String className = (String) this.params[0];
                Debugger.LogFactory.trace("Activating class {}", className);
                Object[] passedArgs = (Object[])params[1];
                Class myClass = Class.forName(className);
                Constructor[] cst = myClass.getConstructors();
                if (cst.length > 0) {
                    for (Constructor cs:cst)
                    {
                        Class<?>[] parameterTypes =  cs.getParameterTypes();
                        if(parameterTypes.length == passedArgs.length)
                        {
                            boolean foundStructure = true;
                            for (int i=0;i<parameterTypes.length;i++)
                            {

                                if(!isAssignableFrom(parameterTypes[i],passedArgs[i].getClass(),true))
                                {
                                    foundStructure = false;
                                    break;
                                }
                            }
                            if(foundStructure)
                            {
                                return cs;
                            }
                        }
                    }
                }
                throw new IllegalArgumentException(String.format("Can't init %s type, as it don't have default constructor.",className));
            }
        });
    }
    private static String getUniqueKey(String typeString,Object... args)
    {
        StringBuilder sb = new StringBuilder();
        sb.append("$ActivatorsStorage$_");
        sb.append(typeString);
        sb.append("_");
        for (Object ob :args)
        {
            sb.append(ob.getClass());
        }
        return  sb.toString();
    }
    public static boolean isAssignableFrom(Class<?> a,Class<?> b,boolean convertPrimitiveType)
    {
        if(convertPrimitiveType)
        {
            if(a.isPrimitive() && primitiveMap.containsKey(b.getName()))
            {
                b = primitiveMap.get(b.getName());
                return a.isAssignableFrom(b);
            }
            if(b.isPrimitive() && primitiveMap.containsKey(a.getName()))
            {
                a = primitiveMap.get(a.getName());
                return a.isAssignableFrom(b);
            }
        }
        return a.isAssignableFrom(b);
    }

}
