/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.JsonManager;

import LinkFuture.Core.JsonManager.JsonObjectInfo;
import LinkFuture.Core.JsonManager.JsonObjectType;
import LinkFuture.Init.Extensions.StringExtension;
import com.sun.org.apache.xerces.internal.impl.XMLStreamReaderImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.SAXException;

public class JsonObjectReader
implements AutoCloseable {
    XMLStreamReader streamReader;

    public JsonObjectReader(String xmlString) throws ParserConfigurationException, IOException, SAXException, XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
        this.streamReader = inputFactory.createXMLStreamReader(in);
    }

    public JsonObjectInfo toJsonObj() throws XMLStreamException {
        JsonObjectInfo rootObj = new JsonObjectInfo();
        rootObj.XPath = "";
        if (this.streamReader.hasNext()) {
            this.parseToJson(rootObj);
            return rootObj.ChildNodes.get(0);
        }
        return null;
    }

    private String getNodeName(QName name) {
        if (StringExtension.IsNullOrEmpty(name.getPrefix())) {
            return name.getLocalPart();
        }
        return name.getPrefix() + ":" + name.getLocalPart();
    }

    private void parseToJson(JsonObjectInfo parentObj) throws XMLStreamException {
        boolean hasNext = true;
        while (hasNext) {
            int current = this.streamReader.getEventType();
            String CHARACTERS = null;
            switch (current) {
                case 1: {
                    JsonObjectInfo attr;
                    int i;
                    JsonObjectInfo newObj = new JsonObjectInfo();
                    newObj.Name = this.getNodeName(this.streamReader.getName());
                    newObj.XPath = parentObj.XPath + "/" + newObj.Name;
                    newObj.Parent = parentObj;
                    newObj.Type = JsonObjectType.Element;
                    if (this.streamReader.getAttributeCount() > 0) {
                        newObj.ChildNodes = new ArrayList();
                        for (i = 0; i < this.streamReader.getAttributeCount(); ++i) {
                            attr = new JsonObjectInfo();
                            attr.Type = JsonObjectType.Attribute;
                            attr.Name = this.streamReader.getAttributeNamespace(i) == null ? this.streamReader.getAttributeLocalName(i) : this.streamReader.getAttributePrefix(i) + ":" + this.streamReader.getAttributeLocalName(i);
                            attr.XPath = newObj.XPath + "/@" + attr.Name;
                            attr.Value = this.streamReader.getAttributeValue(i);
                            attr.Parent = newObj;
                            if (attr.Name.equalsIgnoreCase("i:nil") && attr.Value.equalsIgnoreCase("true")) continue;
                            newObj.ChildNodes.add(attr);
                        }
                    }
                    if (this.streamReader.getNamespaceCount() > 0) {
                        if (newObj.ChildNodes == null) {
                            newObj.ChildNodes = new ArrayList();
                        }
                        for (i = 0; i < this.streamReader.getNamespaceCount(); ++i) {
                            attr = new JsonObjectInfo();
                            attr.Name = this.streamReader.getNamespacePrefix(i);
                            attr.XPath = newObj.XPath + "/@" + attr.Name;
                            attr.Value = this.streamReader.getNamespaceURI(i);
                            attr.Parent = newObj;
                            attr.Type = JsonObjectType.Namespace;
                            newObj.ChildNodes.add(attr);
                        }
                    }
                    if (parentObj.ChildNodes == null) {
                        parentObj.ChildNodes = new ArrayList();
                    }
                    parentObj.ChildNodes.add(newObj);
                    parentObj = newObj;
                    break;
                }
                case 2: {
                    parentObj = parentObj.Parent;
                }
            }
            if (this.streamReader.hasNext()) {
                while (this.streamReader.next() == 4) {
                    String tmp;
                    if (!((XMLStreamReaderImpl)this.streamReader).hasValue() || StringExtension.IsNullOrEmpty(tmp = ((XMLStreamReaderImpl)this.streamReader).getValue().trim())) continue;
                    if (CHARACTERS == null) {
                        CHARACTERS = tmp;
                        continue;
                    }
                    CHARACTERS = CHARACTERS + tmp;
                }
                if (StringExtension.IsNullOrEmpty(CHARACTERS) || this.streamReader.getEventType() != 2) continue;
                if (parentObj.ChildNodes == null) {
                    parentObj.Value = CHARACTERS;
                    continue;
                }
                JsonObjectInfo cDataObj = new JsonObjectInfo();
                cDataObj.Name = "$";
                cDataObj.XPath = parentObj.XPath + "/text()";
                cDataObj.Value = CHARACTERS;
                cDataObj.Parent = parentObj;
                cDataObj.Type = JsonObjectType.CDATA;
                parentObj.ChildNodes.add(cDataObj);
                continue;
            }
            hasNext = false;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.streamReader != null) {
            this.streamReader.close();
            this.streamReader = null;
        }
    }
}

