/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.GenericRepository.EntityBuilder;

import LinkFuture.Core.DBHelper.DBHelper;
import LinkFuture.Core.DBHelper.Model.ColumnInfo;
import LinkFuture.Core.DBHelper.Model.TableInfo;
import LinkFuture.Init.Extensions.DateExtension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class EntityBuilderController {
    public static void main(String[] args) throws Exception {
        EntityBuilderController.writeLog("Start build entity", new Object[0]);
        if (args.length != 6) {
            EntityBuilderController.usage();
            System.exit(1);
        }
        HashMap<String, String> params = EntityBuilderController.findParam(args);
        String connection = params.get("connection");
        String packageName = params.get("package");
        String dir = params.get("dir");
        EntityBuilderController.buildEntityList(connection, packageName, dir);
        EntityBuilderController.writeLog("End build entity successfully!", new Object[0]);
    }

    private static void buildEntityList(String connection, String packageName, String dir) throws Exception {
        try (DBHelper helper = new DBHelper(connection);){
            ConcurrentHashMap<String, TableInfo> allTableInfo = helper.findAllTableInfo();
            for (TableInfo table : allTableInfo.values()) {
                EntityBuilderController.writeLog("build entity %s", table.name);
                EntityBuilderController.buildEntity(table, packageName, dir);
            }
        }
    }

    private static void buildEntity(TableInfo table, String packageName, String dir) throws ParseException, FileNotFoundException {
        String className = EntityBuilderController.getJavaColumnName(table.name) + "Entity";
        File file = Paths.get(dir, className + ".java").toFile();
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.printf("package %s;", packageName);
        printWriter.println();
        printWriter.println("import LinkFuture.Init.Config;");
        printWriter.println("import LinkFuture.Core.GenericRepository.Entity.FieldAttribute;");
        printWriter.println("import com.fasterxml.jackson.annotation.JsonFormat;");
        printWriter.println("import com.fasterxml.jackson.annotation.JsonIgnoreProperties;");
        printWriter.println("import com.fasterxml.jackson.annotation.JsonInclude;");
        printWriter.println("import com.fasterxml.jackson.annotation.JsonProperty;");
        printWriter.println("/**");
        printWriter.println("* Created by LinkFuture Auto");
        printWriter.printf("* Generated on %s.", DateExtension.Format(new Date(), "MM/dd/yyyy"));
        printWriter.println();
        printWriter.println("*/");
        printWriter.println("@JsonIgnoreProperties(ignoreUnknown = true)");
        printWriter.println("@JsonInclude(JsonInclude.Include.NON_NULL)");
        printWriter.printf("public class %s {", className);
        printWriter.println();
        HashMap<String, Integer> duplicatedColumnName = new HashMap<String, Integer>();
        for (ColumnInfo column : table.columnList) {
            String columnAnnotationName = column.columnName.toUpperCase();
            String columnPropertyName = EntityBuilderController.getJavaColumnName(column.columnName);
            if (duplicatedColumnName.containsKey(columnPropertyName)) {
                Integer newOrder = (Integer)duplicatedColumnName.get(columnPropertyName) + 1;
                duplicatedColumnName.put(columnPropertyName, newOrder);
                columnPropertyName = columnPropertyName + newOrder;
            } else {
                duplicatedColumnName.put(columnPropertyName, 0);
            }
            printWriter.println();
            if (column.isUnknownJavaType()) {
                printWriter.println("/*");
            }
            printWriter.printf("    public static final String %s = \"%s\";", columnAnnotationName, column.columnName);
            printWriter.println();
            printWriter.printf("    @JsonProperty(%s)", columnAnnotationName);
            printWriter.println();
            printWriter.printf("    @FieldAttribute(name = %s,isKey = %s)", columnAnnotationName, column.isKey);
            printWriter.println();
            if (columnPropertyName.contains("Date")) {
                printWriter.println("    @JsonFormat(shape= JsonFormat.Shape.STRING, pattern= Config.DefaultTimeFormat)");
            }
            printWriter.printf("    public %s %s;", column.getJavaClassNameBySqlType(), columnPropertyName);
            printWriter.println();
            if (!column.isUnknownJavaType()) continue;
            printWriter.println("*/");
        }
        printWriter.println("}");
        printWriter.close();
        EntityBuilderController.writeLog("%s done", className);
    }

    private static String getJavaColumnName(String dbColumnName) {
        StringWriter sb = new StringWriter();
        char[] chars = dbColumnName.toCharArray();
        boolean up = true;
        for (char c : chars) {
            if (c == '_') {
                up = true;
                continue;
            }
            if (up) {
                sb.append(Character.toUpperCase(c));
                up = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static HashMap<String, String> findParam(String[] args) {
        HashMap<String, String> output = new HashMap<String, String>();
        String key = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null && args[i].startsWith("--")) {
                key = args[i].substring(2);
                continue;
            }
            if (key == null) continue;
            output.put(key, args[i]);
        }
        return output;
    }

    private static void writeLog(String msg, Object ... args) {
        if (args.length > 0) {
            System.out.println("[EntityBuilder] " + String.format(msg, args));
        } else {
            System.out.println("[EntityBuilder] " + msg);
        }
    }

    private static void writeError(String msg, Object ... args) {
        if (args.length > 0) {
            System.err.println("[EntityBuilder] " + String.format(msg, args));
        } else {
            System.err.println("[EntityBuilder] " + msg);
        }
    }

    private static void usage() {
        EntityBuilderController.writeError("Usage: java -jar linkfuture.envInjection.jar --connection <DB connection string> --package <Java package name> --dir <Entity file directory>", new Object[0]);
    }
}

