/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.GenericRepository.Entity;

import LinkFuture.Core.GenericRepository.Entity.GenericSort;
import LinkFuture.Core.GenericRepository.Entity.GenericWhere;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class GenericQuery
extends LinkedHashMap<String, Object> {
    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>> {
        private HashMap<String, Object> queryMaps = new LinkedHashMap<String, Object>();
        private HashMap<String, Object> sortMaps = new LinkedHashMap<String, Object>();
        private GenericWhere where;

        public T query(String key) {
            this.queryMaps.put(key, true);
            return (T)this;
        }

        public T limit(int limit) {
            this.queryMaps.put("$limit", limit);
            return (T)this;
        }

        public T offset(int offset) {
            this.queryMaps.put("$offset", offset);
            return (T)this;
        }

        public T sort(String key, GenericSort sort) {
            this.sortMaps.put(key, (Object)sort);
            return (T)this;
        }

        public T where(GenericWhere where) {
            this.where = where;
            return (T)this;
        }

        public GenericQuery build() {
            GenericQuery myQuery = new GenericQuery();
            myQuery.putAll(this.queryMaps);
            if (this.where != null && this.where.size() > 0) {
                myQuery.put("$where", this.where);
            }
            if (this.sortMaps.size() > 0) {
                myQuery.put("$sort", this.sortMaps);
            }
            return myQuery;
        }
    }
}

