/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.DBHelper;

import LinkFuture.Core.DBHelper.DBHelper;
import LinkFuture.Core.DBHelper.Model.ColumnInfo;
import LinkFuture.Core.DBHelper.Model.CommandTypeInfo;
import LinkFuture.Core.DBHelper.Model.DBTypeInfo;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.NameValuePair;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.naming.NamingException;
import org.json.JSONArray;
import org.json.JSONObject;

public class NewGenericDBHelper
extends DBHelper {
    public static final String $WHERE = "$where";
    public static final String $OR = "$or";
    public static final String $GT = "$gt";
    public static final String $GTE = "$gte";
    public static final String $LT = "$lt";
    public static final String $LTE = "$lte";
    public static final String $IN = "$in";
    public static final String $LIKE = "$like";
    public static final String $SIMILAR = "$similar";
    public static final String $SORT = "$sort";
    public static final String $LIMIT = "$limit";
    public static final String $OFFSET = "$offset";

    public NewGenericDBHelper(String connectionString) throws IOException, SQLException, ClassNotFoundException, NamingException {
        super(connectionString);
    }

    private String buildColumnValue(ColumnInfo column, String uniqueColumnName) {
        if (uniqueColumnName == null) {
            uniqueColumnName = column.columnName;
        }
        if (column.sqlType == 2002 || column.sqlType == -7) {
            return String.format("$%s|%s::%s", uniqueColumnName, column.sqlType, column.sqlTypeName);
        }
        if (column.sqlType == 2003) {
            return String.format("$%s|%s::%s[]", uniqueColumnName, column.sqlType, column.getArrayElementTypeName());
        }
        return String.format("$%s|%s", uniqueColumnName, column.sqlType);
    }

    private String buildWhereValue(ColumnInfo column, String subQuery, String uniqueColumnName) throws IllegalAccessException {
        if (column.sqlType == 2003) {
            return String.format("$%s|%s::%s = ANY (%s)", uniqueColumnName, column.getArrayElementType(), column.getArrayElementTypeName(), column.columnName);
        }
        if (column.sqlType == -7) {
            return String.format("%s = $%s|%s::%s", column.columnName, uniqueColumnName, column.sqlType, column.sqlTypeName);
        }
        if (column.isSqlJsonType()) {
            return String.format("%s @> $%s|%s::%s", column.columnName, uniqueColumnName, column.sqlType, column.sqlTypeName);
        }
        if (column.sqlType == 2002) {
            if (StringExtension.IsNullOrEmpty(subQuery)) {
                return String.format("%s = $%s|%s::%s", column.columnName, uniqueColumnName, column.sqlType, column.sqlTypeName);
            }
            return String.format("(%s).%s = $%s|%s", column.columnName, subQuery, uniqueColumnName, 12);
        }
        return String.format("%s = $%s|%s", column.columnName, uniqueColumnName, column.sqlType);
    }

    private String buildUpdateValue(ColumnInfo column, String subQuery, String uniqueColumnName) {
        if (column.sqlType == -7) {
            return String.format("%s = $%s|%s::%s", column.columnName, uniqueColumnName, column.sqlType, column.sqlTypeName);
        }
        if (StringExtension.IsNullOrEmpty(subQuery)) {
            return String.format("%s=%s", column.columnName, this.buildColumnValue(column, uniqueColumnName));
        }
        return String.format("%s.%s= $%s|%s", column.columnName, subQuery, uniqueColumnName, 12);
    }

    public Object insert(String tableName, JSONObject obj) throws Exception {
        JSONArray array = new JSONArray();
        array.put((Object)obj);
        List<Object> list = this.insert(tableName, array);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public List<Object> insert(String tableName, JSONArray obj) throws Exception {
        return super.insert(this.buildInsertTSQL(tableName, obj));
    }

    public int delete(String tableName, NameValuePair ... params) throws Exception {
        JSONObject jsonQuery = this.getQueryJSON(params);
        return this.delete(tableName, jsonQuery);
    }

    public int delete(String tableName, JSONObject jsonQuery) throws Exception {
        return super.executeSQL(this.buildDeleteTSQL(tableName, jsonQuery));
    }

    public int update(String tableName, NameValuePair ... params) throws Exception {
        JSONObject jsonQuery = this.getQueryJSON(params);
        return this.update(tableName, jsonQuery);
    }

    public int update(String tableName, JSONObject jsonQuery) throws Exception {
        return super.executeSQL(this.buildUpdateTSQL(tableName, jsonQuery));
    }

    public JSONObject selectToJson(String tableName, NameValuePair ... params) throws Exception {
        JSONObject jsonQuery = this.getQueryJSON(params);
        return this.selectToJson(tableName, jsonQuery);
    }

    public JSONObject selectToJson(String tableName, JSONObject jsonQuery) throws Exception {
        return super.executeToJson(this.buildSelectTSQL(tableName, jsonQuery), CommandTypeInfo.TSQL);
    }

    public String executeToXml(String tableName, NameValuePair ... params) throws Exception {
        JSONObject jsonQuery = this.getQueryJSON(params);
        return this.selectToXml(tableName, jsonQuery);
    }

    public String selectToXml(String tableName, JSONObject jsonQuery) throws Exception {
        return super.executeToXml(this.buildSelectTSQL(tableName, jsonQuery), CommandTypeInfo.TSQL);
    }

    public String buildDeleteTSQL(String tableName, JSONObject jsonQuery) throws Exception {
        HashMap<String, ColumnInfo> columnList = super.getTableColumnList(tableName);
        String where = this.buildWhereTSQL(columnList, jsonQuery);
        if (StringExtension.IsNullOrEmpty(where)) {
            throw new IllegalArgumentException("Please specific where condition or none of condition is valid for table " + tableName);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(tableName);
        sb.append(" WHERE ");
        sb.append(where);
        return sb.toString();
    }

    public String buildWhereTSQL(HashMap<String, ColumnInfo> columnList, JSONObject jsonWhere) {
        Iterable iterable = () -> jsonWhere.keys();
        StringBuilder sb = new StringBuilder();
        String andString = StreamSupport.stream(iterable.spliterator(), false).filter(c -> {
            String key = (String)c;
            List<String> inputColumnName = this.getInputColumnName(key);
            return columnList.containsKey(inputColumnName.get(0));
        }).map(c -> {
            String key = (String)c;
            Object jsonValue = jsonWhere.get((String)c);
            List<String> columnNameList = this.getInputColumnName(key);
            ColumnInfo column = (ColumnInfo)columnList.get(columnNameList.get(0));
            String uniqueName = this.getUniqueSqlParameterName(column.columnName);
            if (jsonValue instanceof JSONObject) {
                JSONObject compare = (JSONObject)jsonValue;
                String operationString = compare.keySet().iterator().next().toString().toLowerCase();
                Object operationValue = compare.get(operationString);
                switch (operationString) {
                    case "$gt": {
                        if (!comparableTypes.contains(column.sqlType)) {
                            throw new IllegalArgumentException("Specific type does not support $gt operation");
                        }
                        super.addParameter(uniqueName, operationValue);
                        return String.format("%s > $%s|%s", column.columnName, uniqueName, column.sqlType);
                    }
                    case "$gte": {
                        if (!comparableTypes.contains(column.sqlType)) {
                            throw new IllegalArgumentException("Specific type does not support $gte operation");
                        }
                        super.addParameter(uniqueName, operationValue);
                        return String.format("%s >= $%s|%s", column.columnName, uniqueName, column.sqlType);
                    }
                    case "$lt": {
                        if (!comparableTypes.contains(column.sqlType)) {
                            throw new IllegalArgumentException("Specific type does not support $lt operation");
                        }
                        super.addParameter(uniqueName, operationValue);
                        return String.format("%s < $%s|%s", column.columnName, uniqueName, column.sqlType);
                    }
                    case "$lte": {
                        if (!comparableTypes.contains(column.sqlType)) {
                            throw new IllegalArgumentException("Specific type does not support $lte operation");
                        }
                        super.addParameter(uniqueName, operationValue);
                        return String.format("%s <= $%s|%s", column.columnName, uniqueName, column.sqlType);
                    }
                    case "$like": {
                        if (!likeableTypes.contains(column.sqlType)) {
                            throw new IllegalArgumentException("Specific type does not support $like operation");
                        }
                        super.addParameter(uniqueName, operationValue);
                        return String.format("%s LIKE $%s|%s", column.columnName, uniqueName, column.sqlType);
                    }
                    case "$similar": {
                        if (!likeableTypes.contains(column.sqlType)) {
                            throw new IllegalArgumentException("Specific type does not support $similar operation");
                        }
                        if (this.DBType != DBTypeInfo.PostgreSQL) {
                            throw new IllegalArgumentException("$similar operation only support PostgreSQL database");
                        }
                        super.addParameter(uniqueName, operationValue);
                        return String.format("%s SIMILAR TO $%s|%s", column.columnName, uniqueName, column.sqlType);
                    }
                    case "$in": {
                        JSONArray inList = (JSONArray)operationValue;
                        ArrayList<String> inString = new ArrayList<String>();
                        for (int i = 0; i < inList.length(); ++i) {
                            inString.add("'" + inList.get(i).toString() + "'");
                        }
                        return String.format("%s in (%s)", column.columnName, StringExtension.Join(inString, ","));
                    }
                }
                throw new IllegalArgumentException("Specific operation not support yet");
            }
            try {
                super.addParameter(uniqueName, jsonValue);
                return this.buildWhereValue(column, columnNameList.get(1), uniqueName);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }).collect(Collectors.joining(" AND "));
        sb.append(andString);
        if (jsonWhere.has($OR)) {
            JSONArray orArray = jsonWhere.getJSONArray($OR);
            for (int i = 0; i < orArray.length(); ++i) {
                if (i != 0 || andString.length() > 0) {
                    sb.append(" OR ");
                }
                sb.append("(");
                sb.append(this.buildWhereTSQL(columnList, orArray.getJSONObject(i)));
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public String buildSortTSQL(HashMap<String, ColumnInfo> columnList, JSONObject jsonSort) {
        Iterable iterable = () -> jsonSort.keys();
        String sortQuery = StreamSupport.stream(iterable.spliterator(), false).filter(c -> {
            String key = (String)c;
            return columnList.containsKey(key);
        }).map(c -> {
            String key = (String)c;
            String jsonValue = jsonSort.getString((String)c);
            if (jsonValue.equalsIgnoreCase("DESC")) {
                return String.format("%s DESC", key);
            }
            return String.format("%s ASC", key);
        }).collect(Collectors.joining(","));
        return StringExtension.IsNullOrEmpty(sortQuery) ? null : " ORDER BY ".concat(sortQuery);
    }

    public String buildInsertTSQL(String tableName, JSONArray obj) throws Exception {
        HashMap<String, ColumnInfo> columnList = super.getTableColumnList(tableName);
        Supplier<Stream> columnStream = () -> columnList.values().stream();
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(tableName);
        for (int i = 0; i < obj.length(); ++i) {
            JSONObject item = obj.getJSONObject(i);
            if (i == 0) {
                sb.append("(");
                sb.append(columnStream.get().filter(c -> item.has(c.columnName)).map(c -> c.columnName).collect(Collectors.joining(",")));
                sb.append(") VALUES");
            }
            sb.append("(");
            sb.append(columnStream.get().filter(c -> item.has(c.columnName)).map(c -> {
                String uniqueName = this.getUniqueSqlParameterName(c.columnName);
                super.addParameter(uniqueName, item.get(c.columnName));
                return this.buildColumnValue((ColumnInfo)c, uniqueName);
            }).collect(Collectors.joining(",")));
            sb.append(")");
            if (i == obj.length() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String buildUpdateTSQL(String tableName, JSONObject jsonQuery) throws Exception {
        HashMap<String, ColumnInfo> columnList = super.getTableColumnList(tableName);
        if (!jsonQuery.has($WHERE)) {
            throw new IllegalArgumentException("Please specific where condition or none of condition is valid for table " + tableName);
        }
        String where = this.buildWhereTSQL(columnList, jsonQuery.getJSONObject($WHERE));
        if (StringExtension.IsNullOrEmpty(where)) {
            throw new IllegalArgumentException("Please specific where condition or none of condition is valid for table " + tableName);
        }
        Iterable iterable = () -> jsonQuery.keys();
        String setString = StreamSupport.stream(iterable.spliterator(), false).filter(c -> {
            String key = (String)c;
            List<String> inputColumnName = this.getInputColumnName(key);
            return columnList.containsKey(inputColumnName.get(0));
        }).map(c -> {
            String key = (String)c;
            List<String> columnNameList = this.getInputColumnName(key);
            ColumnInfo column = (ColumnInfo)columnList.get(columnNameList.get(0));
            String uniqueName = this.getUniqueSqlParameterName(column.columnName);
            super.addParameter(uniqueName, jsonQuery.get(key));
            return this.buildUpdateValue(column, columnNameList.get(1), uniqueName);
        }).collect(Collectors.joining(","));
        if (StringExtension.IsNullOrEmpty(setString)) {
            throw new IllegalArgumentException("Please set value for update or none of parameters is valid for table " + tableName);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(tableName);
        sb.append(" SET ");
        sb.append(setString);
        sb.append(" WHERE ");
        sb.append(where);
        return sb.toString();
    }

    public String buildSelectTSQL(String tableName, JSONObject jsonQuery) throws Exception {
        String where;
        HashMap<String, ColumnInfo> columnList = super.getTableColumnList(tableName);
        int limit = jsonQuery.has($LIMIT) ? jsonQuery.getInt($LIMIT) : 10;
        int offset = jsonQuery.has($OFFSET) ? jsonQuery.getInt($OFFSET) : 0;
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        String query = columnList.values().stream().filter(c -> jsonQuery.has(c.columnName) && jsonQuery.getBoolean(c.columnName)).map(c -> c.columnName).collect(Collectors.joining(","));
        sb.append(StringExtension.IsNullOrEmpty(query) ? "*" : query);
        if (limit > 0) {
            if (this.DBType == DBTypeInfo.PostgreSQL) {
                sb.append(" ,count(1) OVER() AS ").append("__pg_total_count");
                sb.append(" ,").append(limit).append(" AS ").append("__pg_limit");
                sb.append(" ,").append(offset).append(" AS ").append("__pg_offset");
            }
            if (this.DBType == DBTypeInfo.MySql) {
                sb.append(" ,FOUND_ROWS() AS ").append("__pg_total_count");
                sb.append(" ,").append(limit).append(" AS ").append("__pg_limit");
                sb.append(" ,").append(offset).append(" AS ").append("__pg_offset");
            }
        }
        sb.append(" FROM ");
        sb.append(tableName);
        if (jsonQuery.has($WHERE) && !StringExtension.IsNullOrEmpty(where = this.buildWhereTSQL(columnList, jsonQuery.getJSONObject($WHERE)))) {
            sb.append(" WHERE ");
            sb.append(where);
        }
        if (jsonQuery.has($SORT)) {
            sb.append(this.buildSortTSQL(columnList, jsonQuery.getJSONObject($SORT)));
        }
        if (limit > 0) {
            if (this.DBType == DBTypeInfo.PostgreSQL) {
                sb.append(" LIMIT ").append(limit);
                sb.append(" OFFSET ").append(offset);
            }
            if (this.DBType == DBTypeInfo.MySql) {
                sb.append(" LIMIT ");
                sb.append(offset).append(",");
                sb.append(limit);
            }
        }
        return sb.toString();
    }

    private List<String> getInputColumnName(String name) {
        int subQueryIndex = name.indexOf(".");
        if (subQueryIndex > 0) {
            Arrays.asList(name.substring(0, subQueryIndex), name.substring(subQueryIndex + 1));
        }
        return Arrays.asList(name, "");
    }

    private JSONObject getQueryJSON(NameValuePair ... params) {
        JSONObject jsonQuery = new JSONObject();
        for (NameValuePair item : params) {
            jsonQuery.put(item.id, item.value);
        }
        return jsonQuery;
    }
}

