/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.DBHelper;

import LinkFuture.Core.DBHelper.DBHelper;
import LinkFuture.Core.DBHelper.Model.ColumnInfo;
import LinkFuture.Core.DBHelper.Model.CommandTypeInfo;
import LinkFuture.Core.DBHelper.Model.DBTypeInfo;
import LinkFuture.Core.DBHelper.Model.TableInfo;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.NameValuePair;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import org.json.JSONArray;
import org.json.JSONObject;

public class GenericDBHelper
extends DBHelper {
    List<String> whereList = new ArrayList<String>();
    List<String> insertList = new ArrayList<String>();
    List<String> columnList = new ArrayList<String>();
    List<String> whereKeyList = new ArrayList<String>();
    List<String> updateList = new ArrayList<String>();

    public GenericDBHelper(String connectionString) throws IOException, SQLException, ClassNotFoundException, NamingException {
        super(connectionString);
    }

    private void buildCondition(TableInfo table, JSONObject jsonQuery) {
        this.whereList.clear();
        this.columnList.clear();
        this.insertList.clear();
        this.whereKeyList.clear();
        this.updateList.clear();
        for (ColumnInfo column : table.columnList) {
            Iterator keys = jsonQuery.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (key.startsWith("$")) continue;
                String inputColumnName = key;
                int subQueryIndex = key.indexOf(".");
                String subQuery = null;
                if (column.sqlType == 2002 && subQueryIndex > 0) {
                    inputColumnName = key.substring(0, subQueryIndex);
                    subQuery = key.substring(subQueryIndex + 1);
                }
                if (!column.columnName.equalsIgnoreCase(inputColumnName)) continue;
                this.columnList.add(column.columnName);
                this.insertList.add(this.buildColumnValue(column));
                if (StringExtension.IsNullOrEmpty(subQuery)) {
                    this.updateList.add(String.format("%s=%s", column.columnName, this.buildColumnValue(column)));
                } else {
                    this.updateList.add(String.format("%s.%s= $%s|%s", column.columnName, subQuery, column.columnName, 12));
                }
                super.addParameter(column.columnName, jsonQuery.get(key));
            }
        }
    }

    private void buildCondition(TableInfo table, NameValuePair ... params) throws IllegalAccessException {
        this.whereList.clear();
        this.columnList.clear();
        this.insertList.clear();
        this.whereKeyList.clear();
        this.updateList.clear();
        block0: for (ColumnInfo column : table.columnList) {
            for (NameValuePair param : params) {
                String inputColumnName = param.id;
                int subQueryIndex = param.id.indexOf(".");
                String subQuery = null;
                if (column.sqlType == 2002 && subQueryIndex > 0) {
                    inputColumnName = param.id.substring(0, subQueryIndex);
                    subQuery = param.id.substring(subQueryIndex + 1);
                }
                if (!column.columnName.equalsIgnoreCase(inputColumnName)) continue;
                this.columnList.add(column.columnName);
                this.whereList.add(this.buildWhere(column, subQuery));
                this.insertList.add(this.buildColumnValue(column));
                if (column.isKey) {
                    this.whereKeyList.add(this.buildWhere(column, subQuery));
                } else if (StringExtension.IsNullOrEmpty(subQuery)) {
                    this.updateList.add(String.format("%s=%s", column.columnName, this.buildColumnValue(column)));
                } else {
                    this.updateList.add(String.format("%s.%s= $%s|%s", column.columnName, subQuery, column.columnName, 12));
                }
                super.addParameter(column.columnName, param.value);
                continue block0;
            }
        }
    }

    private String buildWhere(ColumnInfo column, String subQuery) throws IllegalAccessException {
        if (column.sqlType == 2003) {
            return String.format("$%s|%s::%s = ANY (%s)", column.columnName, column.getArrayElementType(), column.getArrayElementTypeName(), column.columnName);
        }
        if (column.isSqlJsonType()) {
            return String.format("%s @> $%s|%s::%s", column.columnName, column.columnName, column.sqlType, column.sqlTypeName);
        }
        if (column.sqlType == 2002) {
            if (StringExtension.IsNullOrEmpty(subQuery)) {
                return String.format("%s = $%s|%s::%s", column.columnName, column.columnName, column.sqlType, column.sqlTypeName);
            }
            return String.format("(%s).%s = $%s|%s", column.columnName, subQuery, column.columnName, 12);
        }
        return String.format("%s = $%s|%s", column.columnName, column.columnName, column.sqlType);
    }

    private String buildColumnValue(ColumnInfo column) {
        if (column.sqlType == 2002) {
            return String.format("$%s|%s::%s", column.columnName, column.sqlType, column.sqlTypeName);
        }
        if (column.sqlType == 2003) {
            return String.format("$%s|%s::%s[]", column.columnName, column.sqlType, column.getArrayElementTypeName());
        }
        return String.format("$%s|%s", column.columnName, column.sqlType);
    }

    public int update(String tableName, JSONObject jsonQuery) throws Exception {
        TableInfo table = this.init(tableName);
        this.buildCondition(table, jsonQuery);
        if (!jsonQuery.has("$where")) {
            throw new IllegalArgumentException("Please specific parameter or none of input parameter is valid for " + tableName);
        }
        String where = this.buildWhere(super.getTableColumnList(tableName), jsonQuery.getJSONObject("$where"));
        if (this.updateList.size() > 0 && !StringExtension.IsNullOrEmpty(where)) {
            StringBuilder sb = new StringBuilder();
            sb.append("UPDATE ");
            sb.append(tableName);
            sb.append(" SET ");
            sb.append(StringExtension.Join(this.updateList, ","));
            sb.append(" WHERE ");
            sb.append(where);
            return super.executeSQL(sb.toString());
        }
        throw new IllegalArgumentException("Please specific parameter or none of input parameter is valid for " + tableName);
    }

    public int update(String tableName, Collection<NameValuePair> params) throws Exception {
        return this.update(tableName, params.toArray(new NameValuePair[params.size()]));
    }

    public int update(String tableName, NameValuePair ... params) throws Exception {
        TableInfo table = this.init(tableName);
        this.buildCondition(table, params);
        if (this.updateList.size() > 0 && this.whereKeyList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("UPDATE ");
            sb.append(tableName);
            sb.append(" SET ");
            sb.append(StringExtension.Join(this.updateList, ","));
            sb.append(" WHERE ");
            sb.append(StringExtension.Join(this.whereKeyList, " and "));
            return super.executeSQL(sb.toString());
        }
        throw new IllegalArgumentException("Please specific parameter or none of input parameter is valid for " + tableName);
    }

    public int delete(String tableName, Collection<NameValuePair> params) throws Exception {
        return this.delete(tableName, params.toArray(new NameValuePair[params.size()]));
    }

    public int delete(String tableName, NameValuePair ... params) throws Exception {
        TableInfo table = this.init(tableName);
        this.buildCondition(table, params);
        if (this.whereList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("DELETE FROM ");
            sb.append(tableName);
            sb.append(" WHERE ");
            sb.append(StringExtension.Join(this.whereList, " and "));
            return super.executeSQL(sb.toString());
        }
        throw new IllegalArgumentException("Please specific parameter or none of input parameter is valid for " + tableName);
    }

    public int delete(String tableName, JSONObject jsonQuery) throws Exception {
        HashMap<String, ColumnInfo> columnList = super.getTableColumnList(tableName);
        String where = this.buildWhere(columnList, jsonQuery);
        if (StringExtension.IsNullOrEmpty(where)) {
            throw new IllegalArgumentException("Please specific parameter or none of input parameter is valid for " + tableName);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(tableName);
        sb.append(" WHERE ");
        sb.append(where);
        return super.executeSQL(sb.toString());
    }

    private String buildSelectQuery(String tableName, JSONObject jsonQuery) throws Exception {
        HashMap<String, ColumnInfo> columnList = super.getTableColumnList(tableName);
        ArrayList<String> queryColumnList = new ArrayList<String>();
        Iterator keys = jsonQuery.keys();
        String myWhere = null;
        Integer limit = 10;
        Integer offset = 0;
        while (keys.hasNext()) {
            boolean included;
            String key = (String)keys.next();
            if (!key.startsWith("$") && (included = jsonQuery.get(key).toString().equalsIgnoreCase("true")) && columnList.containsKey(key)) {
                queryColumnList.add(key);
            }
            if (key.equalsIgnoreCase("$where")) {
                myWhere = this.buildWhere(columnList, (JSONObject)jsonQuery.get(key));
            }
            if (key.equalsIgnoreCase("$limit")) {
                limit = (int)((Integer)jsonQuery.get(key));
            }
            if (!key.equalsIgnoreCase("$offset")) continue;
            offset = (int)((Integer)jsonQuery.get(key));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        if (queryColumnList.size() == 0) {
            sb.append(" * ");
        } else {
            sb.append(StringExtension.Join(queryColumnList, ","));
        }
        if (limit > 0) {
            if (this.DBType == DBTypeInfo.PostgreSQL) {
                sb.append(" ,count(1) OVER() AS ").append("__pg_total_count");
                sb.append(" ,").append(limit).append(" AS ").append("__pg_limit");
                sb.append(" ,").append(offset).append(" AS ").append("__pg_offset");
            }
            if (this.DBType == DBTypeInfo.MySql) {
                sb.append(" ,FOUND_ROWS AS ").append("__pg_total_count");
                sb.append(" ,").append(limit).append(" AS ").append("__pg_limit");
                sb.append(" ,").append(offset).append(" AS ").append("__pg_offset");
            }
        }
        sb.append(" FROM ");
        sb.append(tableName);
        if (!StringExtension.IsNullOrEmpty(myWhere)) {
            sb.append(" WHERE ");
            sb.append(myWhere);
        }
        if (limit > 0) {
            if (this.DBType == DBTypeInfo.PostgreSQL) {
                sb.append(" LIMIT ").append(limit);
                sb.append(" OFFSET ").append(offset);
            }
            if (this.DBType == DBTypeInfo.MySql) {
                sb.append(" LIMIT ");
                sb.append(offset).append(",");
                sb.append(limit);
            }
        }
        return sb.toString();
    }

    private String buildWhere(HashMap<String, ColumnInfo> columnList, JSONObject jsonWhere) throws IllegalAccessException {
        Iterator keys = jsonWhere.keys();
        ArrayList<String> localAndList = new ArrayList<String>();
        ArrayList<String> localOrList = new ArrayList<String>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object jsonValue = jsonWhere.get(key);
            String inputColumnName = key;
            String subQuery = null;
            int subQueryIndex = inputColumnName.indexOf(".");
            if (subQueryIndex > 0) {
                inputColumnName = key.substring(0, subQueryIndex);
                subQuery = key.substring(subQueryIndex + 1);
            }
            if (!key.startsWith("$") && columnList.containsKey(inputColumnName)) {
                ColumnInfo column = columnList.get(inputColumnName);
                if (jsonValue instanceof JSONObject) {
                    JSONObject compare = (JSONObject)jsonValue;
                    String operationString = compare.keySet().iterator().next().toString().toLowerCase();
                    Object operationValue = compare.get(operationString);
                    switch (operationString) {
                        case "$gt": {
                            if (!comparableTypes.contains(column.sqlType)) {
                                throw new IllegalArgumentException("Specific type does not support $gt operation");
                            }
                            localAndList.add(String.format("%s > $%s|%s", column.columnName, column.columnName, column.sqlType));
                            super.addParameter(column.columnName, operationValue);
                            break;
                        }
                        case "$gte": {
                            if (!comparableTypes.contains(column.sqlType)) {
                                throw new IllegalArgumentException("Specific type does not support $gte operation");
                            }
                            localAndList.add(String.format("%s >= $%s|%s", column.columnName, column.columnName, column.sqlType));
                            super.addParameter(column.columnName, operationValue);
                            break;
                        }
                        case "$lt": {
                            if (!comparableTypes.contains(column.sqlType)) {
                                throw new IllegalArgumentException("Specific type does not support $lt operation");
                            }
                            localAndList.add(String.format("%s < $%s|%s", column.columnName, column.columnName, column.sqlType));
                            super.addParameter(column.columnName, operationValue);
                            break;
                        }
                        case "$lte": {
                            if (!comparableTypes.contains(column.sqlType)) {
                                throw new IllegalArgumentException("Specific type does not support $lte operation");
                            }
                            localAndList.add(String.format("%s <= $%s|%s", column.columnName, column.columnName, column.sqlType));
                            super.addParameter(column.columnName, operationValue);
                            break;
                        }
                        case "$in": {
                            JSONArray inList = (JSONArray)operationValue;
                            ArrayList<String> inString = new ArrayList<String>();
                            for (int i = 0; i < inList.length(); ++i) {
                                inString.add("'" + inList.get(i).toString() + "'");
                            }
                            localAndList.add(String.format("%s in (%s)", column.columnName, StringExtension.Join(inString, ",")));
                        }
                    }
                } else {
                    localAndList.add(this.buildWhere(column, subQuery));
                    super.addParameter(column.columnName, jsonValue);
                }
            }
            if (!key.equalsIgnoreCase("$or")) continue;
            JSONArray orArray = (JSONArray)jsonValue;
            for (int i = 0; i < orArray.length(); ++i) {
                localOrList.add(this.buildWhere(columnList, (JSONObject)orArray.get(i)));
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(StringExtension.Join(localAndList, " AND "));
        String orQuery = StringExtension.Join(localOrList, " OR ");
        if (localAndList.size() > 0 && orQuery.length() > 0) {
            sb.append(" OR ");
        }
        sb.append(orQuery);
        sb.append(")");
        String output = sb.toString();
        return output.length() == 2 ? "" : sb.toString();
    }

    private String buildSelectQuery(String tableName, List<String> queryColumnList, NameValuePair ... params) throws Exception {
        TableInfo table = super.findTableInfo(tableName);
        this.buildCondition(table, params);
        Integer limit = 10;
        Integer offset = 0;
        for (NameValuePair item : params) {
            if (item.id.equalsIgnoreCase("limit")) {
                limit = Integer.parseInt(item.value.toString());
                continue;
            }
            if (!item.id.equalsIgnoreCase("offset")) continue;
            offset = Integer.parseInt(item.value.toString());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        if (queryColumnList == null || queryColumnList.size() == 0) {
            sb.append(" * ");
        } else {
            ArrayList<String> filterColumnList = new ArrayList<String>();
            block1: for (ColumnInfo column : table.columnList) {
                for (String queryField : queryColumnList) {
                    if (!column.columnName.equalsIgnoreCase(queryField)) continue;
                    filterColumnList.add(column.columnName);
                    continue block1;
                }
            }
            if (filterColumnList.size() > 0) {
                sb.append(StringExtension.Join(filterColumnList, ","));
            } else {
                sb.append(" * ");
            }
        }
        if (limit > 0) {
            if (this.DBType == DBTypeInfo.PostgreSQL) {
                sb.append(" ,count(1) OVER() AS ").append("__pg_total_count");
                sb.append(" ,").append(limit).append(" AS ").append("__pg_limit");
                sb.append(" ,").append(offset).append(" AS ").append("__pg_offset");
            }
            if (this.DBType == DBTypeInfo.MySql) {
                sb.append(" ,FOUND_ROWS AS ").append("__pg_total_count");
                sb.append(" ,").append(limit).append(" AS ").append("__pg_limit");
                sb.append(" ,").append(offset).append(" AS ").append("__pg_offset");
            }
        }
        sb.append(" FROM ");
        sb.append(tableName);
        if (this.whereList.size() > 0) {
            sb.append(" WHERE ");
            sb.append(StringExtension.Join(this.whereList, " and "));
        }
        if (limit > 0) {
            if (this.DBType == DBTypeInfo.PostgreSQL) {
                sb.append(" LIMIT ").append(limit);
                sb.append(" OFFSET ").append(offset);
            }
            if (this.DBType == DBTypeInfo.MySql) {
                sb.append(" LIMIT ");
                sb.append(offset).append(",");
                sb.append(limit);
            }
        }
        return sb.toString();
    }

    public String selectToXml(String tableName, List<String> queryColumnList, Collection<NameValuePair> params) throws Exception {
        return this.selectToXml(tableName, queryColumnList, params.toArray(new NameValuePair[params.size()]));
    }

    public String selectToXml(String tableName, List<String> queryColumnList, NameValuePair ... params) throws Exception {
        return super.executeToXml(this.buildSelectQuery(tableName, queryColumnList, params), CommandTypeInfo.TSQL);
    }

    public String selectToXml(String tableName, JSONObject jsonQuery) throws Exception {
        return super.executeToXml(this.buildSelectQuery(tableName, jsonQuery), CommandTypeInfo.TSQL);
    }

    public String selectToJson(String tableName, List<String> queryColumnList, Collection<NameValuePair> params) throws Exception {
        return this.selectToJson(tableName, queryColumnList, params.toArray(new NameValuePair[params.size()]));
    }

    public String selectToJson(String tableName, List<String> queryColumnList, NameValuePair ... params) throws Exception {
        JSONObject output = super.executeToJson(this.buildSelectQuery(tableName, queryColumnList, params), CommandTypeInfo.TSQL);
        return StringExtension.IfNULLOrEmpty(output);
    }

    public String selectToJson(String tableName, JSONObject jsonQuery) throws Exception {
        JSONObject output = super.executeToJson(this.buildSelectQuery(tableName, jsonQuery), CommandTypeInfo.TSQL);
        return StringExtension.IfNULLOrEmpty(output);
    }

    public Object insert(String tableName, Collection<NameValuePair> params) throws Exception {
        return this.insert(tableName, params.toArray(new NameValuePair[params.size()]));
    }

    public Object insert(String tableName, NameValuePair ... params) throws Exception {
        TableInfo table = this.init(tableName);
        this.buildCondition(table, params);
        if (this.whereList.size() > 0 && this.insertList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO ");
            sb.append(tableName);
            sb.append("(");
            sb.append(StringExtension.Join(this.columnList, ","));
            sb.append(") VALUES(");
            sb.append(StringExtension.Join(this.insertList, ","));
            sb.append(");");
            return super.insert(sb.toString());
        }
        throw new IllegalArgumentException("Please specific parameter or none of input parameter is valid for " + tableName);
    }

    private TableInfo init(String tableName) throws Exception {
        this.inputParameterList.clear();
        TableInfo table = super.findTableInfo(tableName);
        if (table == null || table.columnList.size() == 0) {
            new IllegalAccessException("Specific table doesn't exist:" + tableName);
        }
        return table;
    }
}

