/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.DBHelper;

import LinkFuture.Core.DBHelper.DBHelper;
import LinkFuture.Core.DBHelper.DBReader;
import LinkFuture.Core.DBHelper.Model.ColumnInfo;
import LinkFuture.Core.DBHelper.Model.DBTypeInfo;
import LinkFuture.Core.DBHelper.Model.SPInfo;
import LinkFuture.Core.DBHelper.Model.SPParameterInfo;
import LinkFuture.Core.DBHelper.Model.TableInfo;
import LinkFuture.Core.JsonManager.JsonController;
import LinkFuture.Core.Utility;
import LinkFuture.Init.Extensions.StringExtension;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.json.JSONArray;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DBXmlReader
extends DBReader {
    public DBXmlReader(Statement statement, SPInfo spMetaInfo) {
        super(statement, spMetaInfo);
    }

    public String Read() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element result = doc.createElement("data");
        doc.appendChild(result);
        this.buildXml(doc, result);
        if (this.statement instanceof CallableStatement) {
            Map<String, Object> outputParameterList = DBHelper.ReadOutputParameterList(this.spMetaInfo, (CallableStatement)this.statement, this.DBType);
            for (String key : outputParameterList.keySet()) {
                Object output = outputParameterList.get(key);
                if (output instanceof ResultSet) continue;
                result.setAttribute(StringExtension.XmlNodeNameEscape(key), outputParameterList.get(key).toString());
            }
        }
        return Utility.xmlNodeToString(doc);
    }

    private void buildXml(Document doc, Element result) throws Exception {
        if (this.DBType == DBTypeInfo.PostgreSQL && this.statement instanceof CallableStatement) {
            Connection conn = this.statement.getConnection();
            for (SPParameterInfo param : this.spMetaInfo.parameterList) {
                if (param.sqlTypes != 1111) continue;
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(String.format("FETCH ALL IN \"%s\"", param.parameterName));
                while (rs.next()) {
                    result.appendChild(this.read(rs, doc));
                }
            }
        } else {
            boolean hadResults = true;
            while (hadResults) {
                ResultSet rs = this.statement.getResultSet();
                result.appendChild(this.read(rs, doc));
                hadResults = this.statement.getMoreResults();
            }
        }
    }

    private Element read(ResultSet rs, Document doc) throws Exception {
        ResultSetMetaData metaData = rs.getMetaData();
        TableInfo resultMetaInfo = DBHelper.findResultsColumnInfo(metaData);
        Element table = doc.createElement("table");
        while (rs.next()) {
            Element row = doc.createElement("row");
            ArrayList<Element> columnList = this.fillObject(rs, resultMetaInfo, doc);
            for (Element node : columnList) {
                if (node.getTagName().equalsIgnoreCase("__pg_limit")) {
                    table.setAttribute("limit", node.getFirstChild().getNodeValue());
                    continue;
                }
                if (node.getTagName().equalsIgnoreCase("__pg_total_count")) {
                    table.setAttribute("total_count", node.getFirstChild().getNodeValue());
                    continue;
                }
                if (node.getTagName().equalsIgnoreCase("__pg_offset")) {
                    table.setAttribute("offset", node.getFirstChild().getNodeValue());
                    continue;
                }
                row.appendChild(node);
            }
            table.appendChild(row);
        }
        return table;
    }

    private ArrayList<Element> fillObject(ResultSet rs, TableInfo resultMetaInfo, Document doc) throws Exception {
        ArrayList<Element> list = new ArrayList<Element>();
        for (int i = 1; i <= resultMetaInfo.columnList.size(); ++i) {
            Element newNode;
            ColumnInfo column = resultMetaInfo.columnList.get(i - 1);
            Object itemValue = rs.getObject(i);
            if (itemValue == null) continue;
            String xmlNodeName = StringExtension.XmlNodeNameEscape(column.columnName);
            if (column.isSqlJsonType()) {
                itemValue = "{\"" + xmlNodeName + "\":" + itemValue + "}";
                newNode = (Element)doc.importNode(this.getXmlNode(itemValue.toString()), true);
            } else if (column.sqlType == 2003) {
                String arrayString = itemValue.toString();
                arrayString = "{\"" + xmlNodeName + "\":{\"item\":" + new JSONArray("[" + arrayString.substring(1, arrayString.length() - 1) + "]") + "}}";
                newNode = (Element)doc.importNode(this.getXmlNode(arrayString), true);
            } else if (column.sqlType == 2002) {
                String structString = itemValue.toString();
                structString = "{\"" + xmlNodeName + "\":" + JsonController.sqlStructToJSON(structString, DBHelper.findTypeInfo(this.statement.getConnection(), column.sqlTypeName)).toString() + "}";
                newNode = (Element)doc.importNode(this.getXmlNode(structString), true);
            } else {
                newNode = doc.createElement(xmlNodeName);
                newNode.appendChild(doc.createTextNode(itemValue.toString()));
            }
            list.add(newNode);
        }
        return list;
    }

    private Element getXmlNode(String jsonString) throws IOException, ParserConfigurationException, SAXException {
        String xmlString = JsonController.convertJsonToXml(jsonString);
        Document xmlDoc = Utility.parseXmlDom(xmlString);
        return xmlDoc.getDocumentElement();
    }
}

