/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.DBHelper;

import LinkFuture.Core.DBHelper.DBHelper;
import LinkFuture.Core.DBHelper.DBReader;
import LinkFuture.Core.DBHelper.Model.ColumnInfo;
import LinkFuture.Core.DBHelper.Model.DBTypeInfo;
import LinkFuture.Core.DBHelper.Model.SPInfo;
import LinkFuture.Core.DBHelper.Model.SPParameterInfo;
import LinkFuture.Core.DBHelper.Model.TableInfo;
import LinkFuture.Core.JsonManager.JsonController;
import LinkFuture.Init.Extensions.DateExtension;
import LinkFuture.Init.Extensions.StringExtension;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class DBJsonReader
extends DBReader {
    public DBJsonReader(Statement statement, SPInfo spMetaInfo) {
        super(statement, spMetaInfo);
    }

    public JSONObject Read() throws Exception {
        JSONObject root = new JSONObject();
        if (this.DBType == DBTypeInfo.PostgreSQL && this.statement instanceof CallableStatement) {
            Connection conn = this.statement.getConnection();
            for (SPParameterInfo param : this.spMetaInfo.parameterList) {
                Statement stmt;
                ResultSet rs;
                JSONObject table;
                if (!param.isRefcursor() || (table = this.read(rs = (stmt = conn.createStatement()).executeQuery(String.format("FETCH ALL IN \"%s\"", param.parameterName)))).length() <= 0) continue;
                root.append("data", table.get("data"));
                if (!table.has("page")) continue;
                root.append("page", table.get("page"));
            }
        } else {
            boolean hadResults = true;
            while (hadResults) {
                ResultSet rs = this.statement.getResultSet();
                if (rs != null) {
                    JSONObject table = this.read(rs);
                    if (table.length() > 0) {
                        root.append("data", table.get("data"));
                        if (table.has("page")) {
                            root.append("page", table.get("page"));
                        }
                    }
                    hadResults = this.statement.getMoreResults();
                    continue;
                }
                hadResults = false;
            }
        }
        if (this.statement instanceof CallableStatement) {
            Map<String, Object> outputList = DBHelper.ReadOutputParameterList(this.spMetaInfo, (CallableStatement)this.statement, this.DBType);
            JSONObject outputParameter = new JSONObject();
            for (String key : outputList.keySet()) {
                Object output = outputList.get(key);
                if (output instanceof ResultSet) {
                    ResultSet rs = (ResultSet)output;
                    JSONObject table = this.read(rs);
                    if (table.length() <= 0) continue;
                    root.append("data", table.get("data"));
                    if (!table.has("page")) continue;
                    root.append("page", table.get("page"));
                    continue;
                }
                outputParameter.put(key, output);
            }
            if (outputParameter.length() > 0) {
                root.put("params", (Object)outputParameter);
            }
        }
        return root.length() > 0 ? root : null;
    }

    private JSONObject read(ResultSet rs) throws Exception {
        ResultSetMetaData metaData = rs.getMetaData();
        TableInfo resultMetaInfo = DBHelper.findResultsColumnInfo(metaData);
        JSONArray dataArray = new JSONArray();
        JSONObject pagerObj = new JSONObject();
        while (rs.next()) {
            JSONObject item = new JSONObject();
            for (int i = 1; i <= resultMetaInfo.columnList.size(); ++i) {
                Object itemValue = rs.getObject(i);
                if (itemValue == null) continue;
                ColumnInfo column = resultMetaInfo.columnList.get(i - 1);
                if (column.columnName.equalsIgnoreCase("__pg_limit")) {
                    pagerObj.put("limit", itemValue);
                    continue;
                }
                if (column.columnName.equalsIgnoreCase("__pg_total_count")) {
                    pagerObj.put("total_count", itemValue);
                    continue;
                }
                if (column.columnName.equalsIgnoreCase("__pg_offset")) {
                    pagerObj.put("offset", itemValue);
                    continue;
                }
                if (column.isSqlJsonType()) {
                    String jsonString = itemValue.toString().trim();
                    if (jsonString.startsWith("[") && jsonString.endsWith("]")) {
                        item.put(column.columnName, (Object)new JSONArray(jsonString));
                        continue;
                    }
                    item.put(column.columnName, (Object)new JSONObject(jsonString));
                    continue;
                }
                if (column.sqlType == 2003) {
                    Array sqlArray = (Array)itemValue;
                    String arrayString = itemValue.toString();
                    arrayString = "[" + arrayString.substring(1, arrayString.length() - 1) + "]";
                    JSONArray arrayJson = new JSONArray(arrayString);
                    if (sqlArray.getBaseType() == 2002) {
                        JSONArray structJson = new JSONArray();
                        TableInfo typeInfo = DBHelper.findTypeInfo(this.statement.getConnection(), StringExtension.TrimStart(column.sqlTypeName, "_"));
                        for (int j = 0; j < arrayJson.length(); ++j) {
                            String structString = arrayJson.getString(j);
                            structString = structString.substring(1, structString.length() - 1);
                            String[] list = structString.split(",");
                            JSONObject struct = new JSONObject();
                            for (int x = 0; x < typeInfo.columnList.size(); ++x) {
                                struct.put(typeInfo.columnList.get((int)x).columnName, (Object)list[x]);
                            }
                            structJson.put((Object)struct);
                        }
                        item.put(column.columnName, (Object)structJson);
                        continue;
                    }
                    item.put(column.columnName, (Object)arrayJson);
                    continue;
                }
                if (column.sqlType == 2002) {
                    item.put(column.columnName, (Object)JsonController.sqlStructToJSON(itemValue.toString(), DBHelper.findTypeInfo(this.statement.getConnection(), column.sqlTypeName)));
                    continue;
                }
                if (column.isSqlTimeStampType() && itemValue instanceof Timestamp) {
                    item.put(column.columnName, (Object)DateExtension.UTFFormat(DateExtension.Convert((Timestamp)itemValue)));
                    continue;
                }
                item.put(column.columnName, itemValue);
            }
            dataArray.put((Object)item);
        }
        JSONObject output = new JSONObject();
        if (dataArray.length() > 0) {
            output.put("data", (Object)dataArray);
        }
        if (pagerObj.length() > 0) {
            output.put("page", (Object)pagerObj);
        }
        return output;
    }
}

