/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.DBHelper;

import LinkFuture.Core.DBHelper.DBBeanReader;
import LinkFuture.Core.DBHelper.DBJsonReader;
import LinkFuture.Core.DBHelper.DBXmlReader;
import LinkFuture.Core.DBHelper.Model.ColumnInfo;
import LinkFuture.Core.DBHelper.Model.CommandTypeInfo;
import LinkFuture.Core.DBHelper.Model.DBColumnAttribute;
import LinkFuture.Core.DBHelper.Model.DBConnectionInfo;
import LinkFuture.Core.DBHelper.Model.DBTypeInfo;
import LinkFuture.Core.DBHelper.Model.FieldInfo;
import LinkFuture.Core.DBHelper.Model.IgnoreDBColumnAttribute;
import LinkFuture.Core.DBHelper.Model.ParameterTypeInfo;
import LinkFuture.Core.DBHelper.Model.SPInfo;
import LinkFuture.Core.DBHelper.Model.SPParameterInfo;
import LinkFuture.Core.DBHelper.Model.TableInfo;
import LinkFuture.Core.JsonManager.JsonController;
import LinkFuture.Core.MemoryManager.StaticMemoryCache.StaticMemoryCacheHelper;
import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Core.Utility;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.DateExtension;
import LinkFuture.Init.Extensions.StringExtension;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.json.JSONArray;
import org.json.JSONObject;

public class DBHelper
implements AutoCloseable {
    public static final List<Integer> comparableTypes = Arrays.asList(-5, 4, 5, -6, 3, 6, 8, 2, 7, 92, 93, 91);
    public static final List<Integer> likeableTypes = Arrays.asList(12, -9);
    private Connection conn;
    private static final Map<String, SPInfo> CachedSPMeta = new ConcurrentHashMap<String, SPInfo>();
    private static final Map<String, TableInfo> CachedTableMeta = new ConcurrentHashMap<String, TableInfo>();
    private static final Map<String, ConcurrentHashMap<String, TableInfo>> CachedAllTableMeta = new ConcurrentHashMap<String, ConcurrentHashMap<String, TableInfo>>();
    public Map<String, SPParameterInfo> inputParameterList = new LinkedHashMap<String, SPParameterInfo>();
    public String dbUrl;
    public SPInfo SPMetaInfo = null;
    public Statement statement;
    private boolean autoClose = true;
    public DBTypeInfo DBType = null;

    public static Connection getConnection(String connectionString) throws SQLException, NamingException, ClassNotFoundException {
        if (StringExtension.IsNullOrEmpty(connectionString)) {
            throw new IllegalArgumentException("Please specific connection string");
        }
        Debugger.LogFactory.trace("Connect to {} ", (Object)connectionString);
        if (connectionString.startsWith("java:/")) {
            InitialContext cxt = new InitialContext();
            DataSource ds = (DataSource)cxt.lookup(connectionString);
            return ds.getConnection();
        }
        return DriverManager.getConnection(connectionString);
    }

    public Connection getCurrentConnection() {
        return this.conn;
    }

    public DBHelper(Connection conn) throws SQLException, ClassNotFoundException {
        this.autoClose = false;
        this.init(conn);
    }

    public DBHelper(String connectionString) throws IOException, SQLException, ClassNotFoundException, NamingException {
        this.init(DBHelper.getConnection(connectionString));
    }

    private void init(Connection conn) throws SQLException {
        this.conn = conn;
        this.dbUrl = DBConnectionInfo.Parser((String)conn.getMetaData().getURL()).Url;
        this.DBType = Utility.enumParser(DBTypeInfo.class, this.conn.getMetaData().getDatabaseProductName());
    }

    public void addParameter(String name, Object value) {
        this.addParameter(name, value, null);
    }

    public void addOutParameter(String name) {
        this.addParameter(name, null, ParameterTypeInfo.procedureColumnOut);
    }

    private void addParameter(String name, Object value, ParameterTypeInfo type) {
        if (type == null) {
            type = ParameterTypeInfo.procedureColumnIn;
        }
        SPParameterInfo parameter = new SPParameterInfo();
        parameter.parameterName = name;
        parameter.parameterValue = value;
        parameter.parameterType = type;
        this.inputParameterList.put(DBHelper.buildParamKey(name), parameter);
    }

    public ArrayList<ArrayList<?>> executeSP(String commandText, Class<?> ... outputType) throws Exception {
        this.setCommand(commandText, CommandTypeInfo.StoredProcedure);
        boolean hadResults = this.Execute(CommandTypeInfo.StoredProcedure);
        if (hadResults) {
            return new DBBeanReader(this.statement, this.SPMetaInfo).Read(outputType);
        }
        return null;
    }

    public <T> ArrayList<T> executeSP(String commandText, Class<T> outputType) throws Exception {
        ArrayList<ArrayList<?>> results;
        this.setCommand(commandText, CommandTypeInfo.StoredProcedure);
        boolean hadResults = this.Execute(CommandTypeInfo.StoredProcedure);
        if (hadResults && (results = new DBBeanReader(this.statement, this.SPMetaInfo).Read(outputType)).size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public String executeToXml(String commandText, CommandTypeInfo commandType) throws Exception {
        this.setCommand(commandText, commandType);
        boolean hadResults = this.Execute(commandType);
        if (!hadResults) {
            return null;
        }
        return new DBXmlReader(this.statement, this.SPMetaInfo).Read();
    }

    public JSONObject executeToJson(String commandText, CommandTypeInfo commandType) throws Exception {
        this.setCommand(commandText, commandType);
        boolean hadResults = this.Execute(commandType);
        if (!hadResults) {
            return null;
        }
        return new DBJsonReader(this.statement, this.SPMetaInfo).Read();
    }

    public ArrayList<ArrayList<?>> executeSQL(String sql, Class<?> ... outputType) throws Exception {
        this.setCommand(sql, CommandTypeInfo.TSQL);
        boolean hadResults = this.Execute(CommandTypeInfo.TSQL);
        if (hadResults) {
            return new DBBeanReader(this.statement, this.SPMetaInfo).Read(outputType);
        }
        return null;
    }

    public <T> ArrayList<T> executeSQL(String sql, Class<T> outputType) throws Exception {
        ArrayList<ArrayList<?>> results;
        this.setCommand(sql, CommandTypeInfo.TSQL);
        boolean hadResults = this.Execute(CommandTypeInfo.TSQL);
        if (hadResults && (results = new DBBeanReader(this.statement, this.SPMetaInfo).Read(outputType)).size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public int executeSQL(String sql) throws Exception {
        this.setCommand(sql, CommandTypeInfo.TSQL);
        return this.TSQLExecuteUpdate();
    }

    public List<Object> insert(String commandText) throws Exception {
        this.setCommand(commandText, CommandTypeInfo.TSQL);
        return this.TSQLExecuteInsert();
    }

    @Override
    public void close() {
        try {
            if (this.statement != null && !this.statement.isClosed()) {
                this.statement.close();
                this.statement = null;
            }
            if (this.autoClose && this.conn != null && !this.conn.isClosed()) {
                if (this.DBType == DBTypeInfo.PostgreSQL) {
                    this.conn.setAutoCommit(true);
                }
                this.conn.close();
            }
        }
        catch (SQLException e) {
            Debugger.LogFactory.error("Close DB error", (Throwable)e);
        }
    }

    private void setCommand(String commandText, CommandTypeInfo commandType) throws SQLException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Debugger.LogFactory.trace("setCommand:" + commandText);
        this.SPMetaInfo = commandType == CommandTypeInfo.StoredProcedure ? this.findSPInfo(commandText) : this.findTSQLInfo(commandText);
    }

    private boolean Execute(CommandTypeInfo commandType) throws Exception {
        switch (commandType) {
            case TSQL: {
                return this.TSQLExecute();
            }
        }
        return this.SPExecute();
    }

    private boolean SPExecute() throws Exception {
        CallableStatement callableStatement = this.conn.prepareCall(this.SPMetaInfo.sqlCall);
        this.statement = callableStatement;
        if (this.DBType == DBTypeInfo.PostgreSQL) {
            this.conn.setAutoCommit(false);
        }
        this.fillParameter(this.SPMetaInfo, callableStatement);
        Debugger.LogFactory.trace("SPExecute:{}", (Object)this.statement.toString());
        return callableStatement.execute();
    }

    private boolean TSQLExecute() throws Exception {
        PreparedStatement preparedStatement = this.SPMetaInfo.sqlCall.toUpperCase().indexOf("INSERT ") > 0 ? this.conn.prepareStatement(this.SPMetaInfo.sqlCall, 1) : this.conn.prepareStatement(this.SPMetaInfo.sqlCall);
        this.statement = preparedStatement;
        this.fillParameter(this.SPMetaInfo, preparedStatement);
        Debugger.LogFactory.trace("TSQLExecute:{}", (Object)this.statement.toString());
        return preparedStatement.execute();
    }

    private int TSQLExecuteUpdate() throws Exception {
        PreparedStatement preparedStatement = this.conn.prepareStatement(this.SPMetaInfo.sqlCall);
        this.statement = preparedStatement;
        this.fillParameter(this.SPMetaInfo, preparedStatement);
        Debugger.LogFactory.trace("TSQLExecuteUpdate:{}", (Object)this.statement.toString());
        return preparedStatement.executeUpdate();
    }

    private List<Object> TSQLExecuteInsert() throws Exception {
        PreparedStatement preparedStatement = this.conn.prepareStatement(this.SPMetaInfo.sqlCall, 1);
        this.statement = preparedStatement;
        this.fillParameter(this.SPMetaInfo, preparedStatement);
        Debugger.LogFactory.trace("TSQLExecuteInsert:{}", (Object)this.statement.toString());
        preparedStatement.executeUpdate();
        ResultSet rs = this.statement.getGeneratedKeys();
        ArrayList<Object> identityList = new ArrayList<Object>();
        while (rs.next()) {
            identityList.add(rs.getObject(1));
        }
        if (identityList.size() == 0) {
            return null;
        }
        return identityList;
    }

    private void fillParameter(SPInfo spMeta, PreparedStatement stmt) throws Exception {
        if (spMeta.parameterList.size() > 0) {
            boolean indexModel = spMeta.parameterList.get((int)0).parameterName.equalsIgnoreCase("?");
            int length = spMeta.parameterList.size();
            ArrayList<String> keys = new ArrayList<String>(this.inputParameterList.keySet());
            for (int i = 0; i < length; ++i) {
                SPParameterInfo passedParam;
                if (indexModel) {
                    String paramKey = (String)keys.get(i);
                    passedParam = this.inputParameterList.get(DBHelper.buildParamKey(paramKey));
                    stmt.setObject(i + 1, passedParam.parameterValue);
                    continue;
                }
                SPParameterInfo param = spMeta.parameterList.get(i);
                passedParam = this.inputParameterList.get(DBHelper.buildParamKey(param.parameterName));
                if (passedParam == null) {
                    throw new IllegalArgumentException("Missing value for param:" + param.parameterName);
                }
                this.setObject(stmt, i + 1, passedParam.parameterValue, param);
            }
        }
    }

    public Object toSQLArray(SPParameterInfo param, Object value) throws Exception {
        String item = value.toString();
        String elementType = StringExtension.TrimEnd(param.sqlTypeName, "[]");
        TableInfo typeInfo = this.findTypeInfo(elementType);
        if (!item.startsWith("{") && item.startsWith("[")) {
            JSONArray array = new JSONArray(item);
            Object[] list = new Object[array.length()];
            if (typeInfo.columnList.size() > 0) {
                for (int i = 0; i < array.length(); ++i) {
                    list[i] = this.toSQLStruct(elementType, array.getJSONObject(i));
                }
            } else {
                for (int i = 0; i < array.length(); ++i) {
                    list[i] = array.get(i);
                }
            }
            return this.conn.createArrayOf(elementType, list);
        }
        return value;
    }

    public Object toSQLStruct(String sqlTypeName, Object value) throws Exception {
        return JsonController.JSONtoSQLStruct(value, this.findTypeInfo(sqlTypeName));
    }

    private Object buildPassedValue(Object passValue, SPParameterInfo param) throws Exception {
        if (param.sqlTypes == 2003) {
            return this.toSQLArray(param, passValue);
        }
        if (param.sqlTypes == 2002) {
            return this.toSQLStruct(param.sqlTypeName, passValue);
        }
        if ((param.sqlTypes == 93 || param.sqlTypes == 91) && passValue instanceof String) {
            return DateExtension.Parse((String)passValue);
        }
        return passValue;
    }

    private void setObject(PreparedStatement stmt, int index, Object passValue, SPParameterInfo param) throws Exception {
        if (param.sqlTypes == -7) {
            stmt.setObject(index, passValue.toString());
            return;
        }
        if (param.sqlTypes == 2003 || param.sqlTypes == 2002) {
            stmt.setObject(index, this.buildPassedValue(passValue, param));
            return;
        }
        if ((param.sqlTypes == 93 || param.sqlTypes == 91) && passValue instanceof String) {
            if (this.DBType == DBTypeInfo.MySql) {
                stmt.setObject(index, this.buildPassedValue(passValue, param));
                return;
            }
            stmt.setObject(index, this.buildPassedValue(passValue, param), param.sqlTypes);
            return;
        }
        stmt.setObject(index, passValue, param.sqlTypes);
    }

    protected String getUniqueSqlParameterName(String paramName) {
        String paramKey = DBHelper.buildParamKey(paramName);
        if (this.inputParameterList.containsKey(paramKey)) {
            return this.getUniqueSqlParameterName(paramName + "_" + System.currentTimeMillis());
        }
        return paramName;
    }

    private void fillParameter(SPInfo spMeta, CallableStatement stmt) throws Exception {
        if (spMeta.parameterList.size() > 0) {
            for (int i = 0; i < spMeta.parameterList.size(); ++i) {
                SPParameterInfo param = spMeta.parameterList.get(i);
                String paramKey = DBHelper.buildParamKey(param.parameterName);
                String passParamName = param.parameterName;
                if (this.DBType == DBTypeInfo.PostgreSQL && param.isRefcursor() && param.parameterType == ParameterTypeInfo.procedureColumnIn) {
                    this.setObject(stmt, i + 1, paramKey, param);
                    continue;
                }
                if (this.inputParameterList.containsKey(paramKey) && param.parameterType == ParameterTypeInfo.procedureColumnIn) {
                    Object passValue = this.inputParameterList.get((Object)paramKey).parameterValue;
                    if (this.DBType == DBTypeInfo.PostgreSQL) {
                        this.setObject(stmt, i + 1, passValue, param);
                    } else {
                        stmt.setObject(passParamName, this.buildPassedValue(passValue, param));
                    }
                } else if (param.parameterType == ParameterTypeInfo.procedureColumnIn) {
                    if (this.DBType == DBTypeInfo.PostgreSQL) {
                        stmt.setNull(i + 1, param.sqlTypes);
                    } else {
                        stmt.setNull(passParamName, param.sqlTypes);
                    }
                }
                if (param.parameterType != ParameterTypeInfo.procedureColumnOut && param.parameterType != ParameterTypeInfo.procedureColumnInOut && param.parameterType != ParameterTypeInfo.procedureColumnReturn) continue;
                if (this.DBType == DBTypeInfo.PostgreSQL) {
                    stmt.registerOutParameter(i + 1, param.sqlTypes);
                    continue;
                }
                stmt.registerOutParameter(passParamName, param.sqlTypes);
            }
        }
    }

    public SPInfo findSPInfo(String spName) throws SQLException {
        String key = (this.dbUrl + "_SP_" + spName).toLowerCase();
        if (!CachedSPMeta.containsKey(key)) {
            Debugger.LogFactory.trace("Read SP Info:{}", (Object)key);
            SPInfo spMeta = new SPInfo();
            spMeta.dbName = this.dbUrl;
            spMeta.spName = spName;
            DatabaseMetaData metaData = this.conn.getMetaData();
            ResultSet rs = metaData.getProcedureColumns(null, null, spName, null);
            while (rs.next()) {
                SPParameterInfo parameter = new SPParameterInfo();
                parameter.parameterName = this.removeMSSQLPre(rs.getString("COLUMN_NAME"));
                parameter.parameterType = ParameterTypeInfo.convert(rs.getInt("COLUMN_TYPE"));
                if (parameter.parameterType == ParameterTypeInfo.procedureColumnReturn) {
                    spMeta.hasReturn = true;
                    if (this.DBType == DBTypeInfo.PostgreSQL) continue;
                }
                parameter.sqlTypes = rs.getInt("DATA_TYPE");
                parameter.sqlTypeName = rs.getString("TYPE_NAME");
                spMeta.parameterList.add(parameter);
            }
            spMeta.sqlCall = this.buildSPCallString(spMeta);
            CachedSPMeta.put(key, spMeta);
        }
        return CachedSPMeta.get(key);
    }

    public void printResult(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        while (rs.next()) {
            System.out.println();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                System.out.print(meta.getColumnName(i) + ":" + rs.getObject(i));
                System.out.print("  ");
            }
        }
    }

    private String removeMSSQLPre(String paramName) {
        if (this.DBType == DBTypeInfo.MicrosoftSQLServer && paramName.startsWith("@")) {
            return paramName.substring(1);
        }
        return paramName;
    }

    private static String buildParamKey(String paramName) {
        if (paramName.startsWith("@") || paramName.startsWith("$")) {
            return paramName.substring(1).toLowerCase();
        }
        return paramName.toLowerCase();
    }

    private String buildSPCallString(SPInfo spMeta) throws SQLException {
        String paramTemplete = "";
        if (spMeta.parameterList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            for (SPParameterInfo ignored : spMeta.parameterList) {
                if (ignored.isIgnore()) continue;
                sb.append("?,");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
            paramTemplete = sb.toString();
        }
        if (this.DBType == DBTypeInfo.PostgreSQL) {
            return String.format("SELECT %s%s", spMeta.spName, paramTemplete);
        }
        if (spMeta.hasReturn) {
            return String.format("{? = call %s%s}", spMeta.spName, paramTemplete);
        }
        return String.format("{call %s%s}", spMeta.spName, paramTemplete);
    }

    public SPInfo findTSQLInfo(String commandText) throws SQLException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String key = (this.dbUrl + "_" + commandText).toLowerCase();
        if (!CachedSPMeta.containsKey(key)) {
            Debugger.LogFactory.trace("Read TSQL Info:{}", (Object)key);
            SPInfo spMeta = new SPInfo();
            spMeta.dbName = this.dbUrl;
            spMeta.sqlCall = commandText;
            spMeta.spName = "TSQL";
            ArrayList<String> list = DBHelper.findTSQLParameters(commandText);
            if (list.size() > 0) {
                for (String param : list) {
                    SPParameterInfo parameter = new SPParameterInfo();
                    String[] paramMeta = param.split("\\|");
                    String paramName = paramMeta[0];
                    String replacement = "?";
                    parameter.parameterName = paramName;
                    parameter.parameterType = ParameterTypeInfo.procedureColumnIn;
                    if (paramMeta.length > 1) {
                        String[] parmTypes = paramMeta[1].split("::");
                        if (parmTypes.length > 1) {
                            parameter.sqlTypes = Integer.parseInt(parmTypes[0]);
                            parameter.sqlTypeName = parmTypes[1];
                            replacement = "?::" + parameter.sqlTypeName;
                        } else {
                            parameter.sqlTypes = Integer.parseInt(paramMeta[1]);
                        }
                    } else {
                        parameter.sqlTypes = 12;
                    }
                    spMeta.parameterList.add(parameter);
                    spMeta.sqlCall = spMeta.sqlCall.replace("$" + param, replacement);
                }
            } else {
                PreparedStatement preparedStatement = this.conn.prepareStatement(spMeta.sqlCall);
                ParameterMetaData metaList = preparedStatement.getParameterMetaData();
                for (int i = 1; i <= metaList.getParameterCount(); ++i) {
                    SPParameterInfo parameter = new SPParameterInfo();
                    parameter.parameterName = "?";
                    parameter.parameterType = ParameterTypeInfo.procedureColumnIn;
                    parameter.sqlTypes = metaList.getParameterType(i);
                    spMeta.parameterList.add(parameter);
                }
            }
            CachedSPMeta.put(key, spMeta);
        }
        return CachedSPMeta.get(key);
    }

    public TableInfo findTypeInfo(String typeName) throws Exception {
        return DBHelper.findTypeInfo(this.conn, typeName);
    }

    public static TableInfo findTypeInfo(Connection conn, String typeName) throws Exception {
        String key = (DBConnectionInfo.Parser((String)conn.getMetaData().getURL()).Url + "_TYPE_" + typeName).toLowerCase();
        if (!CachedTableMeta.containsKey(key)) {
            Debugger.LogFactory.trace("Read Type Info:{}", (Object)key);
            DatabaseMetaData meta = conn.getMetaData();
            String schemaName = null;
            int schemaIndex = typeName.indexOf(".");
            if (schemaIndex >= 0) {
                schemaName = typeName.substring(0, schemaIndex);
                typeName = typeName.substring(schemaIndex + 1);
            }
            ResultSet rsColumn = meta.getColumns(null, schemaName, typeName, null);
            TableInfo output = new TableInfo();
            output.name = typeName;
            output.columnList = DBBeanReader.read(rsColumn, ColumnInfo.class);
            rsColumn.close();
            CachedTableMeta.put(key, output);
        }
        return CachedTableMeta.get(key);
    }

    public ConcurrentHashMap<String, TableInfo> findAllTableInfo() throws Exception {
        String key = (this.dbUrl + "_" + this.conn.getCatalog()).toLowerCase();
        if (!CachedAllTableMeta.containsKey(key)) {
            Debugger.LogFactory.trace("Read ALL TABLE Info:{}", (Object)key);
            ConcurrentHashMap<String, TableInfo> output = new ConcurrentHashMap<String, TableInfo>();
            DatabaseMetaData meta = this.conn.getMetaData();
            String[] types = new String[]{"TABLE", "VIEW"};
            ResultSet rs = meta.getTables(null, null, "%", types);
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                output.put(tableName, this.findTableInfo(tableName));
            }
            CachedAllTableMeta.put(key, output);
        }
        return CachedAllTableMeta.get(key);
    }

    public TableInfo findTableInfo(String tableName) throws Exception {
        String key = (this.dbUrl + "_TABLE_" + tableName).toLowerCase();
        if (!CachedTableMeta.containsKey(key)) {
            Debugger.LogFactory.trace("Read TABLE Info:{}", (Object)key);
            DatabaseMetaData meta = this.conn.getMetaData();
            String schemaName = null;
            int schemaIndex = tableName.indexOf(".");
            if (schemaIndex >= 0) {
                schemaName = tableName.substring(0, schemaIndex);
                tableName = tableName.substring(schemaIndex + 1);
            }
            ResultSet rsColumn = meta.getColumns(null, schemaName, tableName, null);
            TableInfo output = new TableInfo();
            output.name = tableName;
            output.columnList = DBBeanReader.read(rsColumn, ColumnInfo.class);
            rsColumn.close();
            ResultSet rsKeys = meta.getPrimaryKeys(null, schemaName, tableName);
            block0: while (rsKeys.next()) {
                for (ColumnInfo column : output.columnList) {
                    if (!column.columnName.equalsIgnoreCase(rsKeys.getString(4))) continue;
                    column.isKey = true;
                    continue block0;
                }
            }
            rsKeys.close();
            this.findColumnInfo_ex(output.columnList);
            CachedTableMeta.put(key, output);
        }
        return CachedTableMeta.get(key);
    }

    public HashMap<String, ColumnInfo> getTableColumnList(String tableName) throws Exception {
        TableInfo table = this.findTableInfo(tableName);
        if (table == null || table.columnList == null || table.columnList.size() == 0) {
            throw new IllegalArgumentException("Specific table don't have any column:" + tableName);
        }
        HashMap<String, ColumnInfo> columnList = new HashMap<String, ColumnInfo>();
        for (ColumnInfo column : table.columnList) {
            columnList.put(column.columnName, column);
        }
        return columnList;
    }

    private void findColumnInfo_ex(List<ColumnInfo> columnList) throws Exception {
        for (ColumnInfo column : columnList) {
            if (column.sqlType == 2002) {
                column.columnList = this.findTypeInfo((String)column.sqlTypeName).columnList;
                this.findColumnInfo_ex(column.columnList);
            }
            if (column.sqlType != 2003 || column.getArrayElementType() != 2002) continue;
            column.columnList = this.findTypeInfo((String)StringExtension.TrimStart((String)column.getArrayElementTypeName(), (String)"_")).columnList;
            this.findColumnInfo_ex(column.columnList);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized SPInfo findSPMetaInfo(String connectionString, String spName, CommandTypeInfo commandType) throws SQLException, ClassNotFoundException, IOException, NamingException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String key = ("findSPMetaInfo_" + connectionString + "_" + spName).toLowerCase();
        if (CachedSPMeta.containsKey(key)) return CachedSPMeta.get(key);
        try (DBHelper helper = new DBHelper(connectionString);){
            switch (commandType) {
                case TSQL: {
                    CachedSPMeta.put(key, helper.findTSQLInfo(spName));
                    return CachedSPMeta.get(key);
                }
                case StoredProcedure: {
                    CachedSPMeta.put(key, helper.findSPInfo(spName));
                    return CachedSPMeta.get(key);
                }
            }
            return CachedSPMeta.get(key);
        }
    }

    public static synchronized TableInfo findTableInfo(String connectionString, String tableName) throws Exception {
        String key = ("findTableInfo_" + connectionString + "_" + tableName).toLowerCase();
        if (!CachedTableMeta.containsKey(key)) {
            try (DBHelper helper = new DBHelper(connectionString);){
                CachedTableMeta.put(key, helper.findTableInfo(tableName));
            }
        }
        return CachedTableMeta.get(key);
    }

    public static ArrayList<String> findTSQLParameters(String content) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Pattern pattern = Pattern.compile("(\\$[^\",;=\\) ]*)", 2);
        Matcher matcher = pattern.matcher(content);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            String param = matcher.group();
            list.add(param.substring(1).trim());
        }
        return list;
    }

    public static TableInfo findResultsColumnInfo(ResultSetMetaData rsMeta) throws SQLException {
        int numberOfColumns = rsMeta.getColumnCount();
        TableInfo tableMeta = new TableInfo();
        for (int i = 1; i <= numberOfColumns; ++i) {
            ColumnInfo columnMeta = new ColumnInfo();
            String label = rsMeta.getColumnLabel(i);
            columnMeta.columnName = StringExtension.IsNullOrEmpty(label) ? rsMeta.getColumnName(i) : label;
            columnMeta.columnSize = rsMeta.getColumnDisplaySize(i);
            columnMeta.javaClassName = rsMeta.getColumnClassName(i);
            columnMeta.sqlTypeName = rsMeta.getColumnTypeName(i);
            columnMeta.sqlType = rsMeta.getColumnType(i);
            columnMeta.nullable = rsMeta.isNullable(i) != 0;
            columnMeta.autoIncrement = rsMeta.isAutoIncrement(i);
            columnMeta.position = i - 1;
            tableMeta.columnList.add(columnMeta);
        }
        return tableMeta;
    }

    public static synchronized HashMap<String, FieldInfo> findClassFieldInfo(Class<?> type) throws Exception {
        String classKey = "$DBHelper$FindClassFieldInfo".concat(type.getName());
        return (HashMap)StaticMemoryCacheHelper.AddNeverExpiredMemoryCache(classKey, new Operation<HashMap<String, FieldInfo>>(new Object[]{type}){

            @Override
            public HashMap<String, FieldInfo> call() throws Exception {
                HashMap<String, FieldInfo> fieldList = new HashMap<String, FieldInfo>();
                Class runType = (Class)this.params[0];
                Debugger.LogFactory.trace(runType.getName());
                for (Field field : runType.getDeclaredFields()) {
                    IgnoreDBColumnAttribute ignoreAttribute = field.getAnnotation(IgnoreDBColumnAttribute.class);
                    if (ignoreAttribute != null) continue;
                    DBColumnAttribute columnAttribute = field.getAnnotation(DBColumnAttribute.class);
                    FieldInfo fieldMeta = new FieldInfo();
                    fieldMeta.field = field;
                    if (columnAttribute != null) {
                        String columnName;
                        String string = columnName = columnAttribute.columnName().length() == 0 ? field.getName() : columnAttribute.columnName();
                        if (columnAttribute.isEntity()) {
                            DBHelper.findClassFieldInfo(field.getType());
                        }
                        fieldMeta.columnAttribute = columnAttribute;
                        fieldList.put(columnName.toLowerCase(), fieldMeta);
                        continue;
                    }
                    fieldList.put(field.getName().toLowerCase(), fieldMeta);
                }
                return fieldList;
            }
        });
    }

    public static Map<String, Object> ReadOutputParameterList(SPInfo spMetaInfo, CallableStatement callableStatement, DBTypeInfo dbType) throws SQLException {
        HashMap<String, Object> outputParameterList = new HashMap<String, Object>();
        if (spMetaInfo.parameterList != null && spMetaInfo.parameterList.size() > 0) {
            for (int i = 0; i < spMetaInfo.parameterList.size(); ++i) {
                SPParameterInfo param = spMetaInfo.parameterList.get(i);
                if (param.parameterType != ParameterTypeInfo.procedureColumnOut && param.parameterType != ParameterTypeInfo.procedureColumnInOut && param.parameterType != ParameterTypeInfo.procedureColumnReturn) continue;
                if (dbType == DBTypeInfo.PostgreSQL) {
                    outputParameterList.put(DBHelper.buildParamKey(param.parameterName), callableStatement.getObject(i + 1));
                    continue;
                }
                outputParameterList.put(DBHelper.buildParamKey(param.parameterName), callableStatement.getObject(param.parameterName));
            }
        }
        return outputParameterList;
    }

    public Map<String, Object> getOutputParameterList() throws SQLException {
        return DBHelper.ReadOutputParameterList(this.SPMetaInfo, (CallableStatement)this.statement, this.DBType);
    }

    public static int sqlTypeNameToType(String sqlTypeName) throws IllegalAccessException {
        for (Field field : Types.class.getFields()) {
            if (!field.getName().equalsIgnoreCase(sqlTypeName)) continue;
            return (Integer)field.get(null);
        }
        return 12;
    }
}

