/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.Model;

import LinkFuture.Init.Extensions.StringExtension;

public enum ContentType {
    Xml("application/xml", "application/xml"),
    Json("application/json", "json"),
    FromURL("application/x-www-form-urlencoded", "urlencoded"),
    FromMultipart("multipart/form-data", "multipart"),
    Binary("application/octet-stream", "stream"),
    Text("text/plain", "text/plain"),
    Html("text/html", "text/html");

    private String contentType;
    private String containKey;

    private ContentType(String contentType, String containKey) {
        this.contentType = contentType;
        this.containKey = containKey;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContainKey() {
        return this.containKey;
    }

    public static ContentType parser(String contentType) {
        if (StringExtension.IsNullOrEmpty(contentType)) {
            return null;
        }
        contentType = contentType.toLowerCase();
        for (ContentType con : (ContentType[])ContentType.class.getEnumConstants()) {
            if (contentType.indexOf(con.getContainKey()) <= 0) continue;
            return con;
        }
        return FromURL;
    }
}

