/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.ContentSelector;

import LinkFuture.Core.ContentManager.ContentSelector.ContentBaseSelector;
import LinkFuture.Core.ContentManager.ContentSelector.ContentSelectorMeta;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.Utility;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.ObjectExtend.NameValuePair;
import LinkFuture.Init.ObjectExtend.XsltInfo;

public class ContentXSLTSelector
extends ContentBaseSelector {
    public ContentXSLTSelector(ContentParameterCollectionInfo parameters, ContentSelectorMeta meta) {
        super(parameters, meta);
    }

    private XsltInfo ReadXslt(ContentParameterCollectionInfo parameters) throws Exception {
        String xsltPath = parameters.ParamReplace(this.meta.Key);
        return Utility.XsltReader(xsltPath);
    }

    @Override
    public Object LoadSelector() throws Exception {
        Debugger.LogFactory.trace("Load Selector: {}", (Object)this.meta.toString());
        String[] sourceList = this.meta.Source.trim().split("\\|");
        StringBuilder sb = new StringBuilder();
        sb.append("<Root>");
        for (String source : sourceList) {
            if (!this.currentParameters.containsKey(source)) {
                throw new IllegalArgumentException("Specific source can't be found " + source);
            }
            sb.append(String.format("<Content name=\"%s\">", source));
            sb.append(this.currentParameters.get(source).toString());
            sb.append("</Content>");
        }
        sb.append("</Root>");
        XsltInfo xsltInfo = this.ReadXslt((ContentParameterCollectionInfo)this.currentParameters);
        return Utility.xsltTransformer(sb.toString(), xsltInfo.XsltContent, xsltInfo.XsltFilePath, new NameValuePair[0]);
    }

    @Override
    public String BuildSelectorIdentity() throws Exception {
        return "$ContentProcessorSelector$".concat(this.meta.toString());
    }
}

