/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.ContentProcessor;

import LinkFuture.Core.ContentManager.ContentProcessor.IContentProcessor;
import LinkFuture.Core.ContentManager.Model.AddInfo;
import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ProcessorInfo;
import LinkFuture.Core.ContentManager.Model.ProcessorRunningInfo;
import LinkFuture.Core.Utility;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.StringExtension;

public abstract class ContentBaseProcessor
implements IContentProcessor {
    public ContentItemInfo ContentItem;
    public ProcessorInfo CurrentProcessor;
    public AddInfo add;
    private String processorIdentity;

    public ContentBaseProcessor(ProcessorRunningInfo runningInfo) {
        this.ContentItem = runningInfo.contentItem;
        this.CurrentProcessor = runningInfo.processor;
        this.add = runningInfo.add;
    }

    @Override
    public abstract void Transformer(ContentResultCollectionInfo var1, ContentParameterCollectionInfo var2) throws Exception;

    @Override
    public String GerProcessorIdentity(ContentParameterCollectionInfo parameters) throws Exception {
        if (StringExtension.IsNullOrEmpty(this.processorIdentity)) {
            this.processorIdentity = this.BuildProcessorIdentity(parameters);
        }
        return this.processorIdentity;
    }

    public abstract String BuildProcessorIdentity(ContentParameterCollectionInfo var1) throws Exception;

    @Override
    public abstract void Verify(ProcessorInfo var1) throws Exception;

    @Override
    public boolean MatchCondition(ContentItemInfo content, ContentParameterCollectionInfo parameters) {
        if (content != null && this.add != null && !StringExtension.IsNullOrEmpty(this.add.Condition)) {
            Debugger.LogFactory.trace("MatchCondition:{}", (Object)this.add.Condition);
            return Utility.stringExpression(parameters, this.add.Condition);
        }
        return true;
    }
}

