/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.ContentParameter;

import LinkFuture.Core.ContentManager.ContentParameter.ContentBeanBaseParameter;
import LinkFuture.Core.ContentManager.ContentParameter.PropertiesParameterMetaInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ParameterInfo;
import LinkFuture.Core.Utility;
import LinkFuture.Init.Extensions.PathExtension;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesParameter
extends ContentBeanBaseParameter<PropertiesParameterMetaInfo> {
    public PropertiesParameter(ParameterInfo currentParameter) throws Exception {
        super(currentParameter, PropertiesParameterMetaInfo.class);
    }

    @Override
    public CaseInsensitiveMap<Object> GerResource(ContentParameterCollectionInfo parameters) throws Exception {
        String filePath = this.GetAbsolutePath(parameters);
        Properties file = Utility.ReadProperties(filePath);
        CaseInsensitiveMap<Object> passedParameters = new CaseInsensitiveMap<Object>();
        for (Map.Entry<Object, Object> item : file.entrySet()) {
            passedParameters.put(item.getKey().toString(), item.getValue());
        }
        return passedParameters;
    }

    private String GetAbsolutePath(ContentParameterCollectionInfo parameters) {
        if (StringExtension.IsNullOrEmpty(((PropertiesParameterMetaInfo)this.Meta).RelativePath)) {
            throw new IllegalArgumentException("PropertiesParameter file " + ((PropertiesParameterMetaInfo)this.Meta).RelativePath + " can't not be empty");
        }
        return PathExtension.FullPhysicalPath(parameters.ParamReplace(((PropertiesParameterMetaInfo)this.Meta).RelativePath));
    }

    @Override
    public String GerParameterIdentity(ContentParameterCollectionInfo parameters) {
        return "$PropertiesParameter$".concat(this.GetAbsolutePath(parameters));
    }
}

