/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.ContentAction;

import LinkFuture.Core.ContentManager.ContentAction.ContentActionInfo;
import LinkFuture.Core.ContentManager.ContentAction.IContentAction;
import LinkFuture.Core.ContentManager.ContentProcessor.IContentProcessor;
import LinkFuture.Core.ContentManager.ContentResource.ContentBaseResource;
import LinkFuture.Core.ContentManager.ContentResource.IContentResource;
import LinkFuture.Core.ContentManager.ContentSecurity.IContentSecurity;
import LinkFuture.Core.ContentManager.ContentSelector.ContentSelectorController;
import LinkFuture.Core.ContentManager.ContentValidator.IContentValidator;
import LinkFuture.Core.ContentManager.Model.AddCycleType;
import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultInfo;
import LinkFuture.Core.MemoryManager.MemoryFactory;
import LinkFuture.Core.MemoryManager.Meta.MemoryCacheMetaInfo;
import LinkFuture.Core.MemoryManager.StaticMemoryCache.StaticMemoryCacheHelper;
import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Core.OperationManager.OperationController;
import LinkFuture.Init.Debugger;
import java.util.ArrayList;
import java.util.List;

public class ContentBaseAction
implements IContentAction {
    ContentActionInfo actionMeta;

    public ContentBaseAction(ContentActionInfo actionMeta) {
        this.actionMeta = actionMeta;
        this.Init();
    }

    @Override
    public void Init() {
    }

    public ContentResultCollectionInfo Action() throws Exception {
        ContentParameterCollectionInfo parameters = this.actionMeta.BuildContentParameter();
        MemoryCacheMetaInfo meta = MemoryFactory.FindMemoryCache(this.actionMeta.ContentItem.CacheSettingKey);
        Object[] passArgs = new Object[]{parameters, this.actionMeta};
        if (meta == null || !meta.Enable) {
            return ContentBaseAction.LoadContentCallback(passArgs);
        }
        meta.Key = this.actionMeta.IdentityKey(parameters);
        Debugger.LogFactory.trace("Content item: {} =>{}", (Object)this.actionMeta.ContentItem.Name, (Object)meta.Key);
        meta.Action = new Operation<Object>(passArgs){

            @Override
            public Object call() throws Exception {
                return ContentBaseAction.LoadContentCallback(this.params);
            }
        };
        return (ContentResultCollectionInfo)StaticMemoryCacheHelper.AddMemoryCache(meta);
    }

    private static ContentResultCollectionInfo LoadContentCallback(Object ... args) throws Exception {
        ContentParameterCollectionInfo parameters = (ContentParameterCollectionInfo)args[0];
        ContentActionInfo action = (ContentActionInfo)args[1];
        ContentItemInfo contentItem = action.ContentItem;
        Debugger.LogFactory.trace("Retrieve Content:{}-{}", (Object)contentItem.Name, (Object)contentItem.Version);
        if (!action.IgnoreSecurity) {
            for (IContentSecurity iContentSecurity : action.SecurityList) {
                iContentSecurity.Verify(contentItem, parameters);
            }
        }
        for (IContentValidator iContentValidator : action.ValidatorList) {
            iContentValidator.Valid(parameters);
        }
        ContentResultCollectionInfo resultList = new ContentResultCollectionInfo();
        for (ArrayList<IContentResource> resourcesList : action.ResourceList) {
            if (resourcesList.size() == 1) {
                ContentBaseResource currentResource = (ContentBaseResource)resourcesList.get(0);
                if (!currentResource.MatchCondition(contentItem, parameters)) continue;
                ContentResultInfo result = currentResource.GerResource(contentItem, parameters);
                resultList.add(result);
                parameters.put("$" + result.Name, result);
                ContentSelectorController.BuilderSelector(currentResource.CurrentAdd, parameters, AddCycleType.After);
                continue;
            }
            ArrayList tasks = new ArrayList();
            for (IContentResource resource : resourcesList) {
                if (!resource.MatchCondition(contentItem, parameters)) continue;
                tasks.add(new Operation<ContentResultInfo>(new Object[]{resource, contentItem, parameters}){

                    @Override
                    public ContentResultInfo call() throws Exception {
                        ContentBaseResource subResource = (ContentBaseResource)this.params[0];
                        ContentItemInfo contentItem = (ContentItemInfo)this.params[1];
                        ContentParameterCollectionInfo parameters = (ContentParameterCollectionInfo)this.params[2];
                        return subResource.GerResource(contentItem, parameters);
                    }
                });
            }
            List<ContentResultInfo> parallelResult = OperationController.runInParallel(tasks);
            for (ContentResultInfo item : parallelResult) {
                resultList.add(item);
                parameters.put("$" + item.Name, item);
                ContentSelectorController.BuilderSelector(item.Add, parameters, AddCycleType.After);
            }
        }
        if (!action.ResourceOnly && resultList.size() > 0) {
            for (IContentProcessor processor : action.ProcessorList) {
                if (!processor.MatchCondition(contentItem, parameters)) continue;
                processor.Transformer(resultList, parameters);
            }
        }
        resultList.Params = parameters;
        return resultList;
    }

    @Override
    public void Destroy() {
    }
}

