package LinkFuture.Core;

import LinkFuture.Core.DeepCopy.FastByteArrayOutputStream;
import LinkFuture.Core.MemoryManager.StaticMemoryCache.StaticMemoryCacheHelper;
import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Core.WebClient.WebClient;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.PathExtension;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.NameValuePair;
import LinkFuture.Init.ObjectExtend.XsltInfo;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import org.eclipse.persistence.jaxb.JAXBContextProperties;
import org.eclipse.persistence.jaxb.MarshallerProperties;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import javax.naming.NamingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.*;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import java.io.*;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by Cyokin
 * on 11/23/2014.
 */
public class Utility{

    //<editor-fold desc="Object Serialization">

    /**
     * Any object to Bytes, make sure implements Serializable
     * @param obj
     * @return bytes
     */
    public static byte[] toByte(Serializable obj) {
        try(ByteArrayOutputStream bos = new ByteArrayOutputStream()) {
            try(ObjectOutput out = new ObjectOutputStream(bos))
            {
                out.writeObject(obj);
                return bos.toByteArray();
            }
        } catch (Exception e)
        {
            Debugger.LogFactory.error("Exception when convert a object to byte[]", e);
            return null;
        }
    }

    /**
     * Any object from Bytes, make sure implements Serializable
     * @param b
     * @return T
     */
    public static<T> T fromByte(byte[] b) {
        try(ByteArrayInputStream bos = new ByteArrayInputStream(b)) {
            try(ObjectInput  in = new ObjectInputStream(bos))
            {
                Object obj = in.readObject();
                return (T)obj;
            }
        } catch (Exception e)
        {
            Debugger.LogFactory.error("Exception when convert byte[] to object",e);
            return null;
        }
    }
    //</editor-fold>

    //<editor-folder desc = "JAXBContext Xml Serialization">  https://jaxb.java.net/
        /*
        *  Simple: http://simple.sourceforge.net/  good frame to xml serialization
        *  JAXB: offical xml serialization
        *        CData solution
        *        1, leverage JAXBCData class. by following annotations. @XmlJavaTypeAdapter(JAXBCData.class)   @XmlValue
        *        2, leverage EclipseLink, it has an annotations call @XmlCDATA
        *  Xstream: support xml and json serialization
        * */
    @SuppressWarnings("unchecked")
    public static<T> T fromXml(String xmlString,Class<T> targetClass) {
        Debugger.LogFactory.trace("Serializing xml to object: {}", targetClass);
        JAXBContext context;
        try {
            context = JAXBContext.newInstance(targetClass);
            Unmarshaller jaxbUnmarshaller = context.createUnmarshaller();
            return (T) jaxbUnmarshaller.unmarshal(new StringReader(xmlString));
        } catch (JAXBException e) {
            e.printStackTrace();
        }
        //noinspection UnusedAssignment
        context = null;
        return null;
    }

    public static<T> String toXml(T obj)
    {
        JAXBContext context;
        try {
            Debugger.LogFactory.trace("Serializing object to xml: {}", obj);
            context = JAXBContext.newInstance(obj.getClass());
            Marshaller m = context.createMarshaller();
            m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
            //CDATA solution when transfer object to xml.
            //looks not working when on website solution, but works on application. no idea why
            //            m.setProperty("com.sun.xml.bind.marshaller.CharacterEscapeHandler",
            //                    new CDataCharacterEscapeHandler());

            StringWriter sw = new StringWriter();
            m.marshal(obj, sw);
            return sw.getBuffer().toString();
        } catch (JAXBException e) {
            e.printStackTrace();
        }
        //noinspection UnusedAssignment
        context = null;
        return null;
    }

    /*
    *  Must put jaxb.properties under same folder with Model class!!
    * */
    public static<T> String toJson(T obj,boolean attributePref)
    {
        Debugger.LogFactory.trace("Serializing object to json: {}",obj);
        JAXBContext context;
        try {
            context = JAXBContext.newInstance(obj.getClass());
            Marshaller m = context.createMarshaller();
            m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
            //m.setProperty(MarshallerProperties.JSON_WRAPPER_AS_ARRAY_NAME, true);
            m.setProperty(MarshallerProperties.MEDIA_TYPE, "application/json");
            m.setProperty(MarshallerProperties.JSON_INCLUDE_ROOT, false);
            if(attributePref)
                m.setProperty(MarshallerProperties.JSON_ATTRIBUTE_PREFIX, "@");
            StringWriter sw = new StringWriter();
            m.marshal(obj, sw);
            return sw.getBuffer().toString();
        } catch (JAXBException e) {
            e.printStackTrace();
        }
        //noinspection UnusedAssignment
        context = null;
        return null;
    }
    public static<T> String toJson(T obj)
    {
        return toJson(obj,false);
    }
    public static<T> T fromJson(String jsonString,Class<T> targetClass,boolean attributePref)
    {
        Debugger.LogFactory.trace("Serializing json to object: {}", targetClass);
        JAXBContext context;
        try {
            context = JAXBContext.newInstance(targetClass);
            Unmarshaller um = context.createUnmarshaller();
            //um.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
            um.setProperty(JAXBContextProperties.MEDIA_TYPE, "application/json");
            um.setProperty(JAXBContextProperties.JSON_INCLUDE_ROOT, false);
            if(attributePref)
                um.setProperty(JAXBContextProperties.JSON_ATTRIBUTE_PREFIX, "@");

            StreamSource json = new StreamSource(new StringReader(jsonString));
            return um.unmarshal(json,targetClass).getValue();
        } catch (JAXBException e) {
            e.printStackTrace();
        }
        //noinspection UnusedAssignment
        context = null;
        return null;
    }
    public static<T> T fromJson(String xmlString,Class<T> targetClass)
    {
        return fromJson(xmlString,targetClass,false);
    }
    //</editor-folder >

    //<editor-fold desc="Jackson JSON Serialization ">
    public static String jacksonToJson(Object obj) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        mapper.writeValue(output,obj);
        return new String(output.toByteArray(),"UTF-8");
    }
    public static <T> T jacksonFromJson(String jsonString,Class<T> parametrizedClass ,Class<?>... parameterClasses) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        if(parameterClasses.length==0)
        {
            return mapper.readValue(jsonString,parametrizedClass);
        }
        else
        {
            ArrayList<Class<?>> subClass = new ArrayList<>();
            subClass.add(parametrizedClass);
            subClass.addAll(Arrays.asList(parameterClasses));
            JavaType parameterType=null;
            for (int i = subClass.size()-1;i>=0;i--)
            {
                if(parameterType==null)
                {
                    parameterType = mapper.getTypeFactory().constructParametricType(subClass.get(i-1),subClass.get(i));
                    i--;
                }
                else
                {
                    parameterType = mapper.getTypeFactory().constructParametricType(subClass.get(i) ,parameterType);
                }
            }
            return mapper.readValue(jsonString,parameterType);
        }
    }
    //</editor-fold>


    //<editor-folder desc = "Object Serialization">
    @SuppressWarnings("UnusedDeclaration")
    public static<T> T DeepCopy(Object orig) throws IOException {
        FastByteArrayOutputStream fbos = new FastByteArrayOutputStream();
        try(ObjectOutputStream out = new ObjectOutputStream(fbos)) {
            // Write the object out to a byte array
            out.writeObject(orig);
            out.flush();
            // Retrieve an input stream from the byte array and read
            // a copy of the object back in.
            ObjectInputStream in = new ObjectInputStream(fbos.getInputStream());
            Object obj = in.readObject();
            out.close();
            //noinspection unchecked
            return (T)obj;
        }
        catch(Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    //</editor-folder>

    /**
     * read file from either URL or local path,
     * use StringExtension.IsWellFormedUriString to detector weather URL or not
     **/
    public static String getStringFromFileUrl(String fileUrl) throws IOException {
        //ignore no protrcal URL
        if(!StringExtension.IsWellFormedUriString(fileUrl) && !fileUrl.startsWith("//"))
        {
            String localPath = PathExtension.FullPhysicalPath(fileUrl);
            return LinkFuture.Init.Utility.getStringFromFile(localPath);
        }
        else
        {
            return WebClient.get(fileUrl).response;
        }
    }

    //<editor-folder desc = "XStream Xml Serialization">
        /*
            Reference:http://xstream.codehaus.org/tutorial.html
        */
    //	public static String convertToXml(Object obj) {
    //		XStream xstream = new XStream(new DomDriver());
    //		xstream.processAnnotations(obj.getClass());
    //		return xstream.toXML(obj);
    //	}
    //	@SuppressWarnings("unchecked")
    //	public static<T> T convertFromXml(String xmlString,Class<T> targetClass) {
    //		XStream xstream = new XStream(new DomDriver()){
    //            //ignore No such field error
    //            @Override
    //            protected MapperWrapper wrapMapper(MapperWrapper next) {
    //                return new MapperWrapper(next) {
    //                    @Override
    //                    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
    //                        if (definedIn == Object.class) {
    //                            return false;
    //                        }
    //                        return super.shouldSerializeMember(definedIn, fieldName);
    //                    }
    //                };
    //            }
    //        };
    //		xstream.processAnnotations(targetClass);
    //		return (T)xstream.fromXML(xmlString);
    //	}
    //
    //    public static String convertToJson(Object obj,boolean dropRoot) {
    //        XStream xstream = new XStream(buildJsonDriver(dropRoot));
    //        xstream.processAnnotations(obj.getClass());
    //        xstream.setMode(XStream.NO_REFERENCES);
    //        return xstream.toXML(obj);
    //    }
    //    public static String convertToJson(Object obj){
    //        return  convertToJson(obj,false);
    //    }
    //    private static JsonHierarchicalStreamDriver buildJsonDriver(boolean dropRoot)      {
    //        if(dropRoot)
    //        {
    //            return new JsonHierarchicalStreamDriver() {
    //                public HierarchicalStreamWriter createWriter(Writer writer) {
    //                    return new JsonWriter(writer, JsonWriter.DROP_ROOT_MODE);
    //                }
    //            };
    //        }
    //        else{
    //            return new JsonHierarchicalStreamDriver();
    //        }
    //    }
    //    public static<T> T convertFromJson(String jsonString,Class<T> targetClass){
    //        //must reference jettison-1.3.3.jar
    //        XStream xstream = new XStream(new JettisonMappedXmlDriver()){
    //            //ignore No such field error
    //            @Override
    //            protected MapperWrapper wrapMapper(MapperWrapper next) {
    //                return new MapperWrapper(next) {
    //                    @Override
    //                    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
    //                        if (definedIn == Object.class) {
    //                            return false;
    //                        }
    //                        return super.shouldSerializeMember(definedIn, fieldName);
    //                    }
    //                };
    //            }
    //        };
    //        xstream.processAnnotations(targetClass);
    //        return  (T)xstream.fromXML(jsonString);
    //    }
    //
    //
    //    //XML to json
    //    //http://code.google.com/p/infoscoop/source/browse/branches/3.0/src/main/java/org/infoscoop/util/Xml2Json.java?r=629
    //    //http://json.org/java/
    //    public static String convertXmlToJson(String xmlString) {
    //        //must reference jettison-1.3.3.jar & xpp3_min-1.1.4c.jar
    //        HierarchicalStreamReader sourceReader = new com.thoughtworks.xstream.io.xml.XppReader(new StringReader(xmlString));
    //        StringWriter buffer = new StringWriter();
    //        JettisonMappedXmlDriver jettisonDriver = new JettisonMappedXmlDriver();
    //        HierarchicalStreamWriter destinationWriter = jettisonDriver.createWriter(buffer);
    //        HierarchicalStreamCopier copier = new HierarchicalStreamCopier();
    //        copier.copy(sourceReader, destinationWriter);
    //        return buffer.toString();
    //    }


    //</editor-folder >

    //<editor-folder desc = "XSLT">
    //http://docs.oracle.com/cd/B14099_19/web.1012/b14033/adx04xsj.htm
    private static TransformerFactory xsltFactory;
    public static String xsltTransformer(String xml,String xslt,NameValuePair...  paramList) throws TransformerException
    {
        return xsltTransformer(xml,xslt,PathExtension.getApplicationPath(),paramList);
    }
    public static String xsltTransformer(String xml,String xslt,String xsltLookUpFolder,NameValuePair...  paramList) throws TransformerException {
        if(xsltFactory==null)
        {
            xsltFactory =  TransformerFactory.newInstance();
        }
        StreamSource source = new StreamSource(new StringReader(xslt));
        source.setSystemId(new File(xsltLookUpFolder));
        Transformer xmlTransformer = xsltFactory.newTransformer(source);
        //append parameters
        if(paramList!=null && paramList.length>0)
        {
            for(NameValuePair item:paramList)
            {
                xmlTransformer.setParameter(item.id,item.value);
            }
        }
        StringWriter xmlResultResource = new StringWriter();
        xml=removeUtf8BOM(xml);
        xmlTransformer.transform(new StreamSource(new StringReader(xml)), new StreamResult(xmlResultResource));
        return xmlResultResource.getBuffer().toString();
    }
    public static InputStream removeUtf8BOM(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(new BufferedInputStream(inputStream), 3);
        byte[] bom = new byte[3];
        if (pushbackInputStream.read(bom) != -1) {
            if (!(bom[0] == (byte) 0xEF && bom[1] == (byte) 0xBB && bom[2] == (byte) 0xBF)) {
                pushbackInputStream.unread(bom);
            }
        }
        return pushbackInputStream;
    }
    public static String removeUtf8BOM(String input){
        final String UTF8_BOM = "\uFEFF";
        if(input.startsWith(UTF8_BOM)){
            return input.substring(1);
        }
        return input;
    }
    public static String removeXmlDeclaration(String xml){
        String regex = "<\\?xml.*\\?>";
        return xml.replaceAll(regex, "");
    }

    //http://en.wikipedia.org/wiki/Java_API_for_XML_Processing
    public static Document parseXmlDom(String xmlStr) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf=DocumentBuilderFactory.newInstance();
        DocumentBuilder db =dbf.newDocumentBuilder();
        // Parse XML String to DOM
        dbf.setNamespaceAware(true);
        dbf.setIgnoringComments(true);
        return db.parse(new InputSource(new StringReader(xmlStr)));
    }

    @SuppressWarnings("UnusedDeclaration")
    public static String parseXmlSax(String xmlStr) throws SAXException, IOException, ParserConfigurationException {

        final StringBuffer sb = new StringBuffer();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        // Declare Handler
        DefaultHandler handler = new DefaultHandler() {
            public void characters(char ch[], int start, int length) throws SAXException {
                sb.append((new String(ch, start, length)));
            }
        };
        saxParser.parse(new InputSource(new StringReader(xmlStr)), handler);
        return sb.toString();
    }
    public static String xmlNodeToString(Document xmlNode) throws IOException {
        StringWriter out = new StringWriter();
        OutputFormat format = new OutputFormat(xmlNode);
        XMLSerializer serializer = new XMLSerializer(out, format);
        serializer.serialize(xmlNode);
        return out.toString();
    }

    public static XsltInfo XsltReader(String xsltFilePath) throws Exception {
        if(StringExtension.IsNullOrEmpty(xsltFilePath))
        {
            throw new IllegalArgumentException("Invalid xsltFilePath: ".concat(xsltFilePath));
        }
        xsltFilePath = PathExtension.FullPhysicalPath(xsltFilePath);
        return StaticMemoryCacheHelper.AddNeverExpiredMemoryCache("$XsltReader$".concat(xsltFilePath), new Operation<XsltInfo>(xsltFilePath) {
            @Override
            public XsltInfo call() throws Exception {
                String filePath = (String) this.params[0];
                Debugger.LogFactory.trace("read xslt meta : {}", filePath);
                XsltInfo xsltMeta = new XsltInfo();
                xsltMeta.XsltFilePath = filePath;
                xsltMeta.XsltContent = LinkFuture.Init.Utility.getStringFromFile(filePath);
                xsltMeta.ParameterList = findXSLTParameters(xsltMeta.XsltContent);
                return xsltMeta;
            }
        });
    }
    private static ArrayList<String> findXSLTParameters(String content) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Pattern pattern = Pattern.compile("<(xsl:param|xslt:param){1}[^>]*name\\s*=\\s*\"([^\"]*)\"[^>]*(/?)>", Pattern.CASE_INSENSITIVE);
        Matcher matcher = pattern.matcher(content);
        ArrayList<String> list = new ArrayList<>();
        while (matcher.find()) {
            list.add(matcher.group(2));
        }
        return list;
    }

    //</editor-folder >

    //<editor-folder desc = "JSON">
    //     public static String XmlToJson(String xml){
    //         org.json.JSONObject jsonObject=  org.json.XML.toJSONObject(xml);
    //         return jsonObject.toString(4);
    //     }
    //    public static String JsonToXml(String json){
    //        org.json.JSONObject jsonObject=  new org.json.JSONObject(json);
    //        return org.json.XML.toString(jsonObject);
    //    }
    //</editor-folder>

    //<editor-folder desc = "Enum Operation">
    /**
     * Case insensitive enum convert <p>
     * Sample: <p>
     *    assert CommandTypeInfo.StoredProcedure == CommandTypeInfo.valueOf("StoredProcedure"); <p>
     *    assert CommandTypeInfo.StoredProcedure == Enum.valueOf(CommandTypeInfo.class,"StoredProcedure"); <p>
     *    assert CommandTypeInfo.StoredProcedure == Utility.enumParser(CommandTypeInfo.class,"StOredProcedure"); <p>
     */
    public static<T> T enumParser(Class<T> type, String value) {
        for (T con: type.getEnumConstants())
        {
            if(con.toString().equalsIgnoreCase(value))
            {
                return con;
            }
        }
        return null;
    }
    //</editor-folder>

    @SuppressWarnings("unchecked")
    public static<T> T ReadContextValue(String configName) throws NamingException {
        javax.naming.InitialContext initialContext = new javax.naming.InitialContext();
        return (T)initialContext.lookup(configName);
    }

    public static Properties ReadProperties(String filePath) throws Exception {
        return StaticMemoryCacheHelper.AddNeverExpiredMemoryCache("$ReadProperties$".concat(filePath), new Operation<Properties>(filePath) {
            @Override
            public Properties call() throws Exception {
                String filePath = (String) this.params[0];
                Properties file = new Properties();
                file.load(LinkFuture.Init.Utility.getStreamFromFile(filePath));
                return file;  //To change body of implemented methods use File | Settings | File Templates.
            }
        });
    }


    public static boolean stringExpression(Map<String, Object> parameters, String condition)
    {
        StandardEvaluationContext context = new StandardEvaluationContext();
        ExpressionParser parser = new SpelExpressionParser();
        for(Map.Entry<String,Object> item: parameters.entrySet())
        {
            context.setVariable(item.getKey(),item.getValue());
        }
        return (boolean)parser.parseExpression(condition).getValue(context);
    }
}