package LinkFuture.Core.MemoryManager.StaticMemoryCache;

import LinkFuture.Core.MemoryManager.Meta.MemoryCacheMetaInfo;

import java.util.Date;

/**
 * User: Cyokin Zhang
 * Date: 10/12/13
 * Time: 2:19 PM
 */
public class StaticMemoryCacheInfo {
    public Object CachedObject;
    public long NextExpiredTime;
    public long CachedTime;
    public MemoryCacheMetaInfo Meta;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<Memory autoRefresh=\"").append(this.Meta.AutoRefresh).append("\" cacheType=\"").append(this.Meta.CacheType).append("\">");
        sb.append("<Key>");
        sb.append(this.Meta.getUniqueKey());
        sb.append("</Key>");
        sb.append("<CachedTime>");
        sb.append(new Date(this.CachedTime));
        sb.append("</CachedTime>");
        if(this.NextExpiredTime!=0)
        {
            sb.append("<NextExpiredTime>");
            sb.append(new Date(this.NextExpiredTime));
            sb.append("</NextExpiredTime>");
        }
        sb.append("</Memory>");
        return sb.toString();
    }
}
