package LinkFuture.Core.JsonManager;

import LinkFuture.Init.Extensions.StringExtension;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;


/**
 * User: Cyokin Zhang
 * Date: 10/23/13
 * Time: 12:19 PM
 */
public class JsonObjectInfo {
    public String XPath;
    public String Name;
    public String Value;
    public JsonObjectType Type;
    public ArrayList<JsonObjectInfo> ChildNodes;
    public JsonObjectInfo Parent;

    /*
    * get json value
    *   String|boolean|Number|Object
    * */
    public void getJsonValue(StringWriter writer,JsonOptionInfo option) throws IOException {
        String string = this.Value;
        if (StringExtension.IsNullOrEmpty(string)) {
            writer.write("null");
            return;
        }
        if(option.AutoNull && string.equalsIgnoreCase("null"))
        {
            writer.write("null");
            return;
        }
        switch (option.ValueOption)
        {
            case Auto:
                if (parseJsonBoolean(writer, string)) return;
                if (parseJsonNumber(writer, string)) return;
                break;
            case AllString:
                //do nothing
                break;
            case Force:
                if(option.ForceValueTypeList!=null && option.ForceValueTypeList.containsKey(this.XPath))
                {
                    JsonValueType valueType = option.ForceValueTypeList.get(this.XPath).ValueType;
                    switch (valueType)
                    {
                        case String:
                            StringExtension.JsonQuote(string,writer);
                            return;
                        case Number:
                            if (parseJsonNumber(writer, string)){
                                return;
                            }
                            else {
                                throw new IllegalArgumentException(String.format("the value(%s) not match the type(Number) you force declared",string));
                            }
                        case Boolean:
                            if (parseJsonBoolean(writer, string)){
                                return;
                            }
                            else {
                                throw new IllegalArgumentException(String.format("the value(%s) not match the type(Boolean) you force declared",string));
                            }
                    }
                }
                break;
        }
        StringExtension.JsonQuote(string,writer);
    }

    private boolean parseJsonBoolean(StringWriter writer, String string) {
        if (string.equalsIgnoreCase("true")) {
            writer.write("true");
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            writer.write("false");
            return true;
        }
        return false;
    }

    private boolean parseJsonNumber(StringWriter writer, String string) {
        Double d;
        char b = string.charAt(0);
        if ((b >= '0' && b <= '9') || b == '-') {
            try {
                if (string.indexOf('.') > -1 || string.indexOf('e') > -1
                        || string.indexOf('E') > -1) {
                    d = Double.valueOf(string);
                    if (!d.isInfinite() && !d.isNaN()) {
                        writer.write(d.toString());
                        return true;
                    }
                } else {
                    Long myLong = new Long(string);
                    if (string.equals(myLong.toString())) {
                        writer.write(myLong.toString());
                        return true;
                    }
                }
            }
            catch (Exception ignore) {
            }
        }
        return false;
    }

    public String toJson(){
        return toJson(new JsonOptionInfo());
    }
    public String toJson(JsonOptionInfo option){
        StringWriter writer = new StringWriter();
        writer.append('{');
        toJson(writer,option);
        writer.append('}');
        return writer.toString();
    }
    public void toJson(StringWriter writer,JsonOptionInfo option){
        try {
            StringExtension.JsonQuote(this.getJsonNodeName(option),writer);
            writer.append(':');
            toChildJson(writer,option);
        } catch (IOException ignored) {
            throw new RuntimeException(ignored);
        }
    }
    public String getJsonNodeName(JsonOptionInfo option){
        String nodeName = this.Name;
        if(option.IgnoreNamespace)
        {
            String[] index = this.Name.split(":");
            if(index.length==2)
            {
                nodeName =  index[1];
            }
        }
        if(option!=null)
        {
            switch (this.Type) {
                case Element:
                    return nodeName;
                case Attribute:
                    return option.AttributePrefix + nodeName;
                case Namespace:
                    return option.NamespacePrefix + nodeName;
                case CDATA:
                    return option.CDataNodeName;
            }
        }
        return nodeName;
    }
    public String toChildJson(JsonOptionInfo option) throws IOException {
        StringWriter w = new StringWriter();
        toChildJson(w,option);
        return w.toString();
    }
    public void toChildJson(StringWriter writer,JsonOptionInfo option) throws IOException {
        if(this.ChildNodes==null || this.ChildNodes.size()==0)
        {
            //StringExtension.JsonQuote(this.Value,writer);
            this.getJsonValue(writer,option);
        }
        else
        {
            //same name, json array, otherwise json object
            LinkedHashMap<String,ArrayList<JsonObjectInfo>> nameList = new LinkedHashMap<>();
            for (JsonObjectInfo item:this.ChildNodes)
            {
                //IgnoreNamespace
                if(item.Type == JsonObjectType.Namespace && option.IgnoreNamespace)
                {
                    continue;
                }
                ArrayList<JsonObjectInfo> list;
                if(nameList.containsKey(item.Name))
                {
                    list = nameList.get(item.Name);
                }
                else
                {
                    list = new ArrayList<>();
                }
                list.add(item);
                nameList.put(item.Name,list);
            }
            writer.append('{');
            //ideally we will never have an xml node with CDATA and children node
            //i.e <root>abc<c>aaa</c><root>
            if(!StringExtension.IsNullOrEmpty(this.Value))
            {
                writer.write(this.getJsonNodeName(option));
                writer.write(':');
                //StringExtension.JsonQuote(this.Value,writer);
                this.getJsonValue(writer,option);
                writer.write(',');
            }
            String key[] = nameList.keySet().toArray(new String[nameList.keySet().size()]);
            for (int i=0;i<nameList.keySet().size();i++)
            {
                String nodeKey = key[i];
                ArrayList<JsonObjectInfo> subList = nameList.get(nodeKey);
                //single object solution
                if(subList.size()==1 && !forceArrayXPath(option,subList.get(0).XPath))
                {
                    subList.get(0).toJson(writer,option);
                }
                else
                {
                    //json array solution
                      StringExtension.JsonQuote(subList.get(0).getJsonNodeName(option),writer);
                      writer.append(':');
                      writer.append('[');
                      for (int j=0;j<subList.size();j++)
                      {
                          JsonObjectInfo item = subList.get(j);
                          item.toChildJson(writer,option);
                          if(j<subList.size()-1)
                          {
                              writer.write(',');
                          }
                      }
                      writer.append(']');
                }
                if(i<key.length-1)
                {
                    writer.write(',');
                }
            }
            writer.append('}');
        }
    }
    public boolean forceArrayXPath(JsonOptionInfo option,String currentXPath){
        if(option.AllArray)
        {
            return true;
        }
        if(option==null || option.ForceArrayXPathList==null || option.ForceArrayXPathList.size()==0)
        {
            return false;
        }
        return option.ForceArrayXPathList.contains(currentXPath);
    }
}
