package LinkFuture.Core.GenericRepository.Repository;


import LinkFuture.Core.GenericRepository.Entity.*;

import java.io.Serializable;
import java.util.List;

/**
 * Created by Cyokin
 * on 10/14/2015.
 */
public interface IGenericRepository<T, ID extends Serializable> {
    <S extends T> ID insert(S obj) throws Exception;

    <S extends T> List<ID> insert(List<S> obj) throws Exception;

    <S extends T> Integer save(S obj) throws Exception;

    Integer save(GenericSet q) throws Exception;

    Integer delete(ID id) throws Exception;

    <S extends T> Integer delete(S obj) throws Exception;

    Integer delete(GenericWhere q) throws Exception;

    PageableList<T> findAll(Pageable pager) throws Exception;

    <S extends T> PageableList<T> find(S obj) throws Exception;

    T find(ID id) throws Exception;

    <S extends T> PageableList<T> find(S obj, Pageable pager) throws Exception;

    PageableList<T> find(GenericQuery q) throws Exception;
}
