package LinkFuture.Core.GenericRepository.Repository;

import LinkFuture.Core.ContentManager.ContentController;
import LinkFuture.Core.ContentManager.Model.ContentResultCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultInfo;
import LinkFuture.Core.ContentManager.Model.ContentType;
import LinkFuture.Core.ContentManager.Model.ResponseType;
import LinkFuture.Core.Utility;
import LinkFuture.Init.ObjectExtend.NameValuePair;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * Created by Cyokin
 * on 10/12/2015.
     @JsonIgnoreProperties(ignoreUnknown = true)
     @JsonInclude(JsonInclude.Include.NON_NULL)
     public class CityEntity {
         public static final String ID = "id";
         public static final String NAME = "name";
         public static final String ZONE_ID = "zone_id";
         public static final String CREATE_USER = "create_user";
         @JsonProperty(ID)
         @FieldAttribute(name = ID,isKey = true)
         public Long Id;

         @JsonProperty(NAME)
         @FieldAttribute(name = NAME)
         public String Name;

         @JsonProperty(ZONE_ID)
         @FieldAttribute(name = ZONE_ID)
         public Integer ZoneId;

         @JsonProperty(CREATE_USER)
         @FieldAttribute(name = CREATE_USER)
         public Integer CreateUser;

         @JsonFormat(shape= JsonFormat.Shape.STRING, pattern= Config.DefaultTimeFormat)
         @JsonProperty("create_time")
         @FieldAttribute(name = "create_time")
         public Date CreateTime;
     }
     Notice: make sure use Integer/Long type, instead of int/long type, as int/long is not null able type.
 */

public abstract class GenericRepository<T,ID extends Serializable> extends BaseRepository<T,ID> implements IGenericRepository<T,ID> {

    public GenericRepository(String requestPath) {
        super(requestPath);
    }

    @Override
    protected <T> Object genericDBResourceLoad(String contentName,LinkFuture.Core.WebClient.HttpMethod method,T requestObject) throws Exception{
        ArrayList<NameValuePair> list = new ArrayList<>();
        list.add(new NameValuePair(ContentController.LF_HTTP_METHOD,method));
        list.add(new NameValuePair(ContentController.LF_RESPONSE_TYPE, ResponseType.Json));
        if(method==LinkFuture.Core.WebClient.HttpMethod.Get || method == LinkFuture.Core.WebClient.HttpMethod.Delete)
        {
            list.add(new NameValuePair(JSON_QUERY, Utility.jacksonToJson(requestObject)));
        }
        else
        {
            list.add(new NameValuePair(ContentController.LF_CONTENT_TYPE, ContentType.Json));
            list.add(new NameValuePair(ContentController.LF_PLAY_LOAD, Utility.jacksonToJson(requestObject)));
        }
        ContentResultCollectionInfo result = ContentController.LoadContent(contentName,null,list,false,true);
        if(result.size() > 0)
        {
            ContentResultInfo myResult =  result.get(0);
            if(myResult.Success)
            {
                logger.trace(myResult.Result==null?"No result found":myResult.Result.toString());
                return myResult.Result;
            }
        }
        throw new IllegalArgumentException("No result found");
    }
    @Override
    protected <T> Object genericDBResourceLoad(LinkFuture.Core.WebClient.HttpMethod method,T requestObject) throws Exception {
        return genericDBResourceLoad(this.requestPath,method,requestObject);
    }


}
